/*
 * Decompiled with CFR 0.152.
 */
package com.mickaelb.integration.hibernate;

import com.mickaelb.integration.hibernate.HibernateStatementListener;
import com.mickaelb.integration.hibernate.HibernateStatementParser;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;

public class JSQLHibernateStatementParser
implements HibernateStatementParser {
    @Override
    public void parseSqlStatement(final String sql, final HibernateStatementListener statementCountListener) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            statement.accept((StatementVisitor)new StatementVisitorAdapter(){

                public void visit(Select select) {
                    statementCountListener.notifySelectStatement(sql);
                }

                public void visit(Insert insert) {
                    statementCountListener.notifyInsertStatement(sql);
                }

                public void visit(Update update) {
                    statementCountListener.notifyUpdateStatement(sql);
                }

                public void visit(Delete delete) {
                    statementCountListener.notifyDeleteStatement(sql);
                }
            });
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }
}

