/*
 * Decompiled with CFR 0.152.
 */
package com.mickaelb.integration.spring;

import com.mickaelb.api.AssertHibernateL2CCount;
import com.mickaelb.integration.spring.AssertTestListener;
import com.mickaelb.integration.spring.assertions.l2c.HibernateL2CAssertionResult;
import com.mickaelb.integration.spring.assertions.l2c.HibernateL2CAssertionResults;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import org.springframework.test.context.TestContext;

public class HibernateL2CCountTestListener
implements AssertTestListener {
    private Statistics sessionFactoryStatistics;

    @Override
    public void beforeTestClass(TestContext testContext) {
        SessionFactory sessionFactory = (SessionFactory)testContext.getApplicationContext().getAutowireCapableBeanFactory().getBean(SessionFactory.class);
        this.sessionFactoryStatistics = sessionFactory.getStatistics();
        this.sessionFactoryStatistics.setStatisticsEnabled(true);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        this.sessionFactoryStatistics.clear();
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        AssertHibernateL2CCount l2cCountAnnotation = testContext.getTestMethod().getAnnotation(AssertHibernateL2CCount.class);
        if (l2cCountAnnotation != null) {
            this.evaluateL2CCount(l2cCountAnnotation);
        }
    }

    private void evaluateL2CCount(AssertHibernateL2CCount annotation) {
        HibernateL2CAssertionResults assertionResults = new HibernateL2CAssertionResults(List.of(new HibernateL2CAssertionResult(HibernateL2CAssertionResult.CacheAction.HIT, this.sessionFactoryStatistics.getSecondLevelCacheHitCount(), annotation.hits()), new HibernateL2CAssertionResult(HibernateL2CAssertionResult.CacheAction.MISS, this.sessionFactoryStatistics.getSecondLevelCacheMissCount(), annotation.misses()), new HibernateL2CAssertionResult(HibernateL2CAssertionResult.CacheAction.PUT, this.sessionFactoryStatistics.getSecondLevelCachePutCount(), annotation.puts())));
        assertionResults.validate();
    }

    Statistics getSessionFactoryStatistics() {
        return this.sessionFactoryStatistics;
    }

    void setSessionFactoryStatistics(Statistics sessionFactoryStatistics) {
        this.sessionFactoryStatistics = sessionFactoryStatistics;
    }
}

