/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.entities;

import com.hpe.adm.nga.sdk.entities.create.CreateEntities;
import com.hpe.adm.nga.sdk.entities.delete.DeleteEntities;
import com.hpe.adm.nga.sdk.entities.delete.DeleteEntity;
import com.hpe.adm.nga.sdk.entities.get.GetEntities;
import com.hpe.adm.nga.sdk.entities.get.GetEntity;
import com.hpe.adm.nga.sdk.entities.update.UpdateEntities;
import com.hpe.adm.nga.sdk.entities.update.UpdateEntity;
import com.hpe.adm.nga.sdk.manualtests.TestStepList;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;

public class EntityList {
    protected final String urlDomain;
    protected final OctaneHttpClient octaneHttpClient;

    public EntityList(OctaneHttpClient octaneHttpClient, String entityListDomain) {
        this.octaneHttpClient = octaneHttpClient;
        this.urlDomain = entityListDomain;
    }

    public Entities at(String entityId) {
        return this.isTestEntity() ? new TestEntities(entityId) : new Entities(entityId);
    }

    public GetEntities get() {
        return new GetEntities(this.octaneHttpClient, this.urlDomain);
    }

    public UpdateEntities update() {
        return new UpdateEntities(this.octaneHttpClient, this.urlDomain);
    }

    public CreateEntities create() {
        return new CreateEntities(this.octaneHttpClient, this.urlDomain);
    }

    public DeleteEntities delete() {
        return new DeleteEntities(this.octaneHttpClient, this.urlDomain);
    }

    private boolean isTestEntity() {
        return this.urlDomain.endsWith("manual_tests") || this.urlDomain.endsWith("gherkin_tests");
    }

    public class TestEntities
    extends Entities {
        public TestEntities(String entityId) {
            super(entityId);
        }

        public TestStepList getTestSteps() {
            return new TestStepList(EntityList.this.octaneHttpClient, EntityList.this.urlDomain.substring(0, EntityList.this.urlDomain.lastIndexOf(47) + 1), this.entityId);
        }
    }

    public class Entities {
        protected final String entityId;

        public Entities(String entityId) {
            this.entityId = entityId;
        }

        public GetEntity get() {
            return new GetEntity(EntityList.this.octaneHttpClient, EntityList.this.urlDomain, this.entityId);
        }

        public UpdateEntity update() {
            return new UpdateEntity(EntityList.this.octaneHttpClient, EntityList.this.urlDomain, this.entityId);
        }

        public DeleteEntity delete() {
            return new DeleteEntity(EntityList.this.octaneHttpClient, EntityList.this.urlDomain, this.entityId);
        }
    }
}

