/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.entities.get;

import com.hpe.adm.nga.sdk.APIMode;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.entities.get.GetHelper;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneRequest;
import com.hpe.adm.nga.sdk.query.Query;

public class GetEntities {
    protected final OctaneRequest octaneRequest;

    public GetEntities(OctaneHttpClient octaneHttpClient, String urlDomain) {
        this.octaneRequest = new OctaneRequest(octaneHttpClient, urlDomain);
    }

    public OctaneCollection<EntityModel> execute() {
        return GetHelper.getInstance().getEntityModels(this.octaneRequest);
    }

    public OctaneCollection<EntityModel> execute(APIMode apiMode) {
        this.octaneRequest.addHeader(apiMode);
        OctaneCollection<EntityModel> result = this.execute();
        this.octaneRequest.removeHeader(apiMode);
        return result;
    }

    public GetEntities addFields(String ... fields) {
        this.octaneRequest.getOctaneUrl().addFieldsParam(fields);
        return this;
    }

    public GetEntities limit(int limit) {
        this.octaneRequest.getOctaneUrl().setLimitParam(limit);
        return this;
    }

    public GetEntities offset(int offset) {
        this.octaneRequest.getOctaneUrl().setOffsetParam(offset);
        return this;
    }

    public GetEntities addOrderBy(String orderBy, boolean asc) {
        this.octaneRequest.getOctaneUrl().setOrderByParam(orderBy, asc);
        return this;
    }

    public GetEntities query(Query query) {
        this.octaneRequest.getOctaneUrl().setDqlQueryParam(query);
        return this;
    }

    public GetEntities addPath(String path) {
        this.octaneRequest.getOctaneUrl().getPaths().add(path);
        return this;
    }
}

