/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.metadata;

import com.google.gson.Gson;
import com.hpe.adm.nga.sdk.metadata.EntityMetadata;
import com.hpe.adm.nga.sdk.metadata.MetadataOctaneRequest;
import com.hpe.adm.nga.sdk.metadata.features.AttachmentsFeature;
import com.hpe.adm.nga.sdk.metadata.features.AuditingFeature;
import com.hpe.adm.nga.sdk.metadata.features.BusinessRulesFeature;
import com.hpe.adm.nga.sdk.metadata.features.CommentsFeature;
import com.hpe.adm.nga.sdk.metadata.features.Feature;
import com.hpe.adm.nga.sdk.metadata.features.GroupingFeature;
import com.hpe.adm.nga.sdk.metadata.features.HierarchyFeature;
import com.hpe.adm.nga.sdk.metadata.features.MailingFeature;
import com.hpe.adm.nga.sdk.metadata.features.OrderingFeature;
import com.hpe.adm.nga.sdk.metadata.features.PhasesFeature;
import com.hpe.adm.nga.sdk.metadata.features.RestFeature;
import com.hpe.adm.nga.sdk.metadata.features.SubTypesFeature;
import com.hpe.adm.nga.sdk.metadata.features.SubTypesOfFeature;
import com.hpe.adm.nga.sdk.metadata.features.UdfFearture;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneHttpRequest;
import com.hpe.adm.nga.sdk.network.OctaneHttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetEntityMetadata
extends MetadataOctaneRequest {
    private static final String TYPE_NAME_ENTITIES_NAME = "entities";
    private static final String QUERY_NAME_FIELD_NAME = "name";
    private final Logger logger = LoggerFactory.getLogger((String)GetEntityMetadata.class.getName());
    private static final String JSON_NAME_FIELD_NAME = "name";
    private static final String JSON_LABEL_FIELD_NAME = "label";
    private static final String LOGGER_INVALID_FEATURE_FORMAT = "{}: not a valid feature";
    private static final String JSON_FEATURES_FIELD_NAME = "features";
    private static final String FEATURE_REST_NAME = "rest";
    private static final String FEATURE_MAILING_NAME = "mailing";
    private static final String FEATURE_HAS_ATTACHMENTS_NAME = "attachments";
    private static final String FEATURE_HAS_COMMENTS_NAME = "comments";
    private static final String FEATURE_BUSINESS_RULES_NAME = "business_rules";
    private static final String FEATURE_SUBTYPES_NAME = "subtypes";
    private static final String FEATURE_SUBTYPE_OF_NAME = "subtype_of";
    private static final String FEATURE_HIERARCHY_NAME = "hierarchy";
    private static final String FEATURE_UDF_ENTITY_NAME = "user_defined_fields";
    private static final String FEATURE_ORDERING_ENTITY_NAME = "ordering";
    private static final String FEATURE_GROUPING_ENTITY_NAME = "grouping";
    private static final String FEATURE_PHASES_ENTITY_NAME = "phases";
    private static final String FEATURE_AUDITING_ENTITY_NAME = "auditing";

    protected GetEntityMetadata(OctaneHttpClient octaneHttpClient, String urlDomain) {
        super(octaneHttpClient, urlDomain + "/" + TYPE_NAME_ENTITIES_NAME);
    }

    public GetEntityMetadata addEntities(String ... entities) {
        return (GetEntityMetadata)super.addEntities("name", entities);
    }

    public Collection<EntityMetadata> execute() {
        Collection<EntityMetadata> entitiesMetadata = null;
        String json = "";
        OctaneHttpRequest.GetOctaneHttpRequest octaneHttpRequest = new OctaneHttpRequest.GetOctaneHttpRequest(this.octaneRequest.getFinalRequestUrl());
        OctaneHttpResponse response = this.octaneHttpClient.execute(octaneHttpRequest);
        if (response.isSuccessStatusCode()) {
            json = response.getContent();
            entitiesMetadata = this.getEntitiesMetadata(json);
        }
        this.logger.debug("Response_Json: {}", (Object)json);
        return entitiesMetadata;
    }

    private Collection<EntityMetadata> getEntitiesMetadata(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        JSONArray jsonDataArr = jsonObj.getJSONArray("data");
        ArrayList<EntityMetadata> entitiesMetadata = new ArrayList<EntityMetadata>();
        IntStream.range(0, jsonDataArr.length()).forEach(i -> entitiesMetadata.add(this.getEntityMetadata(jsonDataArr.getJSONObject(i))));
        return entitiesMetadata;
    }

    private EntityMetadata getEntityMetadata(JSONObject jsonEntityObj) {
        HashSet<Feature> features = new HashSet<Feature>();
        String name = jsonEntityObj.getString("name");
        String label = jsonEntityObj.getString(JSON_LABEL_FIELD_NAME);
        JSONArray jsonFeatures = jsonEntityObj.getJSONArray(JSON_FEATURES_FIELD_NAME);
        IntStream.range(0, jsonFeatures.length()).forEach(i -> {
            Feature featureObject = this.getFeatureObject(jsonFeatures.getJSONObject(i));
            if (featureObject != null) {
                features.add(featureObject);
            }
        });
        return new EntityMetadata(name, label, false, features);
    }

    private Feature getFeatureObject(JSONObject jsonFeatureObj) {
        String featureName;
        Feature feature = null;
        switch (featureName = jsonFeatureObj.getString("name")) {
            case "rest": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), RestFeature.class);
                break;
            }
            case "mailing": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), MailingFeature.class);
                break;
            }
            case "attachments": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), AttachmentsFeature.class);
                break;
            }
            case "comments": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), CommentsFeature.class);
                break;
            }
            case "business_rules": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), BusinessRulesFeature.class);
                break;
            }
            case "subtypes": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), SubTypesFeature.class);
                break;
            }
            case "subtype_of": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), SubTypesOfFeature.class);
                break;
            }
            case "hierarchy": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), HierarchyFeature.class);
                break;
            }
            case "user_defined_fields": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), UdfFearture.class);
                break;
            }
            case "ordering": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), OrderingFeature.class);
                break;
            }
            case "grouping": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), GroupingFeature.class);
                break;
            }
            case "phases": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), PhasesFeature.class);
                break;
            }
            case "auditing": {
                feature = (Feature)new Gson().fromJson(jsonFeatureObj.toString(), AuditingFeature.class);
                break;
            }
            default: {
                this.logger.debug(LOGGER_INVALID_FEATURE_FORMAT, (Object)featureName);
            }
        }
        return feature;
    }
}

