/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.model;

import com.hpe.adm.nga.sdk.model.Entity;
import com.hpe.adm.nga.sdk.model.FieldModel;
import com.hpe.adm.nga.sdk.model.ModelParser;
import com.hpe.adm.nga.sdk.model.StringFieldModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityModel
implements Entity {
    public static final String ID_FIELD_NAME = "id";
    public static final String CLIENT_LOCK_STAMP_FIELD_NAME = "client_lock_stamp";
    private final DirtyHashMap data;

    public EntityModel() {
        this(null, EntityState.DIRTY);
    }

    public EntityModel(Set<FieldModel> values) {
        this(values, EntityState.DIRTY);
    }

    public EntityModel(Set<FieldModel> values, EntityState entityState) {
        this.data = new DirtyHashMap(entityState);
        if (values != null) {
            values.forEach(field -> this.data.put(field.getName(), (FieldModel)field));
        }
        this.data.entityState = EntityState.DIRTY;
    }

    public EntityModel(String key, String value) {
        this();
        StringFieldModel fldModel = new StringFieldModel(key, value);
        this.data.put(key, fldModel);
    }

    public Set<FieldModel> getValues() {
        return new HashSet<FieldModel>(this.data.values());
    }

    Collection<FieldModel> getDirtyValues() {
        return this.data.dirtyValues();
    }

    public FieldModel getValue(String key) {
        return (FieldModel)this.data.get(key);
    }

    public void removeValue(String key) {
        this.data.remove(key);
    }

    public EntityModel setValues(Set<FieldModel> values) {
        if (values != null) {
            this.data.clear();
            values.forEach(field -> this.data.put(field.getName(), (FieldModel)field));
        }
        return this;
    }

    public EntityModel setValue(FieldModel fieldModel) {
        this.data.put(fieldModel.getName(), fieldModel);
        return this;
    }

    @Override
    public final String getType() {
        StringFieldModel type = (StringFieldModel)this.getValue("type");
        return type == null ? null : type.getValue();
    }

    @Override
    public final String getId() {
        StringFieldModel id = (StringFieldModel)this.getValue(ID_FIELD_NAME);
        return id == null ? null : id.getValue();
    }

    public String toString() {
        return ModelParser.getInstance().getEntityJSONObject(this).toString();
    }

    private final class DirtyHashMap
    extends HashMap<String, FieldModel> {
        private final Collection<String> dirtyFields = new HashSet<String>();
        private EntityState entityState;

        private DirtyHashMap(EntityState entityState) {
            this.entityState = entityState;
        }

        @Override
        public final FieldModel put(String key, FieldModel value) {
            if (this.entityState == EntityState.DIRTY) {
                this.dirtyFields.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public FieldModel remove(Object key) {
            if (this.entityState == EntityState.DIRTY) {
                this.dirtyFields.add((String)key);
            }
            return (FieldModel)super.remove(key);
        }

        @Override
        public void clear() {
            super.clear();
            this.dirtyFields.clear();
        }

        private Collection<FieldModel> dirtyValues() {
            return this.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(EntityModel.ID_FIELD_NAME) || ((String)entry.getKey()).equals(EntityModel.CLIENT_LOCK_STAMP_FIELD_NAME) || this.dirtyFields.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }

    public static enum EntityState {
        CLEAN,
        DIRTY;

    }
}

