/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network.jetty;

import com.google.api.client.http.GenericUrl;
import com.hpe.adm.nga.sdk.Octane;
import com.hpe.adm.nga.sdk.authentication.JSONAuthentication;
import com.hpe.adm.nga.sdk.authentication.SessionIdAuthentication;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.exception.OctaneException;
import com.hpe.adm.nga.sdk.exception.OctanePartialException;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.ErrorModel;
import com.hpe.adm.nga.sdk.model.LongFieldModel;
import com.hpe.adm.nga.sdk.model.ModelParser;
import com.hpe.adm.nga.sdk.model.StringFieldModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneHttpRequest;
import com.hpe.adm.nga.sdk.network.OctaneHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpClient
implements OctaneHttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)JettyHttpClient.class.getName());
    private static final String LOGGER_REQUEST_FORMAT = "Request: {} - {} - {}";
    private static final String LOGGER_RESPONSE_FORMAT = "Response: {} - {} - {}";
    private static final String SET_COOKIE = "set-cookie";
    private static final String HTTP_MULTIPART_BOUNDARY_VALUE = "---------------------------92348603315617859231724135434";
    private static final String HTTP_MULTIPART_PART1_DISPOSITION_ENTITY_VALUE = "entity";
    private static final String ERROR_CODE_TOKEN_EXPIRED = "VALIDATION_TOKEN_EXPIRED_IDLE_TIME_OUT";
    private static final String ERROR_CODE_GLOBAL_TOKEN_EXPIRED = "VALIDATION_TOKEN_EXPIRED_GLOBAL_TIME_OUT";
    private static final int HTTP_REQUEST_RETRY_COUNT = 1;
    private boolean areNewCookiesReceived;
    protected RequestFactory requestFactory;
    protected String lwssoValue = "";
    protected String octaneUserValue;
    protected final String urlDomain;
    protected com.hpe.adm.nga.sdk.authentication.Authentication lastUsedAuthentication;
    protected Long lastSuccessfulAuthTimestamp;
    private final Map<OctaneHttpRequest, OctaneHttpResponse> cachedRequestToResponse = new HashMap<OctaneHttpRequest, OctaneHttpResponse>();
    private final Map<OctaneHttpRequest, String> requestToEtagMap = new HashMap<OctaneHttpRequest, String>();
    private final ThreadLocal<Long> requestStartTime = new ThreadLocal();
    private final Phaser requestPhaser = new Phaser(1);

    public JettyHttpClient(String urlDomain, com.hpe.adm.nga.sdk.authentication.Authentication authentication) {
        this.urlDomain = urlDomain;
        this.lastUsedAuthentication = authentication;
        this.logSystemProperties();
        Log.setLog((org.eclipse.jetty.util.log.Logger)new StdErrLog());
        HttpClient client = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(new HTTP2Client()), (SslContextFactory)new SslContextFactory.Client());
        this.addAuthentication(client);
        client.setIdleTimeout(6000L);
        try {
            client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.requestFactory = new RequestFactory(this, client);
    }

    public JettyHttpClient(String urlDomain, com.hpe.adm.nga.sdk.authentication.Authentication authentication, Octane.OctaneCustomSettings settings) throws RuntimeException {
        this.urlDomain = urlDomain;
        this.lastUsedAuthentication = authentication;
        this.logSystemProperties();
        Log.setLog((org.eclipse.jetty.util.log.Logger)new StdErrLog());
        HttpClientTransport httpTransport = (HttpClientTransport)settings.get(Octane.OctaneCustomSettings.Setting.SHARED_HTTP_TRANSPORT);
        boolean trustAllCerts = (Boolean)settings.get(Octane.OctaneCustomSettings.Setting.TRUST_ALL_CERTS);
        HttpClient client = httpTransport != null ? new HttpClient(httpTransport, (SslContextFactory)new SslContextFactory.Client(trustAllCerts)) : new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(new HTTP2Client()), (SslContextFactory)new SslContextFactory.Client(trustAllCerts));
        this.addAuthentication(client);
        client.setConnectTimeout((long)((Integer)settings.get(Octane.OctaneCustomSettings.Setting.CONNECTION_TIMEOUT)).intValue());
        client.setIdleTimeout((long)((Integer)settings.get(Octane.OctaneCustomSettings.Setting.READ_TIMEOUT)).intValue());
        try {
            client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.requestFactory = new RequestFactory(this, client);
    }

    private void addAuthentication(HttpClient client) {
        if (this.lastUsedAuthentication != null && this.lastUsedAuthentication.isBasicAuthentication()) {
            com.hpe.adm.nga.sdk.authentication.BasicAuthentication basicAuthentication = (com.hpe.adm.nga.sdk.authentication.BasicAuthentication)this.lastUsedAuthentication;
            client.getAuthenticationStore().addAuthentication((Authentication)new BasicAuthentication(URI.create(this.urlDomain), "<<ANY_REALM>>", basicAuthentication.getAuthenticationId(), basicAuthentication.getAuthenticationSecret()));
        }
    }

    @Override
    public boolean authenticate() {
        if (this.lastUsedAuthentication == null) {
            return false;
        }
        if (this.lastUsedAuthentication.isBasicAuthentication()) {
            return true;
        }
        if (this.lastUsedAuthentication.isSessionIdAuthentication()) {
            this.lwssoValue = ((SessionIdAuthentication)this.lastUsedAuthentication).getSessionID();
            return true;
        }
        this.lwssoValue = null;
        this.octaneUserValue = null;
        ByteBufferContentProvider content = new ByteBufferContentProvider("application/json", new ByteBuffer[]{ByteBuffer.wrap(((JSONAuthentication)this.lastUsedAuthentication).getAuthenticationString().getBytes(StandardCharsets.UTF_8))});
        Request httpRequest = this.requestFactory.buildPostRequest(URI.create(this.urlDomain + "/authentication/sign_in"), (ContentProvider)content);
        this.lastUsedAuthentication.getAPIMode().ifPresent(apiMode -> httpRequest.getHeaders().remove(apiMode.getHeaderKey()));
        ContentResponse response = this.executeRequest(httpRequest);
        if (HttpStatus.isSuccess((int)response.getStatus())) {
            this.lastSuccessfulAuthTimestamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void signOut() {
        Request httpRequest = null;
        try {
            httpRequest = this.requestFactory.buildPostRequest(URI.create(this.urlDomain + "/authentication/sign_out"), null);
            ContentResponse response = this.executeRequest(httpRequest);
            if (HttpStatus.isSuccess((int)response.getStatus())) {
                this.updateLWSSOCookieValue((Response)response);
                this.lastUsedAuthentication = null;
            }
        }
        catch (Exception e) {
            throw JettyHttpClient.wrapException(e, httpRequest);
        }
    }

    protected Request convertOctaneRequestToGoogleHttpRequest(OctaneHttpRequest octaneHttpRequest) {
        Request httpRequest;
        try {
            switch (octaneHttpRequest.getOctaneRequestMethod()) {
                case GET: {
                    String eTagHeader;
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildGetRequest(domain.toURI());
                    if (((OctaneHttpRequest.GetOctaneHttpRequest)octaneHttpRequest).getAcceptType() != null) {
                        httpRequest.getHeaders().add(HttpHeader.ACCEPT, ((OctaneHttpRequest.GetOctaneHttpRequest)octaneHttpRequest).getAcceptType());
                    }
                    if ((eTagHeader = this.requestToEtagMap.get(octaneHttpRequest)) == null) break;
                    httpRequest.getHeaders().add(HttpHeader.ETAG, eTagHeader);
                    break;
                }
                case POST: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    OctaneHttpRequest.PostOctaneHttpRequest postOctaneHttpRequest = (OctaneHttpRequest.PostOctaneHttpRequest)octaneHttpRequest;
                    httpRequest = this.requestFactory.buildPostRequest(domain.toURI(), (ContentProvider)new ByteBufferContentProvider(postOctaneHttpRequest.getContentType(), new ByteBuffer[]{ByteBuffer.wrap(postOctaneHttpRequest.getContent().getBytes(StandardCharsets.UTF_8))}));
                    if (postOctaneHttpRequest.getAcceptType() == null) break;
                    httpRequest.getHeaders().add(HttpHeader.ACCEPT, postOctaneHttpRequest.getAcceptType());
                    break;
                }
                case POST_BINARY: {
                    httpRequest = this.buildBinaryPostRequest((OctaneHttpRequest.PostBinaryOctaneHttpRequest)octaneHttpRequest);
                    break;
                }
                case POST_BINARY_MULTIPART: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    OctaneHttpRequest.PostBinaryBulkOctaneHttpRequest postBinaryBulkOctaneHttpRequest = (OctaneHttpRequest.PostBinaryBulkOctaneHttpRequest)octaneHttpRequest;
                    httpRequest = this.requestFactory.buildPostRequest(domain.toURI(), (ContentProvider)this.generateBinaryBulkPostRequest(postBinaryBulkOctaneHttpRequest));
                    if (postBinaryBulkOctaneHttpRequest.getAcceptType() == null) break;
                    httpRequest.getHeaders().add(HttpHeader.ACCEPT, postBinaryBulkOctaneHttpRequest.getAcceptType());
                    break;
                }
                case PUT: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    OctaneHttpRequest.PutOctaneHttpRequest putHttpOctaneHttpRequest = (OctaneHttpRequest.PutOctaneHttpRequest)octaneHttpRequest;
                    httpRequest = this.requestFactory.buildPutRequest(domain.toURI(), (ContentProvider)new ByteBufferContentProvider(putHttpOctaneHttpRequest.getContentType(), new ByteBuffer[]{ByteBuffer.wrap(putHttpOctaneHttpRequest.getContent().getBytes(StandardCharsets.UTF_8))}));
                    if (putHttpOctaneHttpRequest.getAcceptType() == null) break;
                    httpRequest.getHeaders().add(HttpHeader.ACCEPT, putHttpOctaneHttpRequest.getAcceptType());
                    break;
                }
                case DELETE: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildDeleteRequest(domain.toURI());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Request method not known!");
                }
            }
            octaneHttpRequest.getHeaders().forEach(header -> httpRequest.getHeaders().add(header.getHeaderKey(), header.getHeaderValue()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return httpRequest;
    }

    protected OctaneHttpResponse convertHttpResponseToOctaneHttpResponse(ContentResponse httpResponse) {
        Charset charset = Objects.nonNull(httpResponse.getHeaders().get(HttpHeader.CONTENT_TYPE)) && httpResponse.getHeaders().get(HttpHeader.CONTENT_TYPE).equals("application/json") || httpResponse.getHeaders().get(HttpHeader.CONTENT_TYPE).equals("text.csv") ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        return new OctaneHttpResponse(httpResponse.getStatus(), new ByteArrayInputStream(httpResponse.getContent()), charset);
    }

    @Override
    public OctaneHttpResponse execute(OctaneHttpRequest octaneHttpRequest) {
        return this.execute(octaneHttpRequest, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OctaneHttpResponse execute(OctaneHttpRequest octaneHttpRequest, int retryCount) {
        try {
            ContentResponse httpResponse;
            try {
                this.registerNewRequest();
                Request httpRequest = this.convertOctaneRequestToGoogleHttpRequest(octaneHttpRequest);
                httpResponse = this.executeRequest(httpRequest);
            }
            finally {
                this.requestPhaser.arriveAndDeregister();
            }
            OctaneHttpResponse octaneHttpResponse = this.convertHttpResponseToOctaneHttpResponse(httpResponse);
            String eTag = httpResponse.getHeaders().get(HttpHeader.ETAG);
            if (eTag != null) {
                this.requestToEtagMap.put(octaneHttpRequest, eTag);
                this.cachedRequestToResponse.put(octaneHttpRequest, octaneHttpResponse);
            }
            return octaneHttpResponse;
        }
        catch (RuntimeException exception) {
            HttpResponseException httpResponseException;
            int statusCode;
            if (exception.getCause() instanceof HttpResponseException && (statusCode = (httpResponseException = (HttpResponseException)exception.getCause()).getResponse().getStatus()) == 304) {
                return this.cachedRequestToResponse.get(octaneHttpRequest);
            }
            if (retryCount > 0 && exception instanceof OctaneException) {
                OctaneException octaneException = (OctaneException)exception;
                StringFieldModel errorCodeFieldModel = (StringFieldModel)octaneException.getError().getValue("errorCode");
                LongFieldModel httpStatusCode = (LongFieldModel)octaneException.getError().getValue("http_status_code");
                if (errorCodeFieldModel != null && httpStatusCode.getValue() == 401L && (ERROR_CODE_TOKEN_EXPIRED.equals(errorCodeFieldModel.getValue()) || ERROR_CODE_GLOBAL_TOKEN_EXPIRED.equals(errorCodeFieldModel.getValue())) && this.lastUsedAuthentication != null) {
                    JettyHttpClient jettyHttpClient = this;
                    synchronized (jettyHttpClient) {
                        if (this.lastSuccessfulAuthTimestamp < this.requestStartTime.get()) {
                            this.requestPhaser.arriveAndAwaitAdvance();
                            logger.debug("Auth token expired, trying to re-authenticate");
                            try {
                                this.authenticate();
                            }
                            catch (OctaneException ex) {
                                logger.debug("Exception while retrying authentication: {}", (Object)ex.getMessage());
                            }
                        } else {
                            logger.debug("Auth token expired, but re-authentication was handled by another thread, will not re-authenticate");
                        }
                        logger.debug("Retrying request, retries left: {}", (Object)retryCount);
                    }
                    return this.execute(octaneHttpRequest, --retryCount);
                }
            }
            throw exception;
        }
    }

    private ContentResponse executeRequest(Request httpRequest) {
        ContentResponse response;
        logger.debug(LOGGER_REQUEST_FORMAT, new Object[]{httpRequest.getMethod(), httpRequest.getURI().toString(), httpRequest.getHeaders().stream().collect(Collectors.toList())});
        ContentProvider content = httpRequest.getContent();
        if (content != null && logger.isDebugEnabled() && !httpRequest.getURI().toString().contains("/authentication/sign_in")) {
            JettyHttpClient.logHttpContent(new HttpContent(content));
        }
        try {
            this.requestStartTime.set(System.currentTimeMillis());
            if (httpRequest.getPath().contains("metadata")) {
                FutureResponseListener listener = new FutureResponseListener(httpRequest, 0xA00000);
                httpRequest.send((Response.CompleteListener)listener);
                response = listener.get(2L, TimeUnit.SECONDS);
            } else {
                response = httpRequest.send();
            }
            if (response.getStatus() / 10 == 40) {
                throw new Exception(response.getReason(), (Throwable)new HttpResponseException(response.getReason(), (Response)response));
            }
        }
        catch (Exception e) {
            throw JettyHttpClient.wrapException(e, httpRequest);
        }
        logger.debug(LOGGER_RESPONSE_FORMAT, new Object[]{response.getStatus(), response.getReason(), response.getHeaders().stream().collect(Collectors.toList())});
        return response;
    }

    private synchronized void registerNewRequest() {
        if (this.areNewCookiesReceived) {
            this.requestPhaser.arriveAndAwaitAdvance();
            this.areNewCookiesReceived = false;
        }
        this.requestPhaser.register();
    }

    private Request buildBinaryPostRequest(OctaneHttpRequest.PostBinaryOctaneHttpRequest octaneHttpRequest) throws IOException {
        GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
        Request httpRequest = this.requestFactory.buildPostRequest(domain.toURI(), (ContentProvider)this.generateMultiPartContent(octaneHttpRequest));
        if (octaneHttpRequest.getAcceptType() != null) {
            httpRequest.getHeaders().add(HttpHeader.ACCEPT, octaneHttpRequest.getAcceptType());
        }
        return httpRequest;
    }

    private MultiPartContentProvider generateBinaryBulkPostRequest(OctaneHttpRequest.PostBinaryBulkOctaneHttpRequest postBinaryBulkOctaneHttpRequest) {
        MultiPartContentProvider content = new MultiPartContentProvider(HTTP_MULTIPART_BOUNDARY_VALUE);
        postBinaryBulkOctaneHttpRequest.getBinaryFileInfo().forEach(binaryFile -> this.addBinaryFileToMultiPart(content, postBinaryBulkOctaneHttpRequest.getBinaryContentType(), (Triple<String, InputStream, String>)binaryFile));
        return content;
    }

    private MultiPartContentProvider generateMultiPartContent(OctaneHttpRequest.PostBinaryOctaneHttpRequest octaneHttpRequest) {
        MultiPartContentProvider content = new MultiPartContentProvider(HTTP_MULTIPART_BOUNDARY_VALUE);
        return this.addBinaryFileToMultiPart(content, octaneHttpRequest.getBinaryContentType(), (Triple<String, InputStream, String>)Triple.of((Object)octaneHttpRequest.getContent(), (Object)octaneHttpRequest.getBinaryInputStream(), (Object)octaneHttpRequest.getBinaryContentName()));
    }

    private MultiPartContentProvider addBinaryFileToMultiPart(MultiPartContentProvider content, String contentType, Triple<String, InputStream, String> binaryContent) {
        ByteBufferContentProvider byteArrayContent = new ByteBufferContentProvider("application/json", new ByteBuffer[]{ByteBuffer.wrap(((String)binaryContent.getLeft()).getBytes(StandardCharsets.UTF_8))});
        HttpFields httpHeaders = new HttpFields();
        httpHeaders.add(HttpHeader.ACCEPT_ENCODING, "gzip");
        content.addFilePart(HTTP_MULTIPART_PART1_DISPOSITION_ENTITY_VALUE, "blob", (ContentProvider)byteArrayContent, httpHeaders);
        try {
            byteArrayContent = new ByteBufferContentProvider(contentType, new ByteBuffer[]{ByteBuffer.wrap(IOUtils.toByteArray((InputStream)((InputStream)binaryContent.getMiddle())))});
            HttpFields httpHeaders1 = new HttpFields();
            httpHeaders1.add(HttpHeader.ACCEPT_ENCODING, "gzip");
            content.addFilePart("content", (String)binaryContent.getRight(), (ContentProvider)byteArrayContent, null);
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean updateLWSSOCookieValue(Response response) {
        HttpFields headers = response.getHeaders();
        boolean renewed = false;
        List cookieHeaderValue = headers.getValuesList(SET_COOKIE);
        if (cookieHeaderValue.isEmpty()) {
            return false;
        }
        String url = response.getRequest().getURI().getRawPath();
        if (!url.contains("/authentication/sign_in")) {
            this.areNewCookiesReceived = true;
        }
        for (String strCookie : cookieHeaderValue) {
            List<HttpCookie> cookies;
            try {
                cookies = HttpCookie.parse(strCookie);
            }
            catch (Exception ex) {
                logger.error("Failed to parse SET_COOKIE header, issue with cookie: \"{}\", {}", (Object)strCookie, (Object)ex);
                continue;
            }
            Optional<HttpCookie> lwssoCookie = cookies.stream().filter(a -> a.getName().equals("LWSSO_COOKIE_KEY")).findFirst();
            if (lwssoCookie.isPresent()) {
                this.lwssoValue = lwssoCookie.get().getValue();
                renewed = true;
                continue;
            }
            cookies.stream().filter(cookie -> cookie.getName().equals("OCTANE_USER")).findAny().ifPresent(cookie -> {
                this.octaneUserValue = cookie.getValue();
            });
        }
        return renewed;
    }

    public static int getHttpRequestRetryCount() {
        return 1;
    }

    private static RuntimeException wrapException(Exception exception, Request httpRequest) {
        if (exception.getCause() instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception.getCause();
            logger.debug(LOGGER_RESPONSE_FORMAT, new Object[]{httpResponseException.getResponse().getStatus(), httpResponseException.getResponse().getReason(), httpResponseException.getResponse().getHeaders().stream().collect(Collectors.toList())});
            if (httpResponseException.getResponse().getStatus() == 401) {
                try {
                    String cookie = httpRequest.getCookies().stream().map(HttpCookie::toString).collect(Collectors.joining(";"));
                    if (cookie != null) {
                        for (String splitCookie : cookie.split(";")) {
                            if (!splitCookie.startsWith("LWSSO_COOKIE_KEY")) continue;
                            LongFieldModel statusFieldModel = new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getResponse().getStatus()));
                            ErrorModel errorModel = new ErrorModel(Collections.singleton(statusFieldModel));
                            errorModel.setValue(new StringFieldModel("errorCode", ERROR_CODE_TOKEN_EXPIRED));
                            return new OctaneException(errorModel);
                        }
                    }
                }
                catch (NullPointerException cookie) {
                    // empty catch block
                }
            }
            ArrayList<String> exceptionContentList = new ArrayList<String>();
            HttpContentResponse response = (HttpContentResponse)httpResponseException.getResponse();
            exceptionContentList.add(response.getReason());
            exceptionContentList.add(response.getContentAsString());
            for (String exceptionContent : exceptionContentList) {
                try {
                    ErrorModel errorModel;
                    if (ModelParser.getInstance().hasErrorModels(exceptionContent)) {
                        Collection<ErrorModel> errorModels = ModelParser.getInstance().getErrorModels(exceptionContent);
                        OctaneCollection<EntityModel> entities = ModelParser.getInstance().getEntities(exceptionContent);
                        return new OctanePartialException(errorModels, entities);
                    }
                    if (ModelParser.getInstance().hasErrorModel(exceptionContent)) {
                        errorModel = ModelParser.getInstance().getErrorModelFromjson(exceptionContent);
                        errorModel.setValue(new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getResponse().getStatus())));
                        return new OctaneException(errorModel);
                    }
                    if (!ModelParser.getInstance().hasServletError(exceptionContent)) continue;
                    errorModel = ModelParser.getInstance().getErrorModelFromServletJson(exceptionContent);
                    errorModel.setValue(new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getResponse().getStatus())));
                    return new OctaneException(errorModel);
                }
                catch (Exception exception2) {
                }
            }
        }
        return new RuntimeException(exception);
    }

    private static void logHttpContent(HttpContent content) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            content.advance();
            byteArrayOutputStream.write(content.getContent().array());
        }
        catch (IOException ex) {
            logger.error("Failed to log content of {} {}", (Object)content, (Object)ex);
        }
    }

    private void logSystemProperties() {
        JettyHttpClient.logProxySystemProperties();
        JettyHttpClient.logSystemProxyForUrlDomain(this.urlDomain);
    }

    private static void logProxySystemProperties() {
        if (logger.isDebugEnabled()) {
            String[] proxySysProperties = new String[]{"java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort"};
            Arrays.stream(proxySysProperties).forEach(sysProp -> logger.debug("{}: {}", sysProp, (Object)System.getProperty(sysProp)));
        }
    }

    private static void logSystemProxyForUrlDomain(String urlDomain) {
        if (logger.isDebugEnabled()) {
            try {
                List<Proxy> proxies = ProxySelector.getDefault().select(URI.create(urlDomain));
                logger.debug("System proxies for {}: {}", (Object)urlDomain, (Object)proxies.toString());
            }
            catch (SecurityException ex) {
                logger.debug("SecurityException when trying to access system wide proxy selector: ", (Throwable)ex);
            }
        }
    }

    private class RequestFactory {
        private boolean hasCustom = false;
        private HttpClient client;
        private JettyHttpClient jetty;

        public RequestFactory(JettyHttpClient jetty, HttpClient client) {
            this.client = client;
            this.jetty = jetty;
        }

        public Request buildRequest(Request request, ContentProvider contentProvider) {
            request.onResponseSuccess(response -> this.jetty.updateLWSSOCookieValue(response));
            if (this.jetty.lwssoValue != null && !this.jetty.lwssoValue.isEmpty()) {
                request.cookie(new HttpCookie("LWSSO_COOKIE_KEY", this.jetty.lwssoValue));
            }
            if (this.jetty.octaneUserValue != null && !this.jetty.octaneUserValue.isEmpty()) {
                request.cookie(new HttpCookie("OCTANE_USER", this.jetty.octaneUserValue));
            }
            if (this.jetty.lastUsedAuthentication != null) {
                JettyHttpClient.this.lastUsedAuthentication.getAPIMode().ifPresent(apiMode -> request.getHeaders().add(apiMode.getHeaderKey(), apiMode.getHeaderValue()));
            }
            request.content(contentProvider);
            return request;
        }

        public Request buildPostRequest(URI uri, ContentProvider contentProvider) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.POST), contentProvider);
        }

        public Request buildPutRequest(URI uri, ContentProvider contentProvider) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.PUT), contentProvider);
        }

        public Request buildGetRequest(URI uri) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.GET), null);
        }

        public Request buildDeleteRequest(URI uri) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.DELETE), null);
        }

        public Request buildPatchRequest(URI uri, ContentProvider contentProvider) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.PATCH), contentProvider);
        }

        public Request buildHeadRequest(URI uri) {
            return this.buildRequest(this.client.newRequest(uri).method(HttpMethod.HEAD), null);
        }
    }
}

