/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.query;

import com.hpe.adm.nga.sdk.query.NullField;
import com.hpe.adm.nga.sdk.query.NullReferenceField;
import com.hpe.adm.nga.sdk.query.QueryMethod;

public class Query {
    public static NullField NULL = new NullField();
    public static NullReferenceField NULL_REFERENCE = new NullReferenceField();
    protected String queryString = "";

    protected Query() {
    }

    private static String negate(String queryString) {
        return "!" + queryString;
    }

    public static QueryBuilder statement(String fieldName, QueryMethod method, Object fieldValue) {
        return new QueryBuilder(method.getAction().apply(fieldName, (String)fieldValue));
    }

    public static QueryBuilder not(String fieldName, QueryMethod method, Object fieldValue) {
        return new QueryBuilder(Query.negate(method.getAction().apply(fieldName, (String)fieldValue)));
    }

    private Query(QueryBuilder builder) {
        this.queryString = builder.queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        return this.queryString;
    }

    public static class QueryBuilder {
        private String queryString;

        private QueryBuilder(String queryString) {
            this.queryString = queryString;
        }

        private String getQueryString() {
            return this.queryString;
        }

        public Query build() {
            return new Query(this);
        }

        public QueryBuilder and(String fieldName, QueryMethod method, Object fieldValue) {
            String rightQueryString = method.getAction().apply(fieldName, (String)fieldValue);
            this.queryString = this.queryString + ";" + rightQueryString;
            return this;
        }

        public QueryBuilder andNot(String fieldName, QueryMethod method, Object fieldValue) {
            this.queryString = this.queryString + ";" + Query.negate(method.getAction().apply(fieldName, (String)fieldValue));
            return this;
        }

        public QueryBuilder and(QueryBuilder qb) {
            this.queryString = this.queryString + ";" + qb.getQueryString();
            return this;
        }

        public QueryBuilder andNot(QueryBuilder qb) {
            this.queryString = this.queryString + ";" + Query.negate(qb.getQueryString());
            return this;
        }

        public QueryBuilder or(String fieldName, QueryMethod method, Object fieldValue) {
            String rightQueryString = method.getAction().apply(fieldName, (String)fieldValue);
            this.queryString = this.queryString + "||" + rightQueryString;
            return this;
        }

        public QueryBuilder orNot(String fieldName, QueryMethod method, Object fieldValue) {
            this.queryString = this.queryString + "||" + Query.negate(method.getAction().apply(fieldName, (String)fieldValue));
            return this;
        }

        public QueryBuilder or(QueryBuilder qb) {
            this.queryString = this.queryString + "||" + qb.getQueryString();
            return this;
        }

        public QueryBuilder orNot(QueryBuilder qb) {
            this.queryString = this.queryString + "||" + Query.negate(qb.getQueryString());
            return this;
        }

        private QueryBuilder parenthesis() {
            this.queryString = "(" + this.queryString + ")";
            return this;
        }

        public static QueryBuilder parenthesis(QueryBuilder queryBuilder) {
            return queryBuilder.parenthesis();
        }
    }
}

