/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.query;

import com.hpe.adm.nga.sdk.query.NullField;
import com.hpe.adm.nga.sdk.query.Query;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public enum QueryMethod {
    EqualTo(QueryMethod::equalTo),
    LessThan(QueryMethod::lessThan),
    GreaterThan(QueryMethod::greaterThan),
    GreaterThanOrEqualTo(QueryMethod::greaterThanOrEqualTo),
    LessThanOrEqualTo(QueryMethod::lessThanOrEqualTo),
    In(QueryMethod::in),
    Between(QueryMethod::between);

    private static final String DATE_TIME_ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_TIME_UTC_ZONE_NAME = "UTC";
    private static final String COMPARISON_OPERATOR_EQUALS = "EQ";
    private static final String COMPARISON_OPERATOR_LESS = "LT";
    private static final String COMPARISON_OPERATOR_GREATER = "GT";
    private static final String COMPARISON_OPERATOR_LESS_EQUALS = "LE";
    private static final String COMPARISON_OPERATOR_GREATER_EQUALS = "GE";
    static final String COMPARISON_OPERATOR_IN = "IN";
    static final String COMPARISON_OPERATOR_BETWEEN = "BTW";
    private final BiFunction<String, ?, String> function;

    private <T> QueryMethod(BiFunction<String, T, String> f) {
        this.function = f;
    }

    public <T> BiFunction<String, T, String> getAction() {
        return this.function;
    }

    private static String equalTo(String field, Object value) {
        return "(" + field + " " + COMPARISON_OPERATOR_EQUALS + " " + QueryMethod.toString(value) + ")";
    }

    private static String lessThan(String field, Object value) {
        return "(" + field + " " + COMPARISON_OPERATOR_LESS + " " + QueryMethod.toString(value) + ")";
    }

    private static String greaterThan(String field, Object value) {
        return "(" + field + " " + COMPARISON_OPERATOR_GREATER + " " + QueryMethod.toString(value) + ")";
    }

    private static String lessThanOrEqualTo(String field, Object value) {
        return "(" + field + " " + COMPARISON_OPERATOR_LESS_EQUALS + " " + QueryMethod.toString(value) + ")";
    }

    private static String greaterThanOrEqualTo(String field, Object value) {
        return "(" + field + " " + COMPARISON_OPERATOR_GREATER_EQUALS + " " + QueryMethod.toString(value) + ")";
    }

    private static String in(String field, Object[] value) {
        if (value == null) {
            return "";
        }
        return "(" + field + " " + COMPARISON_OPERATOR_IN + " " + Arrays.stream(value).map(QueryMethod::toString).collect(Collectors.joining(",")) + ")";
    }

    private static String between(String field, Between lowerAndUpper) {
        if (lowerAndUpper == null) {
            return "";
        }
        return "(" + field + " " + COMPARISON_OPERATOR_BETWEEN + " " + QueryMethod.toString(lowerAndUpper.lower) + " ..." + QueryMethod.toString(lowerAndUpper.upper) + ")";
    }

    private static String toString(Object value) {
        if (value == null || value == Query.NULL_REFERENCE) {
            return Query.NULL_REFERENCE.toString();
        }
        if (value.getClass() == NullField.class) {
            return Query.NULL.toString();
        }
        if (value.getClass() == ZonedDateTime.class) {
            ZonedDateTime zonedDateTime = ((ZonedDateTime)value).withZoneSameInstant(ZoneId.of("Z"));
            return "'" + zonedDateTime + "'";
        }
        if (value.getClass() == Date.class) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_ISO_FORMAT);
            TimeZone utc = TimeZone.getTimeZone(DATE_TIME_UTC_ZONE_NAME);
            sdf.setTimeZone(utc);
            return "'" + sdf.format(value) + "'";
        }
        if (value.getClass() == String.class) {
            return "'" + value.toString() + "'";
        }
        if (value.getClass() == Query.QueryBuilder.class) {
            return "{" + ((Query.QueryBuilder)value).build().getQueryString() + "}";
        }
        return value.toString();
    }

    public static class Between {
        private final Object lower;
        private final Object upper;

        public Between(Object lower, Object upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

