/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.siteadmin.version;

import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneHttpRequest;
import com.hpe.adm.nga.sdk.network.OctaneHttpResponse;
import com.hpe.adm.nga.sdk.network.OctaneRequest;
import com.hpe.adm.nga.sdk.siteadmin.version.Version;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetServerVersion {
    private final Logger logger = LoggerFactory.getLogger((String)GetServerVersion.class.getName());
    private final OctaneRequest octaneRequest;
    private final OctaneHttpClient octaneHttpClient;

    public GetServerVersion(OctaneHttpClient octaneHttpClient, String urlDomain) {
        this.octaneHttpClient = octaneHttpClient;
        this.octaneRequest = new OctaneRequest(octaneHttpClient, urlDomain + "version");
    }

    public Version execute() {
        OctaneHttpRequest.GetOctaneHttpRequest octaneHttpRequest = new OctaneHttpRequest.GetOctaneHttpRequest(this.octaneRequest.getFinalRequestUrl());
        OctaneHttpResponse response = this.octaneHttpClient.execute(octaneHttpRequest);
        if (response.isSuccessStatusCode()) {
            String json = response.getContent();
            this.logger.debug("Response_Json: {}", (Object)json);
            JSONTokener tokener = new JSONTokener(json);
            JSONObject jsonObj = new JSONObject(tokener);
            return new Version(jsonObj.getString("version"), jsonObj.getString("build_date"), jsonObj.getString("build_revision"), jsonObj.getString("build_number"), jsonObj.getString("display_version"));
        }
        throw new RuntimeException("Unexpected Version reponse!");
    }
}

