/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import com.google.gson.Gson;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.R;
import com.microsoft.aad.adal.StorageHelper;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class AuthenticationActivity
extends Activity {
    private final String TAG = "AuthenticationActivity";
    private Button btnCancel;
    private boolean mRestartWebview = false;
    private WebView mWebView;
    private String mStartUrl;
    private ProgressDialog spinner;
    private String mRedirectUrl;
    private AuthenticationRequest mAuthRequest;
    private ActivityBroadcastReceiver mReceiver = null;
    private String mCallingPackage;
    private int mWaitingRequestId;
    private int mCallingUID;
    private AccountAuthenticatorResponse mAccountAuthenticatorResponse = null;
    private Bundle mAuthenticatorResultBundle = null;
    private AccountManager mAcctManager = null;
    private IWebRequestHandler mWebRequestHandler = new WebRequestHandler();

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_authentication);
        this.mAcctManager = AccountManager.get((Context)this.getApplicationContext());
        this.mAuthRequest = this.getAuthenticationRequestFromIntent(this.getIntent());
        if (this.mAuthRequest == null) {
            Log.d((String)"AuthenticationActivity", (String)"Request item is null, so it returns to caller");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "Intent does not have request details");
            this.ReturnToCaller(2002, resultIntent);
            return;
        }
        if (this.mAuthRequest.getAuthority() == null || this.mAuthRequest.getAuthority().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.authority");
            return;
        }
        if (this.mAuthRequest.getResource() == null || this.mAuthRequest.getResource().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.resource");
            return;
        }
        if (this.mAuthRequest.getClientId() == null || this.mAuthRequest.getClientId().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.clientid.key");
            return;
        }
        if (this.mAuthRequest.getRedirectUri() == null || this.mAuthRequest.getRedirectUri().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.redirect");
            return;
        }
        this.mRedirectUrl = this.mAuthRequest.getRedirectUri();
        Log.d((String)"AuthenticationActivity", (String)("OnCreate redirect" + this.mRedirectUrl));
        this.setupWebView();
        Logger.v("AuthenticationActivity", "User agent:" + this.mWebView.getSettings().getUserAgentString());
        this.mStartUrl = "about:blank";
        this.updateRequestForAccounts();
        try {
            this.mStartUrl = new Oauth2(this.mAuthRequest, null).getCodeRequestUrl();
        }
        catch (UnsupportedEncodingException e) {
            Log.d((String)"AuthenticationActivity", (String)e.getMessage());
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
            this.ReturnToCaller(2002, resultIntent);
        }
        Logger.v("AuthenticationActivity", "Init broadcastReceiver with requestId:" + this.mAuthRequest.getRequestId() + " " + this.mAuthRequest.getLogInfo());
        this.mReceiver = new ActivityBroadcastReceiver();
        this.mReceiver.mWaitingRequestId = this.mAuthRequest.getRequestId();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
        if (this.insideBroker()) {
            this.mCallingPackage = this.getCallingPackage();
            if (this.mCallingPackage == null) {
                Log.d((String)"AuthenticationActivity", (String)"startActivityForResult is not used to call this activity");
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "startActivityForResult is not used to call this activity");
                this.ReturnToCaller(2002, resultIntent);
                return;
            }
            this.mAccountAuthenticatorResponse = (AccountAuthenticatorResponse)this.getIntent().getParcelableExtra("accountAuthenticatorResponse");
            if (this.mAccountAuthenticatorResponse != null) {
                this.mAccountAuthenticatorResponse.onRequestContinued();
            }
            PackageHelper info = new PackageHelper((Context)this);
            this.mCallingPackage = this.getCallingPackage();
            this.mCallingUID = info.getUIDForPackage(this.mCallingPackage);
            String signatureDigest = info.getCurrentSignatureForPackage(this.mCallingPackage);
            this.mStartUrl = this.getBrokerUrl(this.mStartUrl, this.mCallingPackage, signatureDigest);
            Logger.v("AuthenticationActivity", "OnCreate redirectUrl:" + this.mRedirectUrl + " startUrl:" + this.mStartUrl + " calling package:" + this.mCallingPackage + " signatureDigest:" + signatureDigest + " current Context Package: " + this.getPackageName() + " accountName:" + this.mAuthRequest.getBrokerAccountName() + " loginHint:" + this.mAuthRequest.getLoginHint());
        }
        this.mRestartWebview = false;
        final String postUrl = this.mStartUrl;
        this.mWebView.post(new Runnable(){

            @Override
            public void run() {
                AuthenticationActivity.this.mWebView.loadUrl("about:blank");
                AuthenticationActivity.this.mWebView.loadUrl(postUrl);
            }
        });
    }

    private void updateRequestForAccounts() {
        Account[] accountList;
        if (this.insideBroker() && (accountList = this.mAcctManager.getAccountsByType("com.microsoft.aadbroker.adal")) != null && accountList.length == 0) {
            Logger.v("AuthenticationActivity", "Activity may have cookies from previous accounts");
            this.mAuthRequest.setPrompt(PromptBehavior.Always);
        }
    }

    private void setupWebView() {
        this.btnCancel = (Button)this.findViewById(R.id.btnCancel);
        this.btnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AuthenticationActivity.this.confirmCancelRequest();
            }
        });
        this.spinner = new ProgressDialog((Context)this);
        this.spinner.requestWindowFeature(1);
        this.spinner.setMessage(this.getText(R.string.app_loading));
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                AuthenticationActivity.this.confirmCancelRequest();
            }
        });
        this.mWebView = (WebView)this.findViewById(R.id.webView1);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setWebViewClient((WebViewClient)new CustomWebViewClient());
        this.mWebView.setVisibility(4);
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        if (this.insideBroker()) {
            String authority = callingIntent.getStringExtra("account.authority");
            String resource = callingIntent.getStringExtra("account.resource");
            String redirect = callingIntent.getStringExtra("account.redirect");
            String loginhint = callingIntent.getStringExtra("account.login.hint");
            String accountName = callingIntent.getStringExtra("account.name");
            String clientidKey = callingIntent.getStringExtra("account.clientid.key");
            String correlationId = callingIntent.getStringExtra("account.correlationid");
            String prompt = callingIntent.getStringExtra("account.prompt");
            PromptBehavior promptBehavior = PromptBehavior.Always;
            if (!StringExtensions.IsNullOrBlank(prompt)) {
                promptBehavior = PromptBehavior.valueOf(prompt);
            }
            this.mWaitingRequestId = callingIntent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            UUID correlationIdParsed = null;
            if (!StringExtensions.IsNullOrBlank(correlationId)) {
                try {
                    correlationIdParsed = UUID.fromString(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    correlationIdParsed = null;
                    Logger.e("AuthenticationActivity", "CorrelationId is malformed: " + correlationId, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            authRequest = new AuthenticationRequest(authority, resource, clientidKey, redirect, loginhint, correlationIdParsed);
            authRequest.setBrokerAccountName(accountName);
            authRequest.setPrompt(promptBehavior);
        } else {
            Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
            if (request instanceof AuthenticationRequest) {
                authRequest = (AuthenticationRequest)request;
            }
        }
        return authRequest;
    }

    private void returnError(ADALError errorCode, String argument) {
        Log.w((String)"AuthenticationActivity", (String)("Argument error:" + argument));
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode.name());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", argument);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2002, resultIntent);
        this.finish();
    }

    private String getBrokerUrl(String loadUrl, String packageName, String signatureDigest) {
        if (!StringExtensions.IsNullOrBlank(packageName) && !StringExtensions.IsNullOrBlank(signatureDigest)) {
            try {
                return loadUrl + "&package_name=" + URLEncoder.encode(packageName, "UTF_8") + "&signature=" + URLEncoder.encode(signatureDigest, "UTF_8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)"AuthenticationActivity", (String)"Encoding", (Throwable)e);
            }
        }
        return loadUrl;
    }

    private boolean insideBroker() {
        return this.getPackageName().equals(AuthenticationSettings.INSTANCE.getBrokerPackageName());
    }

    private void ReturnToCaller(int resultCode, Intent data) {
        Logger.d("AuthenticationActivity", "Return To Caller:" + resultCode);
        this.displaySpinner(false);
        if (data == null) {
            data = new Intent();
        }
        if (this.mAuthRequest != null) {
            Logger.d("AuthenticationActivity", "Return To Caller REQUEST_ID:" + this.mAuthRequest.getRequestId());
            data.putExtra("com.microsoft.aad.adal:RequestId", this.mAuthRequest.getRequestId());
        } else {
            Logger.w("AuthenticationActivity", "Request object is null", "", ADALError.ACTIVITY_REQUEST_INTENT_DATA_IS_NULL);
        }
        this.setResult(resultCode, data);
        this.finish();
    }

    protected void onPause() {
        Logger.d("AuthenticationActivity", "AuthenticationActivity onPause unregister receiver");
        super.onPause();
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
        this.mRestartWebview = true;
    }

    protected void onResume() {
        super.onResume();
        if (this.mRestartWebview) {
            Logger.v("AuthenticationActivity", "Webview onResume will post start url again:" + this.mStartUrl);
            final String postUrl = this.mStartUrl;
            if (this.mReceiver != null) {
                Logger.v("AuthenticationActivity", "Webview onResume register broadcast receiver for requestId" + this.mReceiver.mWaitingRequestId);
                LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
            }
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    AuthenticationActivity.this.mWebView.loadUrl("about:blank");
                    AuthenticationActivity.this.mWebView.loadUrl(postUrl);
                }
            });
        }
        this.mRestartWebview = false;
    }

    protected void onRestart() {
        Logger.d("AuthenticationActivity", "AuthenticationActivity onRestart");
        super.onRestart();
        this.mRestartWebview = true;
    }

    public void onBackPressed() {
        Logger.d("AuthenticationActivity", "Back button is pressed");
        if (!this.mWebView.canGoBack()) {
            this.confirmCancelRequest();
        } else {
            this.mWebView.goBack();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.login, menu2);
        return true;
    }

    private void confirmCancelRequest() {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.title_confirmation_activity_authentication)).setMessage((CharSequence)this.getString(R.string.confirmation_activity_authentication)).setNegativeButton(17039369, null).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                Intent resultIntent = new Intent();
                AuthenticationActivity.this.ReturnToCaller(2001, resultIntent);
            }
        }).create().show();
    }

    private void displaySpinner(boolean show) {
        if (!this.isFinishing() && this.spinner != null) {
            if (show && !this.spinner.isShowing()) {
                this.spinner.show();
            }
            if (!show && this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
        }
    }

    private void displaySpinnerWithMessage(String msg) {
        if (!this.isFinishing() && this.spinner != null) {
            this.spinner.show();
            this.spinner.setTitle((CharSequence)"Processing ");
            this.spinner.setMessage((CharSequence)msg);
        }
    }

    private void returnResult(int resultcode, Intent intent) {
        this.setAccountAuthenticatorResult(intent.getExtras());
        this.setResult(resultcode, intent);
        this.finish();
    }

    public void finish() {
        if (this.insideBroker() && this.mAccountAuthenticatorResponse != null) {
            if (this.mAuthenticatorResultBundle != null) {
                this.mAccountAuthenticatorResponse.onResult(this.mAuthenticatorResultBundle);
            } else {
                this.mAccountAuthenticatorResponse.onError(4, "canceled");
            }
            this.mAccountAuthenticatorResponse = null;
        }
        super.finish();
    }

    private final void setAccountAuthenticatorResult(Bundle result) {
        this.mAuthenticatorResultBundle = result;
    }

    class TokenTaskResult {
        AuthenticationResult taskResult;
        Exception taskException;
        String accountName;

        TokenTaskResult() {
        }
    }

    class TokenTask
    extends AsyncTask<String, String, TokenTaskResult> {
        String mPackageName;
        int mAppCallingUID;
        AuthenticationRequest mRequest;
        AccountManager mAccountManager;
        IWebRequestHandler mRequestHandler;

        public TokenTask() {
        }

        public TokenTask(IWebRequestHandler webHandler, AuthenticationRequest request, String packagename, int callingUID) {
            this.mRequestHandler = webHandler;
            this.mRequest = request;
            this.mPackageName = packagename;
            this.mAppCallingUID = callingUID;
            this.mAccountManager = AccountManager.get((Context)AuthenticationActivity.this);
        }

        protected TokenTaskResult doInBackground(String ... urlItems) {
            Oauth2 oauthRequest = new Oauth2(this.mRequest, this.mRequestHandler);
            TokenTaskResult result = new TokenTaskResult();
            try {
                result.taskResult = oauthRequest.getToken(urlItems[0]);
                Logger.v("AuthenticationActivity", "TokenTask processed the result. " + this.mRequest.getLogInfo());
            }
            catch (Exception exc) {
                Logger.e("AuthenticationActivity", "Error in processing code to get a token. " + this.mRequest.getLogInfo(), "Request url:" + urlItems[0], ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                result.taskException = exc;
            }
            if (result != null && result.taskResult != null && result.taskResult.getAccessToken() != null) {
                Logger.v("AuthenticationActivity", "Setting account:" + this.mRequest.getLogInfo());
                try {
                    this.setAccount(result);
                }
                catch (Exception exc) {
                    Logger.e("AuthenticationActivity", "Error in setting the account" + this.mRequest.getLogInfo(), "", ADALError.BROKER_ACCOUNT_SAVE_FAILED, exc);
                    result.taskException = exc;
                }
            }
            return result;
        }

        private String getBrokerAppCacheKey(StorageHelper cryptoHelper, String cacheKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, IOException {
            String digestKey = StringExtensions.createHash("calling.uid.key" + this.mAppCallingUID + cacheKey);
            Logger.d("AuthenticationActivity", "Cache key original:" + cacheKey + " digestKey:" + digestKey + " calling app UID:" + this.mAppCallingUID);
            return digestKey;
        }

        private void appendAppUIDToAccount(StorageHelper cryptoHelper, Account account) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, IOException, KeyStoreException, CertificateException, NoSuchProviderException, UnrecoverableEntryException, DigestException {
            String appIdList = this.mAccountManager.getUserData(account, "account.uid.caches");
            appIdList = appIdList == null ? "" : cryptoHelper.decrypt(appIdList);
            Logger.v("AuthenticationActivity", "Add calling UID:" + this.mAppCallingUID);
            if (!appIdList.contains("calling.uid.key" + this.mAppCallingUID)) {
                Logger.v("AuthenticationActivity", "Account has new calling UID:" + this.mAppCallingUID);
                this.mAccountManager.setUserData(account, "account.uid.caches", cryptoHelper.encrypt(appIdList + "calling.uid.key" + this.mAppCallingUID));
            }
        }

        private void setAccount(TokenTaskResult result) throws InvalidKeyException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
            try {
                String name = this.mRequest.getBrokerAccountName();
                if (result.taskResult.getUserInfo() != null && !StringExtensions.IsNullOrBlank(result.taskResult.getUserInfo().getUserId())) {
                    name = result.taskResult.getUserInfo().getUserId();
                    if (this.mRequest.getLoginHint() == null || this.mRequest.getLoginHint().isEmpty()) {
                        this.mRequest.setLoginHint(name);
                    } else if (!this.mRequest.getLoginHint().equalsIgnoreCase(name)) {
                        Logger.e("AuthenticationActivity", "Userid does not match from idtoken", "", ADALError.AUTH_FAILED_USER_MISMATCH);
                        result.taskResult = null;
                        result.taskException = new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
                        return;
                    }
                }
                result.accountName = name;
                Logger.v("AuthenticationActivity", "Setting account. Account name: " + name + " package:" + AuthenticationActivity.this.mCallingPackage + " calling app UID:" + this.mAppCallingUID);
                Account newaccount = new Account(name, "com.microsoft.aadbroker.adal");
                Bundle userdata = new Bundle();
                this.mAccountManager.addAccountExplicitly(newaccount, "nopass", userdata);
                Gson gson = new Gson();
                Logger.v("AuthenticationActivity", "app context:" + AuthenticationActivity.this.getApplicationContext().getPackageName() + " context:" + AuthenticationActivity.this.getPackageName() + " calling packagename:" + AuthenticationActivity.this.getCallingPackage());
                StorageHelper cryptoHelper = new StorageHelper(AuthenticationActivity.this.getApplicationContext());
                TokenCacheItem item = new TokenCacheItem(this.mRequest, result.taskResult, false);
                String json = gson.toJson((Object)item);
                String encrypted = cryptoHelper.encrypt(json);
                String key = CacheKey.createCacheKey(this.mRequest);
                this.saveCacheKey(key, newaccount, this.mAppCallingUID);
                this.mAccountManager.setUserData(newaccount, this.getBrokerAppCacheKey(cryptoHelper, key), encrypted);
                if (result.taskResult.getIsMultiResourceRefreshToken()) {
                    TokenCacheItem itemMRRT = new TokenCacheItem(this.mRequest, result.taskResult, true);
                    json = gson.toJson((Object)itemMRRT);
                    encrypted = cryptoHelper.encrypt(json);
                    key = CacheKey.createMultiResourceRefreshTokenKey(this.mRequest);
                    this.saveCacheKey(key, newaccount, this.mAppCallingUID);
                    this.mAccountManager.setUserData(newaccount, this.getBrokerAppCacheKey(cryptoHelper, key), encrypted);
                }
                Logger.v("AuthenticationActivity", "Set calling uid:" + this.mAppCallingUID);
                this.appendAppUIDToAccount(cryptoHelper, newaccount);
            }
            catch (NoSuchAlgorithmException e) {
                Logger.e("AuthenticationActivity", "Algorithm does not exist in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (NoSuchPaddingException e) {
                Logger.e("AuthenticationActivity", "Padding type does not exist in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (KeyStoreException e) {
                Logger.e("AuthenticationActivity", "Key store type is not supported", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (CertificateException e) {
                Logger.e("AuthenticationActivity", "Certificate exception", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (NoSuchProviderException e) {
                Logger.e("AuthenticationActivity", "Requested security provider does not exists in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (UnrecoverableEntryException e) {
                Logger.e("AuthenticationActivity", "Key entry is not recoverable", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (DigestException e) {
                Logger.e("AuthenticationActivity", "Digest is not valid", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
        }

        private void saveCacheKey(String key, Account cacheAccount, int callingUID) {
            Logger.d("AuthenticationActivity", "Get CacheKeys for account");
            String keylist = this.mAccountManager.getUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID);
            if (keylist == null) {
                keylist = "";
            }
            if (!keylist.contains("|" + key)) {
                Logger.v("AuthenticationActivity", "Account does not have this cache key:" + key + " It will save it to accoun for the callerUID:" + callingUID);
                keylist = keylist + "|" + key;
                this.mAccountManager.setUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID, keylist);
                Logger.v("AuthenticationActivity", "keylist:" + keylist);
            }
        }

        protected void onPostExecute(TokenTaskResult result) {
            Logger.v("AuthenticationActivity", "Token task returns the result");
            AuthenticationActivity.this.displaySpinner(false);
            Intent intent = new Intent();
            if (result.taskResult != null) {
                intent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationActivity.this.mWaitingRequestId);
                intent.putExtra("account.access.token", result.taskResult.getAccessToken());
                intent.putExtra("account.name", result.accountName);
                intent.putExtra("account.expiredate", result.taskResult.getExpiresOn().getTime());
                if (result.taskResult.getUserInfo() != null) {
                    intent.putExtra("account.userinfo.userid", result.taskResult.getUserInfo().getUserId());
                    intent.putExtra("account.userinfo.given.name", result.taskResult.getUserInfo().getGivenName());
                    intent.putExtra("account.userinfo.family.name", result.taskResult.getUserInfo().getFamilyName());
                    intent.putExtra("account.userinfo.identity.provider", result.taskResult.getUserInfo().getIdentityProvider());
                    intent.putExtra("account.userinfo.userid.displayable", result.taskResult.getUserInfo().getIsUserIdDisplayable());
                }
                AuthenticationActivity.this.returnResult(2004, intent);
            } else {
                AuthenticationActivity.this.returnError(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, result.taskException.getMessage());
            }
        }
    }

    private class CustomWebViewClient
    extends WebViewClient {
        private CustomWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Logger.d("AuthenticationActivity", "shouldOverrideUrlLoading:url=" + url);
            AuthenticationActivity.this.displaySpinner(true);
            if (url.startsWith(AuthenticationActivity.this.mRedirectUrl)) {
                Logger.v("AuthenticationActivity", "Webview reached redirecturl");
                if (!AuthenticationActivity.this.insideBroker()) {
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
                    resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
                    AuthenticationActivity.this.ReturnToCaller(2003, resultIntent);
                    view.stopLoading();
                    return true;
                }
                AuthenticationActivity.this.displaySpinnerWithMessage(AuthenticationActivity.this.getResources().getString(R.string.broker_processing));
                view.stopLoading();
                new TokenTask(AuthenticationActivity.this.mWebRequestHandler, AuthenticationActivity.this.mAuthRequest, AuthenticationActivity.this.mCallingPackage, AuthenticationActivity.this.mCallingUID).execute(new String[]{url});
                return true;
            }
            return false;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            AuthenticationActivity.this.displaySpinner(false);
            Logger.e("AuthenticationActivity", "Webview received an error. Errorcode:" + errorCode + " " + description, "", ADALError.ERROR_WEBVIEW);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
            AuthenticationActivity.this.ReturnToCaller(2002, resultIntent);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            AuthenticationActivity.this.displaySpinner(false);
            handler.cancel();
            Logger.e("AuthenticationActivity", "Received ssl error", "", ADALError.ERROR_FAILED_SSL_HANDSHAKE);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
            AuthenticationActivity.this.ReturnToCaller(2002, resultIntent);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            Logger.v("AuthenticationActivity", "Page finished:" + url);
            AuthenticationActivity.this.displaySpinner(false);
            AuthenticationActivity.this.mWebView.setVisibility(0);
        }
    }

    private class ActivityBroadcastReceiver
    extends BroadcastReceiver {
        private int mWaitingRequestId = -1;

        private ActivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Logger.v("AuthenticationActivity", "ActivityBroadcastReceiver onReceive");
            if (intent.getAction().equalsIgnoreCase("com.microsoft.aad.adal:BrowserCancel")) {
                try {
                    Logger.v("AuthenticationActivity", "ActivityBroadcastReceiver onReceive action is for cancelling Authentication Activity");
                    int cancelRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
                    if (cancelRequestId == this.mWaitingRequestId) {
                        Logger.v("AuthenticationActivity", "Waiting requestId is same and cancelling this activity");
                        AuthenticationActivity.this.finish();
                    }
                }
                catch (Exception ex) {
                    Logger.e("AuthenticationActivity", "ActivityBroadcastReceiver onReceive exception", ExceptionExtensions.getExceptionMessage(ex), ADALError.BROADCAST_RECEIVER_ERROR);
                }
            }
        }
    }
}

