/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationActivity;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.DefaultTokenCacheStore;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.IConnectionService;
import com.microsoft.aad.adal.IDiscovery;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PRNGFixes;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.NoSuchPaddingException;

public class AuthenticationContext {
    private static final String TAG = "AuthenticationContext";
    private Context mContext;
    private String mAuthority;
    private boolean mValidateAuthority;
    private boolean mAuthorityValidated = false;
    private ITokenCacheStore mTokenCacheStore;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock readLock = rwl.readLock();
    private static final Lock writeLock = rwl.writeLock();
    static SparseArray<AuthenticationRequestState> mDelegateMap = new SparseArray();
    private AuthenticationCallback<AuthenticationResult> mAuthorizationCallback;
    private IDiscovery mDiscovery = new Discovery();
    private IWebRequestHandler mWebRequest = new WebRequestHandler();
    private IConnectionService mConnectionService = null;
    private IBrokerProxy mBrokerProxy = null;
    private UUID mRequestCorrelationId = null;
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();
    private Handler mHandler;

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority) throws NoSuchAlgorithmException, NoSuchPaddingException, SecurityException {
        PRNGFixes.apply();
        this.initialize(appContext, authority, new DefaultTokenCacheStore(appContext), validateAuthority, true);
    }

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, validateAuthority, false);
    }

    public AuthenticationContext(Context appContext, String authority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, true, false);
    }

    private void initialize(Context appContext, String authority, ITokenCacheStore tokenCacheStore, boolean validateAuthority, boolean defaultCache) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
        if (!defaultCache && this.mBrokerProxy.canSwitchToBroker()) {
            throw new UnsupportedOperationException("Local cache is not supported for broker usage");
        }
        this.mContext = appContext;
        this.mConnectionService = new DefaultConnectionService(this.mContext);
        this.checkInternetPermission();
        this.mAuthority = AuthenticationContext.extractAuthority(authority);
        this.mValidateAuthority = validateAuthority;
        this.mTokenCacheStore = tokenCacheStore;
    }

    public ITokenCacheStore getCache() {
        if (this.mBrokerProxy.canSwitchToBroker()) {
            return new ITokenCacheStore(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setItem(String key, TokenCacheItem item) {
                    throw new UnsupportedOperationException("Broker cache does not support direct setItem operation");
                }

                @Override
                public void removeItem(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support direct removeItem operation");
                }

                @Override
                public void removeAll() {
                    AuthenticationContext.this.mBrokerProxy.removeAccounts();
                }

                @Override
                public TokenCacheItem getItem(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support direct getItem operation");
                }

                @Override
                public boolean contains(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support contains operation");
                }
            };
        }
        return this.mTokenCacheStore;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public boolean getValidateAuthority() {
        return this.mValidateAuthority;
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String userId, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(activity, resource, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, userId, PromptBehavior.Auto, null, this.getRequestCorrelationId());
        this.acquireTokenLocal(activity, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String userId, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(activity, resource, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, userId, PromptBehavior.Auto, extraQueryParameters, this.getRequestCorrelationId());
        this.acquireTokenLocal(activity, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(activity, resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, null, this.getRequestCorrelationId());
        this.acquireTokenLocal(activity, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(activity, resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, extraQueryParameters, this.getRequestCorrelationId());
        this.acquireTokenLocal(activity, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String userId, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(activity, resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, userId, prompt, extraQueryParameters, this.getRequestCorrelationId());
        this.acquireTokenLocal(activity, request, callback);
    }

    private String checkInputParameters(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior behavior, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.mContext == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED);
        }
        if (activity == null && behavior != PromptBehavior.Never) {
            throw new IllegalArgumentException("activity");
        }
        if (StringExtensions.IsNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        if (StringExtensions.IsNullOrBlank(redirectUri)) {
            redirectUri = this.getRedirectFromPackage();
        }
        return redirectUri;
    }

    public void acquireTokenByRefreshToken(String refreshToken, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        this.refreshTokenWithoutCache(refreshToken, clientId, null, callback);
    }

    public void acquireTokenByRefreshToken(String refreshToken, String clientId, String resource, AuthenticationCallback<AuthenticationResult> callback) {
        this.refreshTokenWithoutCache(refreshToken, clientId, resource, callback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            if (data == null) {
                Logger.e(TAG, "onActivityResult BROWSER_FLOW data is null." + this.getCorrelationLogInfo(), "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            } else {
                Bundle extras = data.getExtras();
                final int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
                final AuthenticationRequestState waitingRequest = this.getWaitingRequest(requestId);
                if (waitingRequest == null) {
                    Logger.e(TAG, "onActivityResult did not find waiting request for RequestId:" + requestId + this.getCorrelationLogInfo(), "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                    return;
                }
                Logger.v(TAG, "onActivityResult RequestId:" + requestId + this.getCorrelationLogInfo());
                String correlationInfo = this.getCorrelationInfoFromWaitingRequest(waitingRequest);
                if (resultCode == 2004) {
                    String accessToken = data.getStringExtra("account.access.token");
                    String accountName = data.getStringExtra("account.name");
                    this.mBrokerProxy.saveAccount(accountName);
                    long expireTime = data.getLongExtra("account.expiredate", 0L);
                    Date expire = new Date(expireTime);
                    UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(data.getExtras());
                    AuthenticationResult brokerResult = new AuthenticationResult(accessToken, null, expire, false, userinfo);
                    if (brokerResult != null && brokerResult.getAccessToken() != null) {
                        waitingRequest.mDelagete.onSuccess(brokerResult);
                        return;
                    }
                } else if (resultCode == 2001) {
                    Logger.v(TAG, "User cancelled the flow RequestId:" + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError(ADALError.AUTH_FAILED_CANCELLED));
                } else if (resultCode == 2002) {
                    String errCode = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                    String errMessage = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                    Logger.v(TAG, "Error info:" + errCode + " " + errMessage + " for requestId: " + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.SERVER_INVALID_REQUEST, errCode + " " + errMessage));
                } else if (resultCode == 2003) {
                    final AuthenticationRequest authenticationRequest = (AuthenticationRequest)extras.getSerializable("com.microsoft.aad.adal:BrowserRequestInfo");
                    final String endingUrl = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl");
                    if (endingUrl.isEmpty()) {
                        Logger.v(TAG, "Webview did not reach the redirectUrl. " + authenticationRequest.getLogInfo());
                        this.waitingRequestOnError(waitingRequest, requestId, new IllegalArgumentException("Webview did not reach the redirectUrl"));
                    } else {
                        final CallbackHandler callbackHandle = new CallbackHandler(this.mHandler, waitingRequest.mDelagete);
                        sThreadExecutor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Logger.v(AuthenticationContext.TAG, "Processing url for token. " + authenticationRequest.getLogInfo());
                                Oauth2 oauthRequest = new Oauth2(authenticationRequest, AuthenticationContext.this.mWebRequest);
                                AuthenticationResult result = null;
                                try {
                                    result = oauthRequest.getToken(endingUrl);
                                    Logger.v(AuthenticationContext.TAG, "OnActivityResult processed the result. " + authenticationRequest.getLogInfo());
                                    if (AuthenticationContext.isUserMisMatch(authenticationRequest.getLoginHint(), result)) {
                                        throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
                                    }
                                }
                                catch (Exception exc) {
                                    Logger.e(AuthenticationContext.TAG, "Error in processing code to get token. " + authenticationRequest.getLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                                    AuthenticationContext.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, exc);
                                    return;
                                }
                                try {
                                    if (result != null && !StringExtensions.IsNullOrBlank(result.getAccessToken())) {
                                        Logger.v(AuthenticationContext.TAG, "OnActivityResult is setting the token to cache. " + authenticationRequest.getLogInfo());
                                        AuthenticationContext.this.setItemToCache(authenticationRequest, result);
                                        if (waitingRequest != null && waitingRequest.mDelagete != null) {
                                            Logger.v(AuthenticationContext.TAG, "Sending result to callback. " + authenticationRequest.getLogInfo());
                                            callbackHandle.onSuccess(result);
                                        }
                                    } else {
                                        callbackHandle.onError(new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN));
                                    }
                                }
                                finally {
                                    AuthenticationContext.this.removeWaitingRequest(requestId);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private static boolean isUserMisMatch(String userId, AuthenticationResult result) {
        return !StringExtensions.IsNullOrBlank(userId) && result.getUserInfo() != null && !StringExtensions.IsNullOrBlank(result.getUserInfo().getUserId()) && !userId.equalsIgnoreCase(result.getUserInfo().getUserId());
    }

    private String getCorrelationInfoFromWaitingRequest(AuthenticationRequestState waitingRequest) {
        UUID requestCorrelationID = this.getRequestCorrelationId();
        if (waitingRequest.mRequest != null) {
            requestCorrelationID = waitingRequest.mRequest.getCorrelationId();
        }
        String correlationInfo = String.format(" CorrelationId: %s", requestCorrelationID.toString());
        return correlationInfo;
    }

    private String getCorrelationLogInfo() {
        return " CorrelationId: " + this.getRequestCorrelationId();
    }

    private void waitingRequestOnError(AuthenticationRequestState waitingRequest, int requestId, Exception exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            waitingRequest.mDelagete.onError(exc);
        }
        this.removeWaitingRequest(requestId);
    }

    private void waitingRequestOnError(CallbackHandler handler, AuthenticationRequestState waitingRequest, int requestId, Exception exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            handler.onError(exc);
        }
        this.removeWaitingRequest(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWaitingRequest(int requestId) {
        Logger.v(TAG, "Remove waiting request: " + requestId + this.getCorrelationLogInfo());
        writeLock.lock();
        try {
            mDelegateMap.remove(requestId);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationRequestState getWaitingRequest(int requestId) {
        Logger.v(TAG, "Get waiting request: " + requestId + this.getCorrelationLogInfo());
        AuthenticationRequestState request = null;
        readLock.lock();
        try {
            request = (AuthenticationRequestState)mDelegateMap.get(requestId);
        }
        finally {
            readLock.unlock();
        }
        if (request == null && this.mAuthorizationCallback != null && requestId == this.mAuthorizationCallback.hashCode()) {
            Logger.e(TAG, "Request callback is not available for requestid:" + requestId + this.getCorrelationLogInfo() + ". It will use last callback.", "", ADALError.CALLBACK_IS_NOT_FOUND);
            request = new AuthenticationRequestState(0, null, this.mAuthorizationCallback);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWaitingRequest(int requestId, AuthenticationRequestState requestState) {
        Logger.v(TAG, "Put waiting request: " + requestId + this.getCorrelationInfoFromWaitingRequest(requestState));
        if (requestState != null) {
            writeLock.lock();
            try {
                mDelegateMap.put(requestId, (Object)requestState);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public boolean cancelAuthenticationActivity(int requestId) {
        AuthenticationRequestState request = this.getWaitingRequest(requestId);
        if (request == null || request.mDelagete == null) {
            Logger.v(TAG, "Current callback is empty. There is not any active authentication." + this.getCorrelationLogInfo());
            return true;
        }
        String currentCorrelationInfo = this.getCorrelationInfoFromWaitingRequest(request);
        Logger.v(TAG, "Current callback is not empty. There is an active authentication Activity." + currentCorrelationInfo);
        Intent intent = new Intent("com.microsoft.aad.adal:BrowserCancel");
        Bundle extras = new Bundle();
        intent.putExtras(extras);
        intent.putExtra("com.microsoft.aad.adal:RequestId", requestId);
        boolean cancelResult = LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        if (cancelResult) {
            Logger.v(TAG, "Cancel broadcast message was successful." + currentCorrelationInfo);
            request.mCancelled = true;
            request.mDelagete.onError(new AuthenticationCancelError());
        } else {
            Logger.w(TAG, "Cancel broadcast message was not successful." + currentCorrelationInfo, "", ADALError.BROADCAST_CANCEL_NOT_SUCCESSFUL);
        }
        return cancelResult;
    }

    private void acquireTokenLocal(final Activity activity, final AuthenticationRequest request, AuthenticationCallback<AuthenticationResult> externalCall) {
        this.getHandler();
        final CallbackHandler callbackHandle = new CallbackHandler(this.mHandler, externalCall);
        Logger.v(TAG, "Sending async task from thread:" + Process.myTid());
        if (!this.insideBroker()) {
            sThreadExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    Logger.v(AuthenticationContext.TAG, "Running task in thread:" + Process.myTid());
                    AuthenticationContext.this.acquireTokenLocalCall(callbackHandle, activity, request);
                }
            });
        } else {
            Logger.v(TAG, "Running for broker without executor service:" + Process.myTid());
            this.acquireTokenLocalCall(callbackHandle, activity, request);
        }
    }

    private boolean insideBroker() {
        return this.mContext.getPackageName().equals(AuthenticationSettings.INSTANCE.getBrokerPackageName());
    }

    private void acquireTokenLocalCall(CallbackHandler callbackHandle, Activity activity, AuthenticationRequest request) {
        URL authorityUrl = StringExtensions.getUrl(this.mAuthority);
        if (authorityUrl == null) {
            callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL));
            return;
        }
        if (this.mValidateAuthority && !this.mAuthorityValidated) {
            try {
                URL authorityUrlInCallback = authorityUrl;
                boolean result = this.validateAuthority(authorityUrl);
                if (!result) {
                    Logger.v(TAG, "Call external callback since instance is invalid" + authorityUrlInCallback.toString() + this.getCorrelationLogInfo());
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                    return;
                }
                this.mAuthorityValidated = true;
                Logger.v(TAG, "Authority is validated: " + authorityUrlInCallback.toString() + this.getCorrelationLogInfo());
            }
            catch (Exception exc) {
                Logger.e(TAG, "Authority validation has an error." + this.getCorrelationLogInfo(), "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, exc);
                callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                return;
            }
        }
        this.acquireTokenAfterValidation(callbackHandle, activity, request);
    }

    private void acquireTokenAfterValidation(CallbackHandler callbackHandle, Activity activity, AuthenticationRequest request) {
        Logger.v(TAG, "Token request started" + this.getCorrelationLogInfo());
        if (this.mBrokerProxy.canSwitchToBroker()) {
            Logger.v(TAG, "It switched to broker for context: " + this.mContext.getPackageName());
            AuthenticationResult result = null;
            if (request.getPrompt() != PromptBehavior.Always) {
                try {
                    result = this.mBrokerProxy.getAuthTokenInBackground(request);
                }
                catch (AuthenticationException ex) {
                    callbackHandle.onError(ex);
                    return;
                }
            }
            if (result != null && result.getAccessToken() != null && !result.getAccessToken().isEmpty()) {
                Logger.v(TAG, "Token is returned from background call " + this.getCorrelationLogInfo());
                callbackHandle.onSuccess(result);
                return;
            }
            if (request.getPrompt() != PromptBehavior.Never) {
                Logger.v(TAG, "Launch activity for Authenticator");
                this.mAuthorizationCallback = callbackHandle.callback;
                request.setRequestId(callbackHandle.callback.hashCode());
                Logger.v(TAG, "Starting Authentication Activity with callback:" + callbackHandle.callback.hashCode() + this.getCorrelationLogInfo());
                this.putWaitingRequest(callbackHandle.callback.hashCode(), new AuthenticationRequestState(callbackHandle.callback.hashCode(), request, callbackHandle.callback));
                Intent brokerIntent = this.mBrokerProxy.getIntentForBrokerActivity(request);
                if (brokerIntent != null) {
                    try {
                        Logger.v(TAG, "Calling activity pid:" + Process.myPid() + " tid:" + Process.myTid() + "uid:" + Process.myUid());
                        activity.startActivityForResult(brokerIntent, 1001);
                    }
                    catch (ActivityNotFoundException e) {
                        Logger.e(TAG, "Activity login is not found after resolving intent" + this.getCorrelationLogInfo(), "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
                        callbackHandle.onError(new AuthenticationException(ADALError.BROKER_ACTIVITY_IS_NOT_RESOLVED));
                    }
                } else {
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED));
                }
            } else {
                Logger.e(TAG, "Prompt is not allowed and failed to get token:" + callbackHandle.callback.hashCode() + this.getCorrelationLogInfo(), "", ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                callbackHandle.onError(new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED));
            }
        } else {
            this.localFlow(callbackHandle, activity, request);
        }
    }

    private void localFlow(CallbackHandler callbackHandle, Activity activity, AuthenticationRequest request) {
        AuthenticationResult cachedItem = this.getItemFromCache(request);
        if (cachedItem != null && AuthenticationContext.isUserMisMatch(request.getLoginHint(), cachedItem)) {
            callbackHandle.onError(new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH));
            return;
        }
        if (request.getPrompt() != PromptBehavior.Always && this.isValidCache(cachedItem)) {
            Logger.v(TAG, "Token is returned from cache" + this.getCorrelationLogInfo());
            callbackHandle.onSuccess(cachedItem);
            return;
        }
        Logger.v(TAG, "Checking refresh tokens" + this.getCorrelationLogInfo());
        RefreshItem refreshItem = this.getRefreshToken(request);
        if (request.getPrompt() != PromptBehavior.Always && refreshItem != null && !StringExtensions.IsNullOrBlank(refreshItem.mRefreshToken)) {
            Logger.v(TAG, "Refresh token is available and it will attempt to refresh token" + this.getCorrelationLogInfo());
            this.refreshToken(callbackHandle, activity, request, refreshItem, true);
        } else {
            Logger.v(TAG, "Refresh token is not available" + this.getCorrelationLogInfo());
            if (request.getPrompt() != PromptBehavior.Never) {
                this.mAuthorizationCallback = callbackHandle.callback;
                request.setRequestId(callbackHandle.callback.hashCode());
                Logger.v(TAG, "Starting Authentication Activity with callback:" + callbackHandle.callback.hashCode() + this.getCorrelationLogInfo());
                this.putWaitingRequest(callbackHandle.callback.hashCode(), new AuthenticationRequestState(callbackHandle.callback.hashCode(), request, callbackHandle.callback));
                if (!this.startAuthenticationActivity(activity, request)) {
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED));
                }
            } else {
                Logger.e(TAG, "Prompt is not allowed and failed to get token:" + callbackHandle.callback.hashCode() + this.getCorrelationLogInfo(), "", ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                callbackHandle.onError(new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED));
            }
        }
    }

    protected boolean isRefreshable(AuthenticationResult cachedItem) {
        return cachedItem != null && !StringExtensions.IsNullOrBlank(cachedItem.getRefreshToken());
    }

    private boolean isValidCache(AuthenticationResult cachedItem) {
        return cachedItem != null && !StringExtensions.IsNullOrBlank(cachedItem.getAccessToken()) && !cachedItem.isExpired();
    }

    private AuthenticationResult getItemFromCache(AuthenticationRequest request) {
        TokenCacheItem item;
        if (this.mTokenCacheStore != null && (item = this.mTokenCacheStore.getItem(CacheKey.createCacheKey(request))) != null) {
            Logger.v(TAG, "getItemFromCache accessTokenId:" + this.getTokenHash(item.getAccessToken()) + " refreshTokenId:" + this.getTokenHash(item.getRefreshToken()));
            AuthenticationResult result = new AuthenticationResult(item.getAccessToken(), item.getRefreshToken(), item.getExpiresOn(), item.getIsMultiResourceRefreshToken(), item.getUserInfo());
            return result;
        }
        return null;
    }

    private String getTokenHash(String token) {
        try {
            return StringExtensions.createHash(token);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest error", "", ADALError.DEVICE_NO_SUCH_ALGORITHM, e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Digest error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
        }
        return "";
    }

    private RefreshItem getRefreshToken(AuthenticationRequest request) {
        RefreshItem refreshItem = null;
        if (this.mTokenCacheStore != null) {
            boolean multiResource = false;
            Logger.v(TAG, "Looking for regular refresh token" + this.getCorrelationLogInfo());
            String keyUsed = CacheKey.createCacheKey(request);
            TokenCacheItem item = this.mTokenCacheStore.getItem(keyUsed);
            if (item == null || StringExtensions.IsNullOrBlank(item.getRefreshToken())) {
                Logger.v(TAG, "Looking for Multi Resource Refresh token" + this.getCorrelationLogInfo());
                keyUsed = CacheKey.createMultiResourceRefreshTokenKey(request);
                item = this.mTokenCacheStore.getItem(keyUsed);
                multiResource = true;
            }
            if (item != null && !StringExtensions.IsNullOrBlank(item.getRefreshToken())) {
                String refreshTokenHash = this.getTokenHash(item.getRefreshToken());
                Logger.v(TAG, "Refresh token is available and id:" + refreshTokenHash + " Key used:" + keyUsed + this.getCorrelationLogInfo());
                refreshItem = new RefreshItem(keyUsed, item.getRefreshToken(), multiResource, item.getUserInfo());
            }
        }
        return refreshItem;
    }

    private void setItemToCache(AuthenticationRequest request, AuthenticationResult result) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Setting item to cache" + this.getCorrelationLogInfo());
            this.logReturnedToken(request, result);
            this.mTokenCacheStore.setItem(CacheKey.createCacheKey(request), new TokenCacheItem(request, result, false));
            if (result.getIsMultiResourceRefreshToken()) {
                Logger.v(TAG, "Setting Multi Resource Refresh token to cache" + this.getCorrelationLogInfo());
                this.mTokenCacheStore.setItem(CacheKey.createMultiResourceRefreshTokenKey(request), new TokenCacheItem(request, result, true));
            }
        }
    }

    private void logReturnedToken(AuthenticationRequest request, AuthenticationResult result) {
        if (result != null && result.getAccessToken() != null) {
            String accessTokenHash = this.getTokenHash(result.getAccessToken());
            String refreshTokenHash = this.getTokenHash(result.getRefreshToken());
            Logger.v(TAG, String.format("Access TokenID %s and Refresh TokenID %s returned. CorrelationId: %s", accessTokenHash, refreshTokenHash, request.getCorrelationId()));
        }
    }

    private void setRefreshItemToCache(RefreshItem refreshItem, AuthenticationRequest request, AuthenticationResult result) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Setting refresh item to cache for key:" + refreshItem.mKey + this.getCorrelationLogInfo());
            this.logReturnedToken(request, result);
            this.mTokenCacheStore.setItem(refreshItem.mKey, new TokenCacheItem(request, result, refreshItem.mMultiResource));
            if (refreshItem.mMultiResource) {
                this.mTokenCacheStore.setItem(CacheKey.createCacheKey(request), new TokenCacheItem(request, result, false));
            } else if (result.getIsMultiResourceRefreshToken()) {
                Logger.v(TAG, "Setting Multi Resource Refresh token to cache" + this.getCorrelationLogInfo());
                this.mTokenCacheStore.setItem(CacheKey.createMultiResourceRefreshTokenKey(request), new TokenCacheItem(request, result, true));
            }
        }
    }

    private void removeItemFromCache(RefreshItem refreshItem) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Remove refresh item from cache:" + refreshItem.mKey + this.getCorrelationLogInfo());
            this.mTokenCacheStore.removeItem(refreshItem.mKey);
        }
    }

    private void refreshToken(CallbackHandler callbackHandle, Activity activity, AuthenticationRequest request, RefreshItem refreshItem, boolean useCache) {
        Logger.v(TAG, "Process refreshToken for " + request.getLogInfo() + " refreshTokenId:" + this.getTokenHash(refreshItem.mRefreshToken));
        if (!this.mConnectionService.isConnectionAvailable()) {
            Logger.w(TAG, "Connection is not available to refresh token", request.getLogInfo(), ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE);
            callbackHandle.onError(new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE));
            return;
        }
        AuthenticationResult result = null;
        try {
            Oauth2 oauthRequest = new Oauth2(request, this.mWebRequest);
            result = oauthRequest.refreshToken(refreshItem.mRefreshToken);
        }
        catch (Exception exc) {
            Logger.e(TAG, "Error in refresh token for request:" + request.getLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTH_FAILED_NO_TOKEN, exc);
            if (useCache) {
                Logger.v(TAG, "Error in refresh token. Cache is used. It will remove item from cache" + request.getLogInfo());
                this.removeItemFromCache(refreshItem);
            }
            callbackHandle.onError(exc);
            return;
        }
        if (useCache) {
            if (result == null || StringExtensions.IsNullOrBlank(result.getAccessToken())) {
                Logger.w(TAG, "Refresh token did not return accesstoken.", request.getLogInfo() + result.getErrorLogInfo(), ADALError.AUTH_FAILED_NO_TOKEN);
                this.removeItemFromCache(refreshItem);
                this.acquireTokenLocalCall(callbackHandle, activity, request);
            } else {
                Logger.v(TAG, "It finished refresh token request:" + request.getLogInfo());
                if (refreshItem.mUserInfo != null) {
                    Logger.v(TAG, "UserInfo is updated:" + request.getLogInfo());
                    result.setUserInfo(refreshItem.mUserInfo);
                }
                Logger.v(TAG, "Cache is used. It will set item to cache" + request.getLogInfo());
                this.setRefreshItemToCache(refreshItem, request, result);
                callbackHandle.onSuccess(result);
            }
        } else {
            Logger.v(TAG, "Cache is not used for Request:" + request.getLogInfo());
            callbackHandle.onSuccess(result);
        }
    }

    private boolean validateAuthority(URL authorityUrl) {
        if (this.mDiscovery != null) {
            Logger.v(TAG, "Start validating authority:" + this.getCorrelationLogInfo());
            this.mDiscovery.setCorrelationId(this.getRequestCorrelationId());
            try {
                boolean result = this.mDiscovery.isValidAuthority(authorityUrl);
                Logger.v(TAG, "Finish validating authority:" + this.getCorrelationLogInfo() + " result:" + result);
                return result;
            }
            catch (Exception exc) {
                Logger.e(TAG, "Instance validation returned error" + this.getCorrelationLogInfo(), "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, exc);
            }
        }
        return false;
    }

    private String getRedirectFromPackage() {
        return this.mContext.getApplicationContext().getPackageName();
    }

    private boolean startAuthenticationActivity(Activity activity, AuthenticationRequest request) {
        Intent intent = this.getAuthenticationActivityIntent(activity, request);
        if (!this.resolveIntent(intent)) {
            Logger.e(TAG, "Intent is not resolved" + this.getCorrelationLogInfo(), "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
            return false;
        }
        try {
            activity.startActivityForResult(intent, 1001);
        }
        catch (ActivityNotFoundException e) {
            Logger.e(TAG, "Activity login is not found after resolving intent" + this.getCorrelationLogInfo(), "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
            return false;
        }
        return true;
    }

    private final boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private final Intent getAuthenticationActivityIntent(Activity activity, AuthenticationRequest request) {
        Intent intent = new Intent();
        intent.setClass((Context)activity, AuthenticationActivity.class);
        intent.putExtra("com.microsoft.aad.adal:BrowserRequestMessage", (Serializable)request);
        return intent;
    }

    public UUID getRequestCorrelationId() {
        if (this.mRequestCorrelationId == null) {
            this.mRequestCorrelationId = UUID.randomUUID();
            Logger.v(TAG, "CorrelationId generated " + this.mRequestCorrelationId.toString());
        }
        return this.mRequestCorrelationId;
    }

    public void setRequestCorrelationId(UUID mRequestCorrelationId) {
        this.mRequestCorrelationId = mRequestCorrelationId;
    }

    private void refreshTokenWithoutCache(final String refreshToken, final String clientId, final String resource, AuthenticationCallback<AuthenticationResult> externalCallback) {
        Logger.v(TAG, "Refresh token without cache" + this.getCorrelationLogInfo());
        if (StringExtensions.IsNullOrBlank(refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (externalCallback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), externalCallback);
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                URL authorityUrl = StringExtensions.getUrl(AuthenticationContext.this.mAuthority);
                if (authorityUrl == null) {
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL));
                    return;
                }
                AuthenticationRequest request = new AuthenticationRequest(AuthenticationContext.this.mAuthority, resource, clientId, AuthenticationContext.this.getRequestCorrelationId());
                request.setPrompt(PromptBehavior.Never);
                RefreshItem refreshItem = new RefreshItem("", refreshToken, false, null);
                if (AuthenticationContext.this.mValidateAuthority) {
                    Logger.v(AuthenticationContext.TAG, "Validating authority" + AuthenticationContext.this.getCorrelationLogInfo());
                    try {
                        if (!AuthenticationContext.this.validateAuthority(authorityUrl)) {
                            Logger.v(AuthenticationContext.TAG, "Call callback since instance is invalid:" + authorityUrl.toString() + AuthenticationContext.this.getCorrelationLogInfo());
                            callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                            return;
                        }
                        Logger.v(AuthenticationContext.TAG, "Authority is validated" + authorityUrl.toString() + AuthenticationContext.this.getCorrelationLogInfo());
                    }
                    catch (Exception exc) {
                        Logger.e(AuthenticationContext.TAG, "Authority validation is failed" + AuthenticationContext.this.getCorrelationLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.SERVER_INVALID_REQUEST, exc);
                        callbackHandle.onError(exc);
                        return;
                    }
                }
                AuthenticationContext.this.refreshToken(callbackHandle, null, request, refreshItem, false);
            }
        });
    }

    private synchronized Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
        }
        return this.mHandler;
    }

    private static String extractAuthority(String authority) {
        int fourthSlash;
        int thirdSlash;
        if (!(StringExtensions.IsNullOrBlank(authority) || (thirdSlash = authority.indexOf("/", 8)) < 0 || thirdSlash == authority.length() - 1 || (fourthSlash = authority.indexOf("/", thirdSlash + 1)) >= 0 && fourthSlash <= thirdSlash + 1)) {
            if (fourthSlash >= 0) {
                return authority.substring(0, fourthSlash);
            }
            return authority;
        }
        throw new IllegalArgumentException("authority");
    }

    private void checkInternetPermission() {
        PackageManager pm = this.mContext.getPackageManager();
        if (0 != pm.checkPermission("android.permission.INTERNET", this.mContext.getPackageName())) {
            throw new AuthenticationException(ADALError.DEVELOPER_INTERNET_PERMISSION_MISSING);
        }
    }

    public static String getVersionName() {
        return "0.7";
    }

    class DefaultConnectionService
    implements IConnectionService {
        private Context mConnectionContext;

        DefaultConnectionService(Context ctx) {
            this.mConnectionContext = ctx;
        }

        @Override
        public boolean isConnectionAvailable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
    }

    private class RefreshItem {
        String mRefreshToken;
        String mKey;
        boolean mMultiResource;
        UserInfo mUserInfo;

        public RefreshItem(String keyInCache, String refreshTokenValue, boolean multiResource, UserInfo userInfo) {
            this.mKey = keyInCache;
            this.mRefreshToken = refreshTokenValue;
            this.mMultiResource = multiResource;
            this.mUserInfo = userInfo;
        }
    }

    class CallbackHandler {
        Handler mRefHandler;
        AuthenticationCallback<AuthenticationResult> callback;

        public CallbackHandler(Handler ref, AuthenticationCallback<AuthenticationResult> callbackExt) {
            this.mRefHandler = ref;
            this.callback = callbackExt;
        }

        public void onError(final Exception e) {
            this.mRefHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackHandler.this.callback.onError(e);
                }
            });
        }

        public void onSuccess(final AuthenticationResult result) {
            this.mRefHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackHandler.this.callback.onSuccess(result);
                }
            });
        }
    }

    static interface ResponseCallback {
        public void onRequestComplete(HashMap<String, String> var1);
    }
}

