/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.PromptBehavior;
import java.io.Serializable;
import java.util.UUID;

class AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int mRequestId = 0;
    private String mAuthority = null;
    private String mRedirectUri = null;
    private String mResource = null;
    private String mClientId = null;
    private String mLoginHint = null;
    private String mBrokerAccountName = null;
    private UUID mCorrelationId;
    private String mExtraQueryParamsAuthentication;
    private PromptBehavior mPrompt;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, PromptBehavior prompt, String extraQueryParams, UUID correlationId) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mLoginHint = loginhint;
        this.mPrompt = prompt;
        this.mExtraQueryParamsAuthentication = extraQueryParams;
        this.mCorrelationId = correlationId;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, UUID requestCorrelationId) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mLoginHint = loginhint;
        this.mCorrelationId = requestCorrelationId;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mLoginHint = loginhint;
    }

    public AuthenticationRequest(String authority, String resource, String clientid) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
    }

    public AuthenticationRequest(String authority, String resource, String clientid, String redirectUri) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
        this.mRedirectUri = redirectUri;
    }

    public AuthenticationRequest(String authority, String resource, String clientId, UUID correlationId) {
        this.mAuthority = authority;
        this.mClientId = clientId;
        this.mResource = resource;
        this.mCorrelationId = correlationId;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getExtraQueryParamsAuthentication() {
        return this.mExtraQueryParamsAuthentication;
    }

    public String getLogInfo() {
        String correlation = "";
        if (this.mCorrelationId != null) {
            correlation = this.mCorrelationId.toString();
        }
        return String.format("Request authority:%s resource:%s clientid:%s correlationId:%s", this.mAuthority, this.mResource, this.mClientId, correlation);
    }

    public PromptBehavior getPrompt() {
        return this.mPrompt;
    }

    public void setPrompt(PromptBehavior prompt) {
        this.mPrompt = prompt;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public String getBrokerAccountName() {
        return this.mBrokerAccountName;
    }

    public void setBrokerAccountName(String mBrokerAccountName) {
        this.mBrokerAccountName = mBrokerAccountName;
    }

    void setLoginHint(String name) {
        this.mLoginHint = name;
    }
}

