/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.ITokenStoreQuery;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StorageHelper;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

public class DefaultTokenCacheStore
implements ITokenCacheStore,
ITokenStoreQuery {
    private static final long serialVersionUID = 1L;
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.aad.adal.cache";
    private static final String TAG = "DefaultTokenCacheStore";
    SharedPreferences mPrefs;
    private Context mContext;
    private Gson mGson = new Gson();
    private static StorageHelper sHelper;
    private static Object sLock;
    private static final int TOKEN_VALIDITY_WINDOW = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTokenCacheStore(Context context) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.mContext = context;
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        this.mPrefs = this.mContext.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        Object object = sLock;
        synchronized (object) {
            if (sHelper == null) {
                Logger.v(TAG, "Started to initialize storage helper");
                sHelper = new StorageHelper(context);
                Logger.v(TAG, "Finished to initialize storage helper");
            }
        }
    }

    private String encrypt(String value) {
        try {
            return sHelper.encrypt(value);
        }
        catch (Exception e) {
            Logger.e(TAG, "Encryption failure", "", ADALError.ENCRYPTION_FAILED, e);
            return null;
        }
    }

    private String decrypt(String value) {
        try {
            return sHelper.decrypt(value);
        }
        catch (Exception e) {
            Logger.e(TAG, "Decryption failure", "", ADALError.ENCRYPTION_FAILED, e);
            if (!StringExtensions.IsNullOrBlank(value)) {
                Logger.v(TAG, String.format("Decryption error for key: '%s'. Item will be removed", value));
                this.removeItem(value);
                Logger.v(TAG, String.format("Item removed for key: '%s'", value));
            }
            return null;
        }
    }

    @Override
    public TokenCacheItem getItem(String key) {
        String json;
        String decrypted;
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (this.mPrefs.contains(key) && (decrypted = this.decrypt(json = this.mPrefs.getString(key, ""))) != null) {
            return (TokenCacheItem)this.mGson.fromJson(decrypted, TokenCacheItem.class);
        }
        return null;
    }

    @Override
    public void removeItem(String key) {
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (this.mPrefs.contains(key)) {
            SharedPreferences.Editor prefsEditor = this.mPrefs.edit();
            prefsEditor.remove(key);
            prefsEditor.apply();
        }
    }

    @Override
    public void setItem(String key, TokenCacheItem item) {
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        String json = this.mGson.toJson((Object)item);
        String encrypted = this.encrypt(json);
        if (encrypted != null) {
            SharedPreferences.Editor prefsEditor = this.mPrefs.edit();
            prefsEditor.putString(key, encrypted);
            prefsEditor.apply();
        } else {
            Logger.e(TAG, "Encrypted output is null", "", ADALError.ENCRYPTION_FAILED);
        }
    }

    @Override
    public void removeAll() {
        this.argumentCheck();
        SharedPreferences.Editor prefsEditor = this.mPrefs.edit();
        prefsEditor.clear();
        prefsEditor.apply();
    }

    @Override
    public Iterator<TokenCacheItem> getAll() {
        this.argumentCheck();
        Map results = this.mPrefs.getAll();
        Iterator values = results.values().iterator();
        ArrayList<TokenCacheItem> tokens = new ArrayList<TokenCacheItem>(results.values().size());
        while (values.hasNext()) {
            String json = (String)values.next();
            String decrypted = this.decrypt(json);
            if (decrypted == null) continue;
            TokenCacheItem cacheItem = (TokenCacheItem)this.mGson.fromJson(decrypted, TokenCacheItem.class);
            tokens.add(cacheItem);
        }
        return tokens.iterator();
    }

    @Override
    public HashSet<String> getUniqueUsersWithTokenCache() {
        Iterator<TokenCacheItem> results = this.getAll();
        HashSet<String> users = new HashSet<String>();
        while (results.hasNext()) {
            TokenCacheItem item = results.next();
            if (item.getUserInfo() == null || users.contains(item.getUserInfo().getUserId())) continue;
            users.add(item.getUserInfo().getUserId());
        }
        return users;
    }

    @Override
    public ArrayList<TokenCacheItem> getTokensForResource(String resource) {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem item = results.next();
            if (!item.getResource().equals(resource)) continue;
            tokenItems.add(item);
        }
        return tokenItems;
    }

    @Override
    public ArrayList<TokenCacheItem> getTokensForUser(String userid) {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem item = results.next();
            if (item.getUserInfo() == null || !item.getUserInfo().getUserId().equalsIgnoreCase(userid)) continue;
            tokenItems.add(item);
        }
        return tokenItems;
    }

    @Override
    public void clearTokensForUser(String userid) {
        ArrayList<TokenCacheItem> results = this.getTokensForUser(userid);
        for (TokenCacheItem item : results) {
            if (item.getUserInfo() == null || !item.getUserInfo().getUserId().equalsIgnoreCase(userid)) continue;
            this.removeItem(CacheKey.createCacheKey(item));
        }
    }

    @Override
    public ArrayList<TokenCacheItem> getTokensAboutToExpire() {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem item = results.next();
            if (!this.isAboutToExpire(item.getExpiresOn())) continue;
            tokenItems.add(item);
        }
        return tokenItems;
    }

    private void argumentCheck() {
        if (this.mContext == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED);
        }
        if (this.mPrefs == null) {
            throw new AuthenticationException(ADALError.DEVICE_SHARED_PREF_IS_NOT_AVAILABLE);
        }
    }

    private boolean isAboutToExpire(Date expires) {
        Date validity = DefaultTokenCacheStore.getTokenValidityTime().getTime();
        return expires != null && expires.before(validity);
    }

    private static Calendar getTokenValidityTime() {
        Calendar timeAhead = Calendar.getInstance();
        timeAhead.add(13, 10);
        return timeAhead;
    }

    @Override
    public boolean contains(String key) {
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        return this.mPrefs.contains(key);
    }

    static {
        sLock = new Object();
    }
}

