/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.Logger;
import java.io.Serializable;

abstract class BasicWebViewClient
extends WebViewClient {
    private static final String TAG = "BasicWebViewClient";
    public static final String BLANK_PAGE = "about:blank";
    protected String mRedirect;
    protected int mRequestCode;
    protected AuthenticationRequest mRequest;

    public BasicWebViewClient() {
        this.mRedirect = null;
        this.mRequestCode = 0;
        this.mRequest = null;
    }

    public BasicWebViewClient(String redirect, int requestCode, AuthenticationRequest request) {
        this.mRedirect = redirect;
        this.mRequestCode = requestCode;
        this.mRequest = request;
    }

    public abstract void showSpinner(boolean var1);

    public abstract void sendResponse(int var1, Intent var2);

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.showSpinner(false);
        Logger.e(TAG, "Webview received an error. Errorcode:" + errorCode + " " + description, "", ADALError.ERROR_WEBVIEW);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        this.showSpinner(false);
        handler.cancel();
        Logger.e(TAG, "Received ssl error", "", ADALError.ERROR_FAILED_SSL_HANDSHAKE);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        Logger.v(TAG, "Page finished:" + url);
        view.setVisibility(0);
        if (!url.startsWith(BLANK_PAGE)) {
            this.showSpinner(false);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.showSpinner(true);
    }
}

