/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.MemoryTokenCacheStore;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;

public class FileTokenCacheStore
implements ITokenCacheStore {
    private static final long serialVersionUID = -8252291336171327870L;
    private static final String TAG = null;
    private final String mFileName;
    private final File mDirectory;
    private final File mFile;
    private final MemoryTokenCacheStore mInMemoryCache;
    private final Object mCacheLock = new Object();

    public FileTokenCacheStore(Context context, String fileName) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        if (StringExtensions.IsNullOrBlank(fileName)) {
            throw new IllegalArgumentException("fileName");
        }
        this.mFileName = fileName;
        this.mDirectory = context.getDir(context.getPackageName(), 0);
        if (this.mDirectory == null) {
            throw new IllegalStateException("It could not access the Authorization cache directory");
        }
        try {
            this.mFile = new File(this.mDirectory, this.mFileName);
            if (this.mFile.exists()) {
                Logger.v(TAG, "There is previous cache file to load cache.");
                FileInputStream inputStream = new FileInputStream(this.mFile);
                ObjectInputStream objectStream = new ObjectInputStream(inputStream);
                Object cacheObj = objectStream.readObject();
                inputStream.close();
                objectStream.close();
                if (cacheObj instanceof MemoryTokenCacheStore) {
                    this.mInMemoryCache = (MemoryTokenCacheStore)cacheObj;
                } else {
                    Logger.w(TAG, "Existing cache format is wrong", "", ADALError.DEVICE_FILE_CACHE_FORMAT_IS_WRONG);
                    this.mInMemoryCache = new MemoryTokenCacheStore();
                }
            } else {
                Logger.v(TAG, "There is not any previous cache file to load cache.");
                this.mInMemoryCache = new MemoryTokenCacheStore();
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.e(TAG, "Exception during cache load", ExceptionExtensions.getExceptionMessage(ex), ADALError.DEVICE_FILE_CACHE_IS_NOT_LOADED_FROM_FILE);
            throw new AuthenticationException(ADALError.DEVICE_FILE_CACHE_IS_NOT_LOADED_FROM_FILE);
        }
    }

    @Override
    public TokenCacheItem getItem(String key) {
        return this.mInMemoryCache.getItem(key);
    }

    @Override
    public boolean contains(String key) {
        return this.mInMemoryCache.contains(key);
    }

    @Override
    public void setItem(String key, TokenCacheItem item) {
        this.mInMemoryCache.setItem(key, item);
        this.writeToFile();
    }

    @Override
    public void removeItem(String key) {
        this.mInMemoryCache.removeItem(key);
        this.writeToFile();
    }

    @Override
    public void removeAll() {
        this.mInMemoryCache.removeAll();
        this.writeToFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mFile != null && this.mInMemoryCache != null) {
                try {
                    FileOutputStream outputStream = new FileOutputStream(this.mFile);
                    ObjectOutputStream objectStream = new ObjectOutputStream(outputStream);
                    objectStream.writeObject(this.mInMemoryCache);
                    objectStream.flush();
                    objectStream.close();
                    outputStream.close();
                }
                catch (IOException ex) {
                    Logger.e(TAG, "Exception during cache flush", ExceptionExtensions.getExceptionMessage(ex), ADALError.DEVICE_FILE_CACHE_IS_NOT_WRITING_TO_FILE);
                }
            }
        }
    }

    @Override
    public Iterator<TokenCacheItem> getAll() {
        return this.mInMemoryCache.getAll();
    }
}

