// Copyright © Microsoft Open Technologies, Inc.
//
// All Rights Reserved
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// THIS CODE IS PROVIDED *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS
// OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
// ANY IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A
// PARTICULAR PURPOSE, MERCHANTABILITY OR NON-INFRINGEMENT.
//
// See the Apache License, Version 2.0 for the specific language
// governing permissions and limitations under the License.

package com.microsoft.aad.adal;

import android.content.Intent;

/**
 * Implement this interface to pass fragment. You can also use custom webview
 * with WebviewHelper.
 */
public interface IWindowComponent {
    /**
     * ADAL will send request in the intent data and request Code. When your
     * fragment, activity or dialog finishes after reaching to redirect, it
     * should call onActivityResult to complete the call.
     * 
     * @param intent
     * @param requestCode
     */
    void startActivityForResult(Intent intent, int requestCode);
}
