/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import java.io.Serializable;
import java.util.Locale;

public final class CacheKey
implements Serializable {
    private static final long serialVersionUID = 8067972995583126404L;
    private String mAuthority = null;
    private String mResource = null;
    private String mClientId = null;
    private String mUserId;
    private boolean mIsMultipleResourceRefreshToken;

    private CacheKey() {
    }

    public String toString() {
        return String.format(Locale.US, "%s$%s$%s$%s$%s", this.mAuthority, this.mResource, this.mClientId, this.mIsMultipleResourceRefreshToken ? "y" : "n", this.mUserId);
    }

    public static String createCacheKey(String authority, String resource, String clientId, boolean isMultiResourceRefreshToken, String userId) {
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("clientId");
        }
        CacheKey key = new CacheKey();
        if (!isMultiResourceRefreshToken) {
            if (resource == null) {
                throw new IllegalArgumentException("resource");
            }
            key.mResource = resource;
        }
        key.mAuthority = authority.toLowerCase(Locale.US);
        if (key.mAuthority.endsWith("/")) {
            key.mAuthority = (String)key.mAuthority.subSequence(0, key.mAuthority.length() - 1);
        }
        key.mClientId = clientId.toLowerCase(Locale.US);
        key.mIsMultipleResourceRefreshToken = isMultiResourceRefreshToken;
        if (!StringExtensions.IsNullOrBlank(userId)) {
            key.mUserId = userId.toLowerCase(Locale.US);
        }
        return key.toString();
    }

    public static String createCacheKey(TokenCacheItem item) {
        if (item == null) {
            throw new IllegalArgumentException("TokenCacheItem");
        }
        String userid = null;
        if (item.getUserInfo() != null) {
            userid = item.getUserInfo().getUserId();
        }
        return CacheKey.createCacheKey(item.getAuthority(), item.getResource(), item.getClientId(), item.getIsMultiResourceRefreshToken(), userid);
    }

    public static String createCacheKey(AuthenticationRequest item, String cacheUserId) {
        if (item == null) {
            throw new IllegalArgumentException("AuthenticationRequest");
        }
        return CacheKey.createCacheKey(item.getAuthority(), item.getResource(), item.getClientId(), false, cacheUserId);
    }

    public static String createMultiResourceRefreshTokenKey(AuthenticationRequest item, String cacheUserId) {
        if (item == null) {
            throw new IllegalArgumentException("AuthenticationRequest");
        }
        return CacheKey.createCacheKey(item.getAuthority(), item.getResource(), item.getClientId(), true, cacheUserId);
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean getIsMultipleResourceRefreshToken() {
        return this.mIsMultipleResourceRefreshToken;
    }
}

