/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import java.util.HashMap;
import java.util.Map;

class InstrumentationPropertiesBuilder {
    private final Map<String, String> mProperties = new HashMap<String, String>();

    InstrumentationPropertiesBuilder(Exception exception) {
        this.addProperty("ErrorClass", exception.getClass().getSimpleName());
        this.addProperty("ErrorMessage", exception.getMessage());
    }

    InstrumentationPropertiesBuilder(AuthenticationRequest request, Exception exc) {
        this.addPropertiesForRequest(request);
        Throwable cause = exc.getCause() == null ? exc : exc.getCause();
        Class<?> causeClass = cause.getClass();
        ADALError errorCode = exc instanceof AuthenticationException ? ((AuthenticationException)exc).getCode() : null;
        this.addProperty("ErrorClass", causeClass.getSimpleName());
        this.addProperty("ErrorMessage", cause.getMessage());
        if (errorCode != null) {
            this.addProperty("ErrorCode", errorCode.getDescription());
        }
    }

    InstrumentationPropertiesBuilder(AuthenticationRequest request, AuthenticationResult result) {
        this.addPropertiesForRequest(request);
        if (result != null) {
            this.addProperty("ErrorMessage", result.getErrorDescription());
            this.addProperty("ErrorCode", result.getErrorCode());
        }
    }

    InstrumentationPropertiesBuilder add(String propertyName, String propertyValue) {
        this.addProperty(propertyName, propertyValue);
        return this;
    }

    Map<String, String> build() {
        return this.mProperties;
    }

    private void addProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            this.mProperties.put(propertyName, propertyValue);
        }
    }

    private void addPropertiesForRequest(AuthenticationRequest request) {
        this.addProperty("UserId", request.getUserId());
        this.addProperty("ResourceName", request.getResource());
        this.addProperty("Authority", request.getAuthority());
        this.addProperty("CorrelationId", request.getCorrelationId().toString());
    }
}

