/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.google.gson.JsonSyntaxException;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AbstractMetadataRequestor;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.DRSMetadata;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;

final class DRSMetadataRequestor
extends AbstractMetadataRequestor<DRSMetadata, String> {
    private static final String TAG = DRSMetadataRequestor.class.getSimpleName();
    private static final String DRS_URL_PREFIX = "https://enterpriseregistration.";
    private static final String CLOUD_RESOLVER_DOMAIN = "windows.net/";

    DRSMetadataRequestor() {
    }

    @Override
    DRSMetadata requestMetadata(String domain) throws AuthenticationException {
        try {
            return this.requestOnPrem(domain);
        }
        catch (UnknownHostException e) {
            return this.requestCloud(domain);
        }
    }

    private DRSMetadata requestOnPrem(String domain) throws UnknownHostException, AuthenticationException {
        Logger.v(TAG, "Requesting DRS discovery (on-prem)");
        return this.requestDrsDiscoveryInternal(Type.ON_PREM, domain);
    }

    private DRSMetadata requestCloud(String domain) throws AuthenticationException {
        Logger.v(TAG, "Requesting DRS discovery (cloud)");
        try {
            return this.requestDrsDiscoveryInternal(Type.CLOUD, domain);
        }
        catch (UnknownHostException e) {
            throw new AuthenticationException(ADALError.DRS_DISCOVERY_FAILED_UNKNOWN_HOST);
        }
    }

    private DRSMetadata requestDrsDiscoveryInternal(Type type, String domain) throws AuthenticationException, UnknownHostException {
        DRSMetadata metadata;
        URL requestURL;
        try {
            requestURL = new URL(this.buildRequestUrlByType(type, domain));
        }
        catch (MalformedURLException e) {
            throw new AuthenticationException(ADALError.DRS_METADATA_URL_INVALID);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (null != this.getCorrelationId()) {
            headers.put("client-request-id", this.getCorrelationId().toString());
        }
        try {
            HttpWebResponse webResponse = this.getWebrequestHandler().sendGet(requestURL, headers);
            int statusCode = webResponse.getStatusCode();
            if (200 != statusCode) {
                throw new AuthenticationException(ADALError.DRS_FAILED_SERVER_ERROR, "Unexpected error code: [" + statusCode + "]");
            }
            metadata = this.parseMetadata(webResponse);
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AuthenticationException(ADALError.IO_EXCEPTION);
        }
        return metadata;
    }

    @Override
    DRSMetadata parseMetadata(HttpWebResponse response) throws AuthenticationException {
        Logger.v(TAG, "Parsing DRS metadata response");
        try {
            return (DRSMetadata)this.parser().fromJson(response.getBody(), DRSMetadata.class);
        }
        catch (JsonSyntaxException e) {
            throw new AuthenticationException(ADALError.JSON_PARSE_ERROR);
        }
    }

    String buildRequestUrlByType(Type type, String domain) {
        StringBuilder requestUrl = new StringBuilder(DRS_URL_PREFIX);
        if (Type.CLOUD == type) {
            requestUrl.append(CLOUD_RESOLVER_DOMAIN).append(domain);
        } else if (Type.ON_PREM == type) {
            requestUrl.append(domain);
        }
        requestUrl.append("/enrollmentserver/contract?api-version=1.0");
        String requestUrlStr = requestUrl.toString();
        Logger.v(TAG, "Requestor will use DRS url: " + requestUrlStr);
        return requestUrlStr;
    }

    static enum Type {
        ON_PREM,
        CLOUD;

    }
}

