/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.ClientMetrics;
import com.microsoft.aad.adal.HttpEvent;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.ServerRespondingWithRetryableException;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.UserInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class Oauth2 {
    private AuthenticationRequest mRequest;
    private IWebRequestHandler mWebRequestHandler;
    private IJWSBuilder mJWSBuilder = new JWSBuilder();
    private static final String TAG = "Oauth";
    private boolean mRetryOnce = true;
    private static final int DELAY_TIME_PERIOD = 1000;
    private static final String DEFAULT_AUTHORIZE_ENDPOINT = "/oauth2/authorize";
    private static final String DEFAULT_TOKEN_ENDPOINT = "/oauth2/token";

    Oauth2(AuthenticationRequest request) {
        this.mRequest = request;
        this.mWebRequestHandler = null;
        this.mJWSBuilder = null;
    }

    public Oauth2(AuthenticationRequest request, IWebRequestHandler webRequestHandler) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = null;
    }

    public Oauth2(AuthenticationRequest request, IWebRequestHandler webRequestHandler, IJWSBuilder jwsMessageBuilder) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = jwsMessageBuilder;
    }

    public String getAuthorizationEndpoint() {
        return this.mRequest.getAuthority() + DEFAULT_AUTHORIZE_ENDPOINT;
    }

    public String getTokenEndpoint() {
        return this.mRequest.getAuthority() + DEFAULT_TOKEN_ENDPOINT;
    }

    public String getAuthorizationEndpointQueryParameters() throws UnsupportedEncodingException {
        Uri.Builder queryParameter = new Uri.Builder();
        queryParameter.appendQueryParameter("response_type", "code").appendQueryParameter("client_id", URLEncoder.encode(this.mRequest.getClientId(), "UTF_8")).appendQueryParameter("resource", URLEncoder.encode(this.mRequest.getResource(), "UTF_8")).appendQueryParameter("redirect_uri", URLEncoder.encode(this.mRequest.getRedirectUri(), "UTF_8")).appendQueryParameter("state", this.encodeProtocolState());
        if (!StringExtensions.isNullOrBlank(this.mRequest.getLoginHint())) {
            queryParameter.appendQueryParameter("login_hint", URLEncoder.encode(this.mRequest.getLoginHint(), "UTF_8"));
        }
        queryParameter.appendQueryParameter("x-client-SKU", "Android").appendQueryParameter("x-client-Ver", URLEncoder.encode(AuthenticationContext.getVersionName(), "UTF_8")).appendQueryParameter("x-client-OS", URLEncoder.encode(String.valueOf(Build.VERSION.SDK_INT), "UTF_8")).appendQueryParameter("x-client-DM", URLEncoder.encode(Build.MODEL, "UTF_8"));
        if (this.mRequest.getCorrelationId() != null) {
            queryParameter.appendQueryParameter("client-request-id", URLEncoder.encode(this.mRequest.getCorrelationId().toString(), "UTF_8"));
        }
        if (this.mRequest.getPrompt() == PromptBehavior.Always) {
            queryParameter.appendQueryParameter("prompt", URLEncoder.encode("login", "UTF_8"));
        } else if (this.mRequest.getPrompt() == PromptBehavior.REFRESH_SESSION) {
            queryParameter.appendQueryParameter("prompt", URLEncoder.encode("refresh_session", "UTF_8"));
        }
        String extraQP = this.mRequest.getExtraQueryParamsAuthentication();
        if (StringExtensions.isNullOrBlank(extraQP) || !extraQP.contains("haschrome")) {
            queryParameter.appendQueryParameter("haschrome", "1");
        }
        String requestUrl = queryParameter.build().getQuery();
        if (!StringExtensions.isNullOrBlank(extraQP)) {
            String parsedQP = extraQP;
            if (!extraQP.startsWith("&")) {
                parsedQP = "&" + parsedQP;
            }
            requestUrl = requestUrl + parsedQP;
        }
        return requestUrl;
    }

    public String getCodeRequestUrl() throws UnsupportedEncodingException {
        return String.format("%s?%s", this.getAuthorizationEndpoint(), this.getAuthorizationEndpointQueryParameters());
    }

    public String buildTokenRequestMessage(String code) throws UnsupportedEncodingException {
        Logger.v(TAG, "Building request message for redeeming token with auth code.");
        return String.format("%s=%s&%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.urlFormEncode("authorization_code"), "code", StringExtensions.urlFormEncode(code), "client_id", StringExtensions.urlFormEncode(this.mRequest.getClientId()), "redirect_uri", StringExtensions.urlFormEncode(this.mRequest.getRedirectUri()));
    }

    public String buildRefreshTokenRequestMessage(String refreshToken) throws UnsupportedEncodingException {
        Logger.v(TAG, "Building request message for redeeming token with refresh token.");
        String message = String.format("%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.urlFormEncode("refresh_token"), "refresh_token", StringExtensions.urlFormEncode(refreshToken), "client_id", StringExtensions.urlFormEncode(this.mRequest.getClientId()));
        if (!StringExtensions.isNullOrBlank(this.mRequest.getResource())) {
            message = String.format("%s&%s=%s", message, "resource", StringExtensions.urlFormEncode(this.mRequest.getResource()));
        }
        return message;
    }

    public static AuthenticationResult processUIResponseParams(Map<String, String> response) throws AuthenticationException {
        AuthenticationResult result;
        if (response.containsKey("error")) {
            String correlationInResponse = response.get("correlation_id");
            if (!StringExtensions.isNullOrBlank(correlationInResponse)) {
                try {
                    UUID correlationId = UUID.fromString(correlationInResponse);
                    Logger.setCorrelationId(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    Logger.e(TAG, "CorrelationId is malformed: " + correlationInResponse, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            Logger.v(TAG, "OAuth2 error:" + response.get("error") + " Description:" + response.get("error_description"));
            result = new AuthenticationResult(response.get("error"), response.get("error_description"), response.get("error_codes"));
        } else if (response.containsKey("code")) {
            result = new AuthenticationResult(response.get("code"));
        } else if (response.containsKey("access_token")) {
            boolean isMultiResourceToken = false;
            String expiresIn = response.get("expires_in");
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, expiresIn == null || expiresIn.isEmpty() ? 3600 : Integer.parseInt(expiresIn));
            String refreshToken = response.get("refresh_token");
            if (response.containsKey("resource") && !StringExtensions.isNullOrBlank(refreshToken)) {
                isMultiResourceToken = true;
            }
            UserInfo userinfo = null;
            String tenantId = null;
            String rawIdToken = null;
            if (response.containsKey("id_token")) {
                rawIdToken = response.get("id_token");
                if (!StringExtensions.isNullOrBlank(rawIdToken)) {
                    Logger.v(TAG, "Id token was returned, parsing id token.");
                    IdToken tokenParsed = new IdToken(rawIdToken);
                    tenantId = tokenParsed.getTenantId();
                    userinfo = new UserInfo(tokenParsed);
                } else {
                    Logger.v(TAG, "IdToken was not returned from token request.");
                }
            }
            String familyClientId = null;
            if (response.containsKey("foci")) {
                familyClientId = response.get("foci");
            }
            result = new AuthenticationResult(response.get("access_token"), refreshToken, expires.getTime(), isMultiResourceToken, userinfo, tenantId, rawIdToken, null);
            if (response.containsKey("ext_expires_in")) {
                String extendedExpiresIn = response.get("ext_expires_in");
                GregorianCalendar extendedExpires = new GregorianCalendar();
                ((Calendar)extendedExpires).add(13, StringExtensions.isNullOrBlank(extendedExpiresIn) ? 3600 : Integer.parseInt(extendedExpiresIn));
                result.setExtendedExpiresOn(extendedExpires.getTime());
            }
            result.setFamilyClientId(familyClientId);
        } else {
            result = null;
        }
        return result;
    }

    private static void extractJsonObjects(Map<String, String> responseItems, String jsonStr) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonStr);
        Iterator i = jsonObject.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            responseItems.put(key, jsonObject.getString(key));
        }
    }

    public AuthenticationResult refreshToken(String refreshToken) throws IOException, AuthenticationException {
        String requestMessage;
        if (this.mWebRequestHandler == null) {
            Logger.v(TAG, "Web request is not set correctly");
            throw new IllegalArgumentException("webRequestHandler is null.");
        }
        try {
            requestMessage = this.buildRefreshTokenRequestMessage(refreshToken);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, encoding.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        Map<String, String> headers = this.getRequestHeaders();
        headers.put("x-ms-PKeyAuth", "1.0");
        Logger.v(TAG, "Sending request to redeem token with refresh token.");
        return this.postMessage(requestMessage, headers);
    }

    public AuthenticationResult getToken(String authorizationUrl) throws IOException, AuthenticationException {
        if (StringExtensions.isNullOrBlank(authorizationUrl)) {
            throw new IllegalArgumentException("authorizationUrl");
        }
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(authorizationUrl);
        String encodedState = parameters.get("state");
        String state = Oauth2.decodeProtocolState(encodedState);
        if (!StringExtensions.isNullOrBlank(state)) {
            Uri stateUri = Uri.parse((String)("http://state/path?" + state));
            String authorizationUri = stateUri.getQueryParameter("a");
            String resource = stateUri.getQueryParameter("r");
            if (!StringExtensions.isNullOrBlank(authorizationUri) && !StringExtensions.isNullOrBlank(resource) && resource.equalsIgnoreCase(this.mRequest.getResource())) {
                AuthenticationResult result = Oauth2.processUIResponseParams(parameters);
                if (result != null && result.getCode() != null && !result.getCode().isEmpty()) {
                    return this.getTokenForCode(result.getCode());
                }
                return result;
            }
            throw new AuthenticationException(ADALError.AUTH_FAILED_BAD_STATE);
        }
        throw new AuthenticationException(ADALError.AUTH_FAILED_NO_STATE);
    }

    public AuthenticationResult getTokenForCode(String code) throws IOException, AuthenticationException {
        String requestMessage;
        if (this.mWebRequestHandler == null) {
            throw new IllegalArgumentException("webRequestHandler");
        }
        try {
            requestMessage = this.buildTokenRequestMessage(code);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, encoding.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        Map<String, String> headers = this.getRequestHeaders();
        Logger.v(TAG, "Sending request to redeem token with auth code.");
        return this.postMessage(requestMessage, headers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticationResult postMessage(String requestMessage, Map<String, String> headers) throws IOException, AuthenticationException {
        AuthenticationResult result;
        block21: {
            String errMessage;
            result = null;
            HttpEvent httpEvent = this.startHttpEvent();
            URL authority = StringExtensions.getUrl(this.getTokenEndpoint());
            if (authority == null) {
                this.stopHttpEvent(httpEvent);
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
            }
            httpEvent.setHttpPath(authority);
            try {
                boolean isBodyEmpty;
                this.mWebRequestHandler.setRequestCorrelationId(this.mRequest.getCorrelationId());
                ClientMetrics.INSTANCE.beginClientMetricsRecord(authority, this.mRequest.getCorrelationId(), headers);
                HttpWebResponse response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF_8"), "application/x-www-form-urlencoded");
                httpEvent.setResponseCode(response.getStatusCode());
                httpEvent.setCorrelationId(this.mRequest.getCorrelationId().toString());
                this.stopHttpEvent(httpEvent);
                if (response.getStatusCode() == 401) {
                    if (response.getResponseHeaders() != null && response.getResponseHeaders().containsKey("WWW-Authenticate")) {
                        String challengeHeader = response.getResponseHeaders().get("WWW-Authenticate").get(0);
                        Logger.v(TAG, "Device certificate challenge request:" + challengeHeader);
                        if (StringExtensions.isNullOrBlank(challengeHeader)) throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Challenge header is empty");
                        if (StringExtensions.hasPrefixInHeader(challengeHeader, "PKeyAuth")) {
                            HttpEvent challengeHttpEvent = this.startHttpEvent();
                            challengeHttpEvent.setHttpPath(authority);
                            Logger.v(TAG, "Received pkeyAuth device challenge.");
                            ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(this.mJWSBuilder);
                            Logger.v(TAG, "Processing device challenge");
                            ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromHeader(challengeHeader, authority.toString());
                            headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
                            Logger.v(TAG, "Sending request with challenge response");
                            response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF_8"), "application/x-www-form-urlencoded");
                            challengeHttpEvent.setResponseCode(response.getStatusCode());
                            challengeHttpEvent.setCorrelationId(this.mRequest.getCorrelationId().toString());
                            this.stopHttpEvent(challengeHttpEvent);
                        }
                    } else {
                        Logger.v(TAG, "401 http status code is returned without authorization header");
                    }
                }
                if (!(isBodyEmpty = TextUtils.isEmpty((CharSequence)response.getBody()))) {
                    Logger.v(TAG, "Token request does not have exception");
                    try {
                        result = this.processTokenResponse(response, httpEvent);
                    }
                    catch (ServerRespondingWithRetryableException e) {
                        result = this.retry(requestMessage, headers);
                        if (result != null) {
                            AuthenticationResult authenticationResult = result;
                            ClientMetrics.INSTANCE.endClientMetricsRecord("token", this.mRequest.getCorrelationId());
                            return authenticationResult;
                        }
                        if (this.mRequest.getIsExtendedLifetimeEnabled()) {
                            Logger.v(TAG, "WebResponse is not a success due to: " + response.getStatusCode());
                            throw e;
                        }
                        Logger.v(TAG, "WebResponse is not a success due to: " + response.getStatusCode());
                        throw new AuthenticationException(ADALError.SERVER_ERROR, "WebResponse is not a success due to: " + response.getStatusCode());
                    }
                    ClientMetrics.INSTANCE.setLastError(null);
                }
                if (result != null) break block21;
                errMessage = isBodyEmpty ? "Status code:" + response.getStatusCode() : response.getBody();
            }
            catch (UnsupportedEncodingException e) {
                ClientMetrics.INSTANCE.setLastError(null);
                Logger.e(TAG, e.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
                throw e;
            }
            catch (SocketTimeoutException e) {
                result = this.retry(requestMessage, headers);
                if (result != null) {
                    AuthenticationResult authenticationResult = result;
                    return authenticationResult;
                }
                ClientMetrics.INSTANCE.setLastError(null);
                if (this.mRequest.getIsExtendedLifetimeEnabled()) {
                    Logger.e(TAG, e.getMessage(), "", ADALError.SERVER_ERROR, e);
                    throw new ServerRespondingWithRetryableException(e.getMessage(), e);
                }
                Logger.e(TAG, e.getMessage(), "", ADALError.SERVER_ERROR, e);
                throw e;
            }
            catch (IOException e) {
                ClientMetrics.INSTANCE.setLastError(null);
                Logger.e(TAG, e.getMessage(), "", ADALError.SERVER_ERROR, e);
                throw e;
            }
            finally {
                ClientMetrics.INSTANCE.endClientMetricsRecord("token", this.mRequest.getCorrelationId());
            }
            Logger.e(TAG, "Server error message", errMessage, ADALError.SERVER_ERROR);
            throw new AuthenticationException(ADALError.SERVER_ERROR, errMessage);
        }
        ClientMetrics.INSTANCE.setLastErrorCodes(result.getErrorCodes());
        return result;
    }

    private AuthenticationResult retry(String requestMessage, Map<String, String> headers) throws IOException, AuthenticationException {
        if (this.mRetryOnce) {
            this.mRetryOnce = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                Logger.v(TAG, "The thread is interrupted while it is sleeping. " + exception);
            }
            Logger.v(TAG, "Try again...");
            return this.postMessage(requestMessage, headers);
        }
        return null;
    }

    public static String decodeProtocolState(String encodedState) throws UnsupportedEncodingException {
        if (!StringExtensions.isNullOrBlank(encodedState)) {
            byte[] stateBytes = Base64.decode((String)encodedState, (int)9);
            return new String(stateBytes, "UTF-8");
        }
        return null;
    }

    public String encodeProtocolState() throws UnsupportedEncodingException {
        String state = String.format("a=%s&r=%s", this.mRequest.getAuthority(), this.mRequest.getResource());
        return Base64.encodeToString((byte[])state.getBytes("UTF-8"), (int)9);
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return headers;
    }

    private AuthenticationResult processTokenResponse(HttpWebResponse webResponse, HttpEvent httpEvent) throws AuthenticationException {
        AuthenticationResult result;
        String correlationIdInHeader = null;
        if (webResponse.getResponseHeaders() != null) {
            List<String> listOfHeaders;
            if (webResponse.getResponseHeaders().containsKey("client-request-id") && (listOfHeaders = webResponse.getResponseHeaders().get("client-request-id")) != null && listOfHeaders.size() > 0) {
                correlationIdInHeader = listOfHeaders.get(0);
            }
            if (webResponse.getResponseHeaders().containsKey("x-ms-request-id") && (listOfHeaders = webResponse.getResponseHeaders().get("x-ms-request-id")) != null && listOfHeaders.size() > 0) {
                Logger.v(TAG, "x-ms-request-id: " + listOfHeaders.get(0));
                httpEvent.setRequestIdHeader(listOfHeaders.get(0));
            }
        }
        int statusCode = webResponse.getStatusCode();
        switch (statusCode) {
            case 200: 
            case 400: 
            case 401: {
                try {
                    result = this.parseJsonResponse(webResponse.getBody());
                    if (result == null) break;
                    httpEvent.setOauthErrorCode(result.getErrorCode());
                    break;
                }
                catch (JSONException jsonException) {
                    throw new AuthenticationException(ADALError.SERVER_INVALID_JSON_RESPONSE, "Can't parse server response " + webResponse.getBody(), jsonException);
                }
            }
            case 500: 
            case 503: 
            case 504: {
                throw new ServerRespondingWithRetryableException("Unexpected server response " + webResponse.getBody());
            }
            default: {
                throw new AuthenticationException(ADALError.SERVER_ERROR, "Unexpected server response " + webResponse.getBody());
            }
        }
        if (correlationIdInHeader != null && !correlationIdInHeader.isEmpty()) {
            try {
                UUID correlation = UUID.fromString(correlationIdInHeader);
                if (!correlation.equals(this.mRequest.getCorrelationId())) {
                    Logger.w(TAG, "CorrelationId is not matching", "", ADALError.CORRELATION_ID_NOT_MATCHING_REQUEST_RESPONSE);
                }
                Logger.v(TAG, "Response correlationId:" + correlationIdInHeader);
            }
            catch (IllegalArgumentException ex) {
                Logger.e(TAG, "Wrong format of the correlation ID:" + correlationIdInHeader, "", ADALError.CORRELATION_ID_FORMAT, ex);
            }
        }
        return result;
    }

    private AuthenticationResult parseJsonResponse(String responseBody) throws JSONException, AuthenticationException {
        HashMap<String, String> responseItems = new HashMap<String, String>();
        Oauth2.extractJsonObjects(responseItems, responseBody);
        return Oauth2.processUIResponseParams(responseItems);
    }

    private HttpEvent startHttpEvent() {
        HttpEvent httpEvent = new HttpEvent("Microsoft.ADAL.http_event");
        httpEvent.setRequestId(this.mRequest.getTelemetryRequestId());
        httpEvent.setMethod("Microsoft.ADAL.post");
        Telemetry.getInstance().startEvent(this.mRequest.getTelemetryRequestId(), "Microsoft.ADAL.http_event");
        return httpEvent;
    }

    private void stopHttpEvent(HttpEvent httpEvent) {
        Telemetry.getInstance().stopEvent(this.mRequest.getTelemetryRequestId(), httpEvent, "Microsoft.ADAL.http_event");
    }
}

