/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Handler;
import android.os.Looper;
import com.microsoft.aad.adal.Callback;
import com.microsoft.aad.adal.Logger;
import java.util.concurrent.atomic.AtomicReference;

final class CallbackExecutor<T> {
    private static final String TAG = CallbackExecutor.class.getSimpleName();
    private final AtomicReference<Callback<T>> mCallbackReference = new AtomicReference<Object>(null);
    private final Handler mHandler = Looper.myLooper() == null ? null : new Handler();

    CallbackExecutor(Callback<T> callback) {
        this.mCallbackReference.set(callback);
    }

    public void onSuccess(final T result) {
        final Callback callback = this.mCallbackReference.getAndSet(null);
        if (callback == null) {
            Logger.v(TAG, "Callback does not exist.");
            return;
        }
        if (this.mHandler == null) {
            callback.onSuccess(result);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(result);
                }
            });
        }
    }

    public void onError(final Throwable throwable) {
        final Callback callback = this.mCallbackReference.getAndSet(null);
        if (callback == null) {
            Logger.v(TAG, "Callback does not exist.");
            return;
        }
        if (this.mHandler == null) {
            callback.onError(throwable);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onError(throwable);
                }
            });
        }
    }
}

