/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TelemetryUtils {
    private static final String TAG = TelemetryUtils.class.getSimpleName();

    private TelemetryUtils() {
    }

    static CliTelemInfo parseXMsCliTelemHeader(String headerValue) {
        if (StringExtensions.isNullOrBlank(headerValue)) {
            return null;
        }
        String[] headerSegments = headerValue.split(",");
        if (0 == headerSegments.length) {
            Logger.w(TAG, "SPE Ring header missing version field.", null, ADALError.X_MS_CLITELEM_VERSION_UNRECOGNIZED);
            return null;
        }
        String headerVersion = headerSegments[0];
        CliTelemInfo cliTelemInfo = new CliTelemInfo();
        cliTelemInfo.setVersion(headerVersion);
        if (headerVersion.equals("1")) {
            int delimCount = 4;
            Pattern headerFmt = Pattern.compile("^[1-9]+\\.?[0-9|\\.]*,[0-9|\\.]*,[0-9|\\.]*,[^,]*[0-9\\.]*,[^,]*$");
            Matcher matcher = headerFmt.matcher(headerValue);
            if (!matcher.matches()) {
                Logger.w(TAG, "", "", ADALError.X_MS_CLITELEM_MALFORMED);
                return null;
            }
        } else {
            Logger.w(TAG, "Unexpected header version: " + headerVersion, null, ADALError.X_MS_CLITELEM_VERSION_UNRECOGNIZED);
            return null;
        }
        headerSegments = headerValue.split(",", 5);
        boolean indexErrorCode = true;
        int indexSubErrorCode = 2;
        int indexTokenAge = 3;
        int indexSpeInfo = 4;
        cliTelemInfo.setServerErrorCode(headerSegments[1]);
        cliTelemInfo.setServerSubErrorCode(headerSegments[2]);
        cliTelemInfo.setRefreshTokenAge(headerSegments[3]);
        cliTelemInfo.setSpeRing(headerSegments[4]);
        return cliTelemInfo;
    }

    static class CliTelemInfo
    implements Serializable {
        private String mVersion;
        private String mServerErrorCode;
        private String mServerSubErrorCode;
        private String mRefreshTokenAge;
        private String mSpeRing;

        CliTelemInfo() {
        }

        String getVersion() {
            return this.mVersion;
        }

        void setVersion(String mVersion) {
            this.mVersion = mVersion;
        }

        String getServerErrorCode() {
            return this.mServerErrorCode;
        }

        void setServerErrorCode(String mServerErrorCode) {
            this.mServerErrorCode = mServerErrorCode;
        }

        String getServerSubErrorCode() {
            return this.mServerSubErrorCode;
        }

        void setServerSubErrorCode(String mServerSubErrorCode) {
            this.mServerSubErrorCode = mServerSubErrorCode;
        }

        String getRefreshTokenAge() {
            return this.mRefreshTokenAge;
        }

        void setRefreshTokenAge(String mRefreshTokenAge) {
            this.mRefreshTokenAge = mRefreshTokenAge;
        }

        String getSpeRing() {
            return this.mSpeRing;
        }

        void setSpeRing(String mSpeRing) {
            this.mSpeRing = mSpeRing;
        }
    }
}

