/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthorityValidationMetadataCache;
import com.microsoft.aad.adal.CacheEvent;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenEntryType;
import com.microsoft.aad.adal.Utility;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TokenCacheAccessor {
    private static final String TAG = TokenCacheAccessor.class.getSimpleName();
    private final ITokenCacheStore mTokenCacheStore;
    private String mAuthority;
    private final String mTelemetryRequestId;

    TokenCacheAccessor(ITokenCacheStore tokenCacheStore, String authority, String telemetryRequestId) {
        if (tokenCacheStore == null) {
            throw new IllegalArgumentException("tokenCacheStore");
        }
        if (StringExtensions.isNullOrBlank(authority)) {
            throw new IllegalArgumentException("authority");
        }
        if (StringExtensions.isNullOrBlank(telemetryRequestId)) {
            throw new IllegalArgumentException("requestId");
        }
        this.mTokenCacheStore = tokenCacheStore;
        this.mAuthority = authority;
        this.mTelemetryRequestId = telemetryRequestId;
    }

    TokenCacheItem getATFromCache(String resource, String clientId, String user) throws AuthenticationException {
        TokenCacheItem accessTokenItem;
        try {
            accessTokenItem = this.getRegularRefreshTokenCacheItem(resource, clientId, user);
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (accessTokenItem == null) {
            Logger.v(TAG, "No access token exists.");
            return null;
        }
        this.throwIfMultipleATExisted(clientId, resource, user);
        if (!StringExtensions.isNullOrBlank(accessTokenItem.getAccessToken())) {
            if (TokenCacheItem.isTokenExpired(accessTokenItem.getExpiresOn())) {
                Logger.v(TAG, "Access token exists, but already expired.");
                return null;
            }
            if (this.isUserMisMatch(user, accessTokenItem)) {
                throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
            }
        }
        return accessTokenItem;
    }

    TokenCacheItem getRegularRefreshTokenCacheItem(String resource, String clientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.rt");
        String cacheKey = CacheKey.createCacheKeyForRTEntry(this.getAuthorityUrlWithPreferredCache(), resource, clientId, user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(resource, clientId, null, user, TokenEntryType.REGULAR_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeRT(true);
            cacheEvent.setSpeRing(item.getSpeRing());
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getMRRTItem(String clientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.mrrt");
        String cacheKey = CacheKey.createCacheKeyForMRRT(this.getAuthorityUrlWithPreferredCache(), clientId, user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(null, clientId, null, user, TokenEntryType.MRRT_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeMRRT(true);
            cacheEvent.setTokenTypeFRT(item.isFamilyToken());
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getFRTItem(String familyClientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.frt");
        if (StringExtensions.isNullOrBlank(user)) {
            Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
            return null;
        }
        String cacheKey = CacheKey.createCacheKeyForFRT(this.getAuthorityUrlWithPreferredCache(), familyClientId, user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(null, null, familyClientId, user, TokenEntryType.FRT_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeFRT(true);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getStaleToken(AuthenticationRequest authRequest) throws AuthenticationException {
        TokenCacheItem accessTokenItem;
        try {
            accessTokenItem = this.getRegularRefreshTokenCacheItem(authRequest.getResource(), authRequest.getClientId(), authRequest.getUserFromRequest());
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (accessTokenItem != null && !StringExtensions.isNullOrBlank(accessTokenItem.getAccessToken()) && accessTokenItem.getExtendedExpiresOn() != null && !TokenCacheItem.isTokenExpired(accessTokenItem.getExtendedExpiresOn())) {
            this.throwIfMultipleATExisted(authRequest.getClientId(), authRequest.getResource(), authRequest.getUserFromRequest());
            Logger.i(TAG, "The stale access token is returned.", "");
            return accessTokenItem;
        }
        Logger.i(TAG, "The stale access token is not found.", "");
        return null;
    }

    void updateCachedItemWithResult(String resource, String clientId, AuthenticationResult result, TokenCacheItem cachedItem) throws AuthenticationException {
        if (result == null) {
            Logger.v(TAG, "AuthenticationResult is null, cannot update cache.");
            throw new IllegalArgumentException("result");
        }
        if (result.getStatus() == AuthenticationResult.AuthenticationStatus.Succeeded) {
            Logger.v(TAG, "Save returned AuthenticationResult into cache.");
            if (cachedItem != null && cachedItem.getUserInfo() != null && result.getUserInfo() == null) {
                result.setUserInfo(cachedItem.getUserInfo());
                result.setIdToken(cachedItem.getRawIdToken());
                result.setTenantId(cachedItem.getTenantId());
            }
            try {
                this.updateTokenCache(resource, clientId, result);
            }
            catch (MalformedURLException e) {
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e.getMessage(), e);
            }
        } else if ("invalid_grant".equalsIgnoreCase(result.getErrorCode())) {
            Logger.v(TAG, "Received INVALID_GRANT error code, remove existing cache entry.");
            this.removeTokenCacheItem(cachedItem, resource);
        }
    }

    void updateTokenCache(String resource, String clientId, AuthenticationResult result) throws MalformedURLException {
        if (result == null || StringExtensions.isNullOrBlank(result.getAccessToken())) {
            return;
        }
        if (result.getUserInfo() != null) {
            if (!StringExtensions.isNullOrBlank(result.getUserInfo().getDisplayableId())) {
                this.setItemToCacheForUser(resource, clientId, result, result.getUserInfo().getDisplayableId());
            }
            if (!StringExtensions.isNullOrBlank(result.getUserInfo().getUserId())) {
                this.setItemToCacheForUser(resource, clientId, result, result.getUserInfo().getUserId());
            }
        }
        this.setItemToCacheForUser(resource, clientId, result, null);
    }

    void removeTokenCacheItem(TokenCacheItem tokenCacheItem, String resource) throws AuthenticationException {
        List<String> keys;
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_delete");
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_delete");
        TokenEntryType tokenEntryType = tokenCacheItem.getTokenEntryType();
        switch (tokenEntryType) {
            case REGULAR_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeRT(true);
                Logger.v(TAG, "Regular RT was used to get access token, remove entries for regular RT entries.");
                keys = this.getKeyListToRemoveForRT(tokenCacheItem);
                break;
            }
            case MRRT_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeMRRT(true);
                Logger.v(TAG, "MRRT was used to get access token, remove entries for both MRRT entries and regular RT entries.");
                keys = this.getKeyListToRemoveForMRRT(tokenCacheItem);
                TokenCacheItem regularRTItem = new TokenCacheItem(tokenCacheItem);
                regularRTItem.setResource(resource);
                keys.addAll(this.getKeyListToRemoveForRT(regularRTItem));
                break;
            }
            case FRT_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeFRT(true);
                Logger.v(TAG, "FRT was used to get access token, remove entries for FRT entries.");
                keys = this.getKeyListToRemoveForFRT(tokenCacheItem);
                break;
            }
            default: {
                throw new AuthenticationException(ADALError.INVALID_TOKEN_CACHE_ITEM);
            }
        }
        for (String key : keys) {
            this.mTokenCacheStore.removeItem(key);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_delete");
    }

    boolean isMultipleRTsMatchingGivenAppAndResource(String clientId, String resource) {
        Iterator<TokenCacheItem> allItems = this.mTokenCacheStore.getAll();
        ArrayList<TokenCacheItem> regularRTsMatchingRequest = new ArrayList<TokenCacheItem>();
        while (allItems.hasNext()) {
            TokenCacheItem tokenCacheItem = allItems.next();
            if (!tokenCacheItem.getAuthority().equalsIgnoreCase(this.mAuthority) || !clientId.equalsIgnoreCase(tokenCacheItem.getClientId()) || !resource.equalsIgnoreCase(tokenCacheItem.getResource()) || tokenCacheItem.getIsMultiResourceRefreshToken()) continue;
            regularRTsMatchingRequest.add(tokenCacheItem);
        }
        return regularRTsMatchingRequest.size() > 1;
    }

    boolean isMultipleMRRTsMatchingGivenApp(String clientId) {
        Iterator<TokenCacheItem> allItems = this.mTokenCacheStore.getAll();
        ArrayList<TokenCacheItem> mrrtsMatchingRequest = new ArrayList<TokenCacheItem>();
        while (allItems.hasNext()) {
            TokenCacheItem tokenCacheItem = allItems.next();
            if (!tokenCacheItem.getAuthority().equalsIgnoreCase(this.mAuthority) || !tokenCacheItem.getClientId().equalsIgnoreCase(clientId) || !tokenCacheItem.getIsMultiResourceRefreshToken() && !StringExtensions.isNullOrBlank(tokenCacheItem.getResource())) continue;
            mrrtsMatchingRequest.add(tokenCacheItem);
        }
        return mrrtsMatchingRequest.size() > 1;
    }

    private void setItemToCacheForUser(String resource, String clientId, AuthenticationResult result, String userId) throws MalformedURLException {
        this.logReturnedToken(result);
        Logger.v(TAG, "Save regular token into cache.");
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_write");
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_write");
        this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForRTEntry(this.getAuthorityUrlWithPreferredCache(), resource, clientId, userId), TokenCacheItem.createRegularTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), resource, clientId, result));
        cacheEvent.setTokenTypeRT(true);
        if (result.getIsMultiResourceRefreshToken()) {
            Logger.v(TAG, "Save Multi Resource Refresh token to cache");
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForMRRT(this.getAuthorityUrlWithPreferredCache(), clientId, userId), TokenCacheItem.createMRRTTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), clientId, result));
            cacheEvent.setTokenTypeMRRT(true);
        }
        if (!StringExtensions.isNullOrBlank(result.getFamilyClientId()) && !StringExtensions.isNullOrBlank(userId)) {
            Logger.v(TAG, "Save Family Refresh token into cache");
            TokenCacheItem familyTokenCacheItem = TokenCacheItem.createFRRTTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), result);
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForFRT(this.getAuthorityUrlWithPreferredCache(), result.getFamilyClientId(), userId), familyTokenCacheItem);
            cacheEvent.setTokenTypeFRT(true);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_write");
    }

    private List<String> getKeyListToRemoveForRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), null));
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private List<String> getKeyListToRemoveForMRRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), null));
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private List<String> getKeyListToRemoveForFRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForFRT(this.mAuthority, cachedItem.getFamilyClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForFRT(this.mAuthority, cachedItem.getFamilyClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private boolean isUserMisMatch(String user, TokenCacheItem tokenCacheItem) {
        if (StringExtensions.isNullOrBlank(user) || tokenCacheItem.getUserInfo() == null) {
            return false;
        }
        return !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getDisplayableId()) && !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getUserId());
    }

    private void throwIfMultipleATExisted(String clientId, String resource, String user) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank(user) && this.isMultipleRTsMatchingGivenAppAndResource(clientId, resource)) {
            throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH, "No user is provided and multiple access tokens exist for the given app and resource.");
        }
    }

    private void logReturnedToken(AuthenticationResult result) {
        if (result != null && result.getAccessToken() != null) {
            String accessTokenHash = this.getTokenHash(result.getAccessToken());
            String refreshTokenHash = this.getTokenHash(result.getRefreshToken());
            Logger.v(TAG, String.format("Access TokenID %s and Refresh TokenID %s returned.", accessTokenHash, refreshTokenHash));
        }
    }

    private String getTokenHash(String token) {
        try {
            return StringExtensions.createHash(token);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest error", "", ADALError.DEVICE_NO_SUCH_ALGORITHM, e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Digest error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
        }
        return "";
    }

    private CacheEvent startCacheTelemetryRequest(String tokenType) {
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_lookup");
        cacheEvent.setTokenType(tokenType);
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_lookup");
        return cacheEvent;
    }

    private TokenCacheItem performAdditionalCacheLookup(String resource, String clientid, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        TokenCacheItem item = this.getTokenCacheItemFromPassedInAuthority(resource, clientid, familyClientId, user, type);
        if (item == null) {
            item = this.getTokenCacheItemFromAliasedHost(resource, clientid, familyClientId, user, type);
        }
        return item;
    }

    private TokenCacheItem getTokenCacheItemFromPassedInAuthority(String resource, String clientId, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        if (this.getAuthorityUrlWithPreferredCache().equalsIgnoreCase(this.mAuthority)) {
            return null;
        }
        String cacheKeyWithPassedInAuthority = this.getCacheKey(this.mAuthority, resource, clientId, user, familyClientId, type);
        return this.mTokenCacheStore.getItem(cacheKeyWithPassedInAuthority);
    }

    private TokenCacheItem getTokenCacheItemFromAliasedHost(String resource, String clientId, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        InstanceDiscoveryMetadata instanceDiscoveryMetadata = this.getInstanceDiscoveryMetadata();
        if (instanceDiscoveryMetadata == null) {
            return null;
        }
        TokenCacheItem tokenCacheItemForAliasedHost = null;
        List<String> aliasHosts = instanceDiscoveryMetadata.getAliases();
        for (String aliasHost : aliasHosts) {
            String cacheKeyForAliasedHost;
            TokenCacheItem item;
            String authority = this.constructAuthorityUrl(aliasHost);
            if (authority.equalsIgnoreCase(this.mAuthority) || authority.equalsIgnoreCase(this.getAuthorityUrlWithPreferredCache()) || (item = this.mTokenCacheStore.getItem(cacheKeyForAliasedHost = this.getCacheKey(authority, resource, clientId, user, familyClientId, type))) == null) continue;
            tokenCacheItemForAliasedHost = item;
            break;
        }
        return tokenCacheItemForAliasedHost;
    }

    private String getCacheKey(String authority, String resource, String clientId, String user, String familyClientId, TokenEntryType type) {
        String cacheKey;
        switch (type) {
            case REGULAR_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForRTEntry(authority, resource, clientId, user);
                break;
            }
            case MRRT_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForMRRT(authority, clientId, user);
                break;
            }
            case FRT_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForFRT(authority, familyClientId, user);
                break;
            }
            default: {
                return null;
            }
        }
        return cacheKey;
    }

    String getAuthorityUrlWithPreferredCache() throws MalformedURLException {
        InstanceDiscoveryMetadata instanceDiscoveryMetadata = this.getInstanceDiscoveryMetadata();
        if (instanceDiscoveryMetadata == null || !instanceDiscoveryMetadata.isValidated()) {
            return this.mAuthority;
        }
        String preferredLocation = instanceDiscoveryMetadata.getPreferredCache();
        return this.constructAuthorityUrl(preferredLocation);
    }

    private String constructAuthorityUrl(String host) throws MalformedURLException {
        URL passedInAuthority = new URL(this.mAuthority);
        if (passedInAuthority.getHost().equalsIgnoreCase(host)) {
            return this.mAuthority;
        }
        return Utility.constructAuthorityUrl(passedInAuthority, host).toString();
    }

    private InstanceDiscoveryMetadata getInstanceDiscoveryMetadata() throws MalformedURLException {
        URL passedInAuthority = new URL(this.mAuthority);
        return AuthorityValidationMetadataCache.getCachedInstanceDiscoveryMetadata(passedInAuthority);
    }
}

