/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Build;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;

final class PRNGFixes {
    private static final int VERSION_CODE_JELLY_BEAN = 16;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL = PRNGFixes.getBuildFingerprintAndDeviceSerial();
    private static final int ONE_KB = 1024;
    private static final String TAG = "PRNGFixes";

    private PRNGFixes() {
    }

    public static void apply() {
        PRNGFixes.applyOpenSSLFix();
        PRNGFixes.installLinuxPRNGSecureRandom();
    }

    private static void applyOpenSSLFix() throws SecurityException {
        String methodName = ":applyOpenSSLFix";
        if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
            Logger.v("PRNGFixes:applyOpenSSLFix", "No need to apply the OpenSSL fix.");
            return;
        }
        try {
            Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, new Object[]{PRNGFixes.generateSeed()});
            int bytesRead = (Integer)Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, "/dev/urandom", 1024);
            if (bytesRead != 1024) {
                throw new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.e("PRNGFixes:applyOpenSSLFix", "Failed to seed OpenSSL PRNG. ", "", ADALError.DEVICE_PRNG_FIX_ERROR, e);
            throw new SecurityException("Failed to seed OpenSSL PRNG", e);
        }
    }

    private static void installLinuxPRNGSecureRandom() throws SecurityException {
        String methodName = ":installLinuxPRNGSecureRandom";
        if (Build.VERSION.SDK_INT > 18) {
            Logger.v("PRNGFixes:installLinuxPRNGSecureRandom", "No need to apply the fix.");
            return;
        }
        Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
        if (secureRandomProviders == null || secureRandomProviders.length < 1 || !LinuxPRNGSecureRandomProvider.class.equals(secureRandomProviders[0].getClass())) {
            Logger.v("PRNGFixes:installLinuxPRNGSecureRandom", "Insert provider as LinuxPRNGSecureRandomProvider.");
            Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
        }
        SecureRandom rng1 = new SecureRandom();
        Logger.i("PRNGFixes:installLinuxPRNGSecureRandom", "LinuxPRNGSecureRandomProvider for SecureRandom. ", "Provider: " + rng1.getProvider().getClass().getName());
        try {
            SecureRandom rng2 = SecureRandom.getInstance("SHA1PRNG");
            Logger.i("PRNGFixes:installLinuxPRNGSecureRandom", "LinuxPRNGSecureRandomProvider for SecureRandom with alg SHA1PRNG. ", "Provider: " + rng2.getProvider().getClass().getName());
        }
        catch (NoSuchAlgorithmException e) {
            Logger.v("PRNGFixes:installLinuxPRNGSecureRandom", "SHA1PRNG not available.");
            throw new SecurityException("SHA1PRNG not available", e);
        }
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
            seedBufferOut.close();
            return seedBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    private static String getDeviceSerialNumber() {
        try {
            return (String)Build.class.getField("SERIAL").get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static byte[] getBuildFingerprintAndDeviceSerial() {
        String serial;
        StringBuilder result = new StringBuilder();
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint != null) {
            result.append(fingerprint);
        }
        if ((serial = PRNGFixes.getDeviceSerialNumber()) != null) {
            result.append(serial);
        }
        try {
            return result.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
    }

    public static class LinuxPRNGSecureRandom
    extends SecureRandomSpi {
        private static final long serialVersionUID = 1L;
        private static final File URANDOM_FILE = new File("/dev/urandom");
        private static final Object SLOCK = new Object();
        private static DataInputStream sUrandomIn;
        private static OutputStream sUrandomOut;
        private boolean mSeeded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] bytes) {
            OutputStream out = null;
            try {
                out = this.getUrandomOutputStream();
                out.write(bytes);
                out.flush();
            }
            catch (IOException e) {
                Logger.w(PRNGFixes.class.getSimpleName(), "Failed to mix seed into " + URANDOM_FILE);
            }
            finally {
                this.mSeeded = true;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Logger.v("PRNGFixesengineSetSeed", "Failed to close the output stream to \"/dev/urandom\" . Exception: " + e.toString());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes) {
            if (!this.mSeeded) {
                this.engineSetSeed(PRNGFixes.generateSeed());
            }
            DataInputStream in = null;
            try {
                in = this.getUrandomInputStream();
                Object object = SLOCK;
                synchronized (object) {
                    in.readFully(bytes);
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Logger.v("PRNGFixesengineNextBytes", "Failed to close the input stream to \"/dev/urandom\" . Exception: " + e.toString());
                    }
                }
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int size) {
            byte[] seed = new byte[size];
            this.engineNextBytes(seed);
            return seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataInputStream getUrandomInputStream() {
            Object object = SLOCK;
            synchronized (object) {
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                    }
                }
                return sUrandomIn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream getUrandomOutputStream() throws IOException {
            Object object = SLOCK;
            synchronized (object) {
                if (sUrandomOut == null) {
                    sUrandomOut = new FileOutputStream(URANDOM_FILE);
                }
                return sUrandomOut;
            }
        }
    }

    private static class LinuxPRNGSecureRandomProvider
    extends Provider {
        private static final long serialVersionUID = 1L;

        public LinuxPRNGSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }
}

