/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class PackageHelper {
    private static final String TAG = "CallerInfo";
    private Context mContext;
    private final AccountManager mAcctManager;

    public PackageHelper(Context ctx) {
        this.mContext = ctx;
        this.mAcctManager = AccountManager.get((Context)this.mContext);
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public String getCurrentSignatureForPackage(String packagename) {
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(packagename, 64);
            if (info != null && info.signatures != null && info.signatures.length > 0) {
                Signature signature = info.signatures[0];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Calling App's package does not exist in PackageManager. ", "", ADALError.APP_PACKAGE_NAME_NOT_FOUND);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest SHA algorithm does not exists. ", "", ADALError.DEVICE_NO_SUCH_ALGORITHM);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Package is not found. ", "Package name: " + packageName, ADALError.PACKAGE_NAME_NOT_FOUND, e);
        }
        return callingUID;
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        if (!StringExtensions.isNullOrBlank(packageName) && !StringExtensions.isNullOrBlank(signatureDigest)) {
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF_8"), URLEncoder.encode(signatureDigest, "UTF_8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.e(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            }
        }
        return "";
    }
}

