/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.StringExtensions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

final class Utility {
    private Utility() {
    }

    static Date getImmutableDateObject(Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return date;
    }

    static boolean isClaimsChallengePresent(AuthenticationRequest request) {
        return !StringExtensions.isNullOrBlank(request.getClaimsChallenge());
    }

    static URL constructAuthorityUrl(URL originalAuthority, String host) throws MalformedURLException {
        String path = originalAuthority.getPath().replaceFirst("/", "");
        Uri.Builder builder = new Uri.Builder().scheme(originalAuthority.getProtocol()).authority(host).appendPath(path);
        return new URL(builder.build().toString());
    }
}

