/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import com.microsoft.aad.adal.IEvents;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TelemetryUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class DefaultEvent
implements IEvents {
    private final List<Pair<String, String>> mEventList = new ArrayList<Pair<String, String>>(sEventListSize);
    private static String sApplicationName = null;
    private static String sApplicationVersion = "NA";
    private static String sClientId = "NA";
    private static String sDeviceId = "NA";
    private static int sEventListSize = 30;
    private String mRequestId;
    private int mDefaultEventCount;

    DefaultEvent() {
        if (sApplicationName != null) {
            this.setProperty("Microsoft.ADAL.application_name", sApplicationName);
            this.setProperty("Microsoft.ADAL.application_version", sApplicationVersion);
            this.setProperty("Microsoft.ADAL.client_id", sClientId);
            this.setProperty("Microsoft.ADAL.device_id", sDeviceId);
            this.mDefaultEventCount = this.mEventList.size();
        }
    }

    @Override
    public int getDefaultEventCount() {
        return this.mDefaultEventCount;
    }

    @Override
    public void setProperty(String name, String value) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Telemetry setProperty on null name");
        }
        if (value == null || !DefaultEvent.isPrivacyCompliant(name)) {
            return;
        }
        this.mEventList.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
    }

    @Override
    public List<Pair<String, String>> getEvents() {
        return Collections.unmodifiableList(this.mEventList);
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        if (sApplicationName != null && DefaultEvent.isPrivacyCompliant("Microsoft.ADAL.application_name")) {
            dispatchMap.put("Microsoft.ADAL.application_name", sApplicationName);
        }
        if (sApplicationVersion != null && DefaultEvent.isPrivacyCompliant("Microsoft.ADAL.application_version")) {
            dispatchMap.put("Microsoft.ADAL.application_version", sApplicationVersion);
        }
        if (sClientId != null && DefaultEvent.isPrivacyCompliant("Microsoft.ADAL.client_id")) {
            dispatchMap.put("Microsoft.ADAL.client_id", sClientId);
        }
        if (sDeviceId != null && DefaultEvent.isPrivacyCompliant("Microsoft.ADAL.device_id")) {
            dispatchMap.put("Microsoft.ADAL.device_id", sDeviceId);
        }
    }

    @SuppressLint(value={"HardwareIds"})
    void setDefaults(Context context, String clientId) {
        sClientId = clientId;
        sApplicationName = context.getPackageName();
        try {
            sApplicationVersion = context.getPackageManager().getPackageInfo((String)DefaultEvent.sApplicationName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            sApplicationVersion = "NA";
        }
        try {
            sDeviceId = StringExtensions.createHash(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            sDeviceId = "";
        }
        if (this.mDefaultEventCount == 0) {
            this.setProperty("Microsoft.ADAL.application_name", sApplicationName);
            this.setProperty("Microsoft.ADAL.application_version", sApplicationVersion);
            this.setProperty("Microsoft.ADAL.client_id", sClientId);
            this.setProperty("Microsoft.ADAL.device_id", sDeviceId);
            this.mDefaultEventCount = this.mEventList.size();
        }
    }

    void setCorrelationId(String correlationId) {
        this.mEventList.add(0, (Pair<String, String>)new Pair((Object)"Microsoft.ADAL.correlation_id", (Object)correlationId));
        ++this.mDefaultEventCount;
    }

    void setRequestId(String requestId) {
        this.mRequestId = requestId;
        this.mEventList.add(0, (Pair<String, String>)new Pair((Object)"Microsoft.ADAL.request_id", (Object)requestId));
        ++this.mDefaultEventCount;
    }

    List<Pair<String, String>> getEventList() {
        return this.mEventList;
    }

    String getTelemetryRequestId() {
        return this.mRequestId;
    }

    static boolean isPrivacyCompliant(String fieldName) {
        return Telemetry.getAllowPii() || !TelemetryUtils.GDPR_FILTERED_FIELDS.contains(fieldName);
    }
}

