/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.HashMapExtensions;
import com.microsoft.aad.adal.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

final class StringExtensions {
    public static final String ENCODING_UTF8 = "UTF_8";
    private static final String TAG = StringExtensions.class.getSimpleName();
    private static final String TOKEN_HASH_ALGORITHM = "SHA256";

    private StringExtensions() {
    }

    static boolean isNullOrBlank(String param) {
        return param == null || param.trim().length() == 0;
    }

    public static String createHash(String msg) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringExtensions.isNullOrBlank(msg)) {
            MessageDigest digester = MessageDigest.getInstance(TOKEN_HASH_ALGORITHM);
            byte[] msgInBytes = msg.getBytes(ENCODING_UTF8);
            return new String(Base64.encode((byte[])digester.digest(msgInBytes), (int)2), ENCODING_UTF8);
        }
        return msg;
    }

    static String urlFormEncode(String source) throws UnsupportedEncodingException {
        return URLEncoder.encode(source, ENCODING_UTF8);
    }

    static String urlFormDecode(String source) throws UnsupportedEncodingException {
        return URLDecoder.decode(source, ENCODING_UTF8);
    }

    static String encodeBase64URLSafeString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])bytes, (int)11), ENCODING_UTF8);
    }

    static URL getUrl(String endpoint) {
        String methodName = ":getUrl";
        URL authority = null;
        try {
            authority = new URL(endpoint);
        }
        catch (MalformedURLException e1) {
            Logger.e(TAG + ":getUrl", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL.getDescription(), e1.getMessage(), ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e1);
        }
        return authority;
    }

    static HashMap<String, String> getUrlParameters(String finalUrl) {
        Uri response = Uri.parse((String)finalUrl);
        String fragment = response.getFragment();
        HashMap<String, String> parameters = HashMapExtensions.urlFormDecode(fragment);
        if (parameters == null || parameters.isEmpty()) {
            String queryParameters = response.getEncodedQuery();
            parameters = HashMapExtensions.urlFormDecode(queryParameters);
        }
        return parameters;
    }

    static List<String> getStringTokens(String items, String delimiter) {
        StringTokenizer st = new StringTokenizer(items, delimiter);
        ArrayList<String> itemList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (StringExtensions.isNullOrBlank(name)) continue;
            itemList.add(name);
        }
        return itemList;
    }

    static ArrayList<String> splitWithQuotes(String input, char delimiter) {
        String item;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        boolean insideString = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == delimiter && !insideString) {
                item = input.substring(startIndex, i);
                if (!StringExtensions.isNullOrBlank(item.trim())) {
                    items.add(item);
                }
                startIndex = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            insideString = !insideString;
        }
        item = input.substring(startIndex);
        if (!StringExtensions.isNullOrBlank(item.trim())) {
            items.add(item);
        }
        return items;
    }

    static String removeQuoteInHeaderValue(String value) {
        if (!StringExtensions.isNullOrBlank(value)) {
            return value.replace("\"", "");
        }
        return null;
    }

    static boolean hasPrefixInHeader(String value, String prefix) {
        return value.startsWith(prefix) && value.length() > prefix.length() + 2 && Character.isWhitespace(value.charAt(prefix.length()));
    }
}

