/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenEntryType;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

class TokenCacheAccessor {
    private static final String TAG = TokenCacheAccessor.class.getSimpleName();
    private final ITokenCacheStore mTokenCacheStore;
    private final String mAuthority;

    TokenCacheAccessor(ITokenCacheStore tokenCacheStore, String authority) {
        if (tokenCacheStore == null) {
            throw new IllegalArgumentException("tokenCacheStore");
        }
        if (StringExtensions.IsNullOrBlank(authority)) {
            throw new IllegalArgumentException("authority");
        }
        this.mTokenCacheStore = tokenCacheStore;
        this.mAuthority = authority;
    }

    TokenCacheItem getATFromCache(String resource, String clientId, String user) throws AuthenticationException {
        TokenCacheItem accessTokenItem = this.getRegularRefreshTokenCacheItem(resource, clientId, user);
        if (accessTokenItem == null) {
            Logger.v(TAG, "No access token exists.");
            return null;
        }
        if (!StringExtensions.IsNullOrBlank(accessTokenItem.getAccessToken())) {
            if (TokenCacheItem.isTokenExpired(accessTokenItem.getExpiresOn())) {
                Logger.v(TAG, "Access token exists, but already expired.");
                return null;
            }
            if (this.isUserMisMatch(user, accessTokenItem)) {
                throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
            }
        }
        return accessTokenItem;
    }

    TokenCacheItem getRegularRefreshTokenCacheItem(String resource, String clientId, String user) {
        String cacheKey = CacheKey.createCacheKeyForRTEntry(this.mAuthority, resource, clientId, user);
        return this.mTokenCacheStore.getItem(cacheKey);
    }

    TokenCacheItem getMRRTItem(String clientId, String user) {
        String cacheKey = CacheKey.createCacheKeyForMRRT(this.mAuthority, clientId, user);
        return this.mTokenCacheStore.getItem(cacheKey);
    }

    TokenCacheItem getFRTItem(String familyClientId, String user) {
        if (StringExtensions.IsNullOrBlank(user)) {
            return null;
        }
        String cacheKey = CacheKey.createCacheKeyForFRT(this.mAuthority, familyClientId, user);
        return this.mTokenCacheStore.getItem(cacheKey);
    }

    void updateCachedItemWithResult(String resource, String clientId, AuthenticationResult result, TokenCacheItem cachedItem) throws AuthenticationException {
        if (result == null) {
            Logger.v(TAG, "AuthenticationResult is not, cannot update cache.");
            throw new IllegalArgumentException("result");
        }
        if (result.getStatus() == AuthenticationResult.AuthenticationStatus.Succeeded) {
            Logger.v(TAG, "Save returned AuthenticationResult into cache.");
            if (cachedItem != null && cachedItem.getUserInfo() != null && result.getUserInfo() == null) {
                result.setUserInfo(cachedItem.getUserInfo());
                result.setIdToken(cachedItem.getRawIdToken());
                result.setTenantId(cachedItem.getTenantId());
            }
            this.updateTokenCache(resource, clientId, result);
        } else if ("invalid_grant".equalsIgnoreCase(result.getErrorCode())) {
            Logger.v(TAG, "Received INVALID_GRANT error code, remove existing cache entry.");
            this.removeTokenCacheItem(cachedItem, resource);
        }
    }

    void updateTokenCache(String resource, String clientId, AuthenticationResult result) {
        if (result == null || StringExtensions.IsNullOrBlank(result.getAccessToken())) {
            return;
        }
        if (result.getUserInfo() != null) {
            if (!StringExtensions.IsNullOrBlank(result.getUserInfo().getDisplayableId())) {
                this.setItemToCacheForUser(resource, clientId, result, result.getUserInfo().getDisplayableId());
            }
            if (!StringExtensions.IsNullOrBlank(result.getUserInfo().getUserId())) {
                this.setItemToCacheForUser(resource, clientId, result, result.getUserInfo().getUserId());
            }
        }
        this.setItemToCacheForUser(resource, clientId, result, null);
    }

    private void removeTokenCacheItem(TokenCacheItem tokenCacheItem, String resource) throws AuthenticationException {
        List<String> keys;
        TokenEntryType tokenEntryType = tokenCacheItem.getTokenEntryType();
        switch (tokenEntryType) {
            case REGULAR_TOKEN_ENTRY: {
                Logger.v(TAG, "Regular RT was used to get access token, remove entries for regular RT entries.");
                keys = this.getKeyListToRemoveForRT(tokenCacheItem);
                break;
            }
            case MRRT_TOKEN_ENTRY: {
                Logger.v(TAG, "MRRT was used to get access token, remove entries for both MRRT entries and regular RT entries.");
                keys = this.getKeyListToRemoveForMRRT(tokenCacheItem, resource);
                TokenCacheItem regularRTItem = new TokenCacheItem(tokenCacheItem);
                regularRTItem.setResource(resource);
                keys.addAll(this.getKeyListToRemoveForRT(regularRTItem));
                break;
            }
            case FRT_TOKEN_ENTRY: {
                Logger.v(TAG, "FRT was used to get access token, remove entries for FRT entries.");
                keys = this.getKeyListToRemoveForFRT(tokenCacheItem);
                break;
            }
            default: {
                throw new AuthenticationException(ADALError.INVALID_TOKEN_CACHE_ITEM);
            }
        }
        for (String key : keys) {
            this.mTokenCacheStore.removeItem(key);
        }
    }

    private void setItemToCacheForUser(String resource, String clientId, AuthenticationResult result, String userId) {
        this.logReturnedToken(result);
        Logger.v(TAG, "Save regular token into cache.");
        this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForRTEntry(this.mAuthority, resource, clientId, userId), TokenCacheItem.createRegularTokenCacheItem(this.mAuthority, resource, clientId, result));
        if (result.getIsMultiResourceRefreshToken()) {
            Logger.v(TAG, "Save Multi Resource Refresh token to cache");
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForMRRT(this.mAuthority, clientId, userId), TokenCacheItem.createMRRTTokenCacheItem(this.mAuthority, clientId, result));
        }
        if (!StringExtensions.IsNullOrBlank(result.getFamilyClientId()) && !StringExtensions.IsNullOrBlank(userId)) {
            Logger.v(TAG, "Save Family Refresh token into cache");
            TokenCacheItem familyTokenCacheItem = TokenCacheItem.createFRRTTokenCacheItem(this.mAuthority, result);
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForFRT(this.mAuthority, result.getFamilyClientId(), userId), familyTokenCacheItem);
        }
    }

    private List<String> getKeyListToRemoveForRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), null));
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForRTEntry(this.mAuthority, cachedItem.getResource(), cachedItem.getClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private List<String> getKeyListToRemoveForMRRT(TokenCacheItem cachedItem, String resource) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), null));
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForMRRT(this.mAuthority, cachedItem.getClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private List<String> getKeyListToRemoveForFRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        if (cachedItem.getUserInfo() != null) {
            keysToRemove.add(CacheKey.createCacheKeyForFRT(this.mAuthority, cachedItem.getFamilyClientId(), cachedItem.getUserInfo().getDisplayableId()));
            keysToRemove.add(CacheKey.createCacheKeyForFRT(this.mAuthority, cachedItem.getFamilyClientId(), cachedItem.getUserInfo().getUserId()));
        }
        return keysToRemove;
    }

    private boolean isUserMisMatch(String user, TokenCacheItem tokenCacheItem) {
        if (StringExtensions.IsNullOrBlank(user) || tokenCacheItem.getUserInfo() == null) {
            return false;
        }
        return !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getDisplayableId()) && !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getUserId());
    }

    private void logReturnedToken(AuthenticationResult result) {
        if (result != null && result.getAccessToken() != null) {
            String accessTokenHash = this.getTokenHash(result.getAccessToken());
            String refreshTokenHash = this.getTokenHash(result.getRefreshToken());
            Logger.v(TAG, String.format("Access TokenID %s and Refresh TokenID %s returned.", accessTokenHash, refreshTokenHash));
        }
    }

    private String getTokenHash(String token) {
        try {
            return StringExtensions.createHash(token);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest error", "", ADALError.DEVICE_NO_SUCH_ALGORITHM, e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Digest error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
        }
        return "";
    }
}

