/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Build;
import android.os.Debug;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

class HttpWebRequest {
    private static final String UNAUTHORIZED_ERROR_MESSAGE_PRE18 = "Received authentication challenge is null";
    private static final String TAG = "HttpWebRequest";
    static final String REQUEST_METHOD_POST = "POST";
    static final String REQUEST_METHOD_GET = "GET";
    static final String REQUEST_METHOD_PUT = "PUT";
    static final String REQUEST_METHOD_DELETE = "DELETE";
    static int CONNECT_TIME_OUT = AuthenticationSettings.INSTANCE.getConnectTimeOut();
    private static int READ_TIME_OUT = AuthenticationSettings.INSTANCE.getReadTimeOut();
    private static int sDebugSimulateDelay = 0;
    private boolean mUseCaches = false;
    private boolean mInstanceRedirectsFollow = true;
    private String mRequestMethod;
    URL mUrl;
    HttpURLConnection mConnection = null;
    byte[] mRequestContent = null;
    private String mRequestContentType = null;
    int mTimeOut = CONNECT_TIME_OUT;
    Exception mException = null;
    HashMap<String, String> mRequestHeaders = null;

    public HttpWebRequest(URL requestURL) {
        this.mUrl = requestURL;
        this.mRequestHeaders = new HashMap();
        if (this.mUrl != null) {
            this.mRequestHeaders.put("Host", HttpWebRequest.getURLAuthority(this.mUrl));
        }
    }

    public HttpWebRequest(URL requestURL, int timeout) {
        this.mUrl = requestURL;
        this.mRequestHeaders = new HashMap();
        if (this.mUrl != null) {
            this.mRequestHeaders.put("Host", HttpWebRequest.getURLAuthority(this.mUrl));
        }
        this.mTimeOut = timeout;
    }

    private void setupConnection() {
        Logger.v(TAG, "HttpWebRequest setupConnection thread:" + Process.myTid());
        if (this.mUrl == null) {
            throw new IllegalArgumentException("requestURL");
        }
        if (!this.mUrl.getProtocol().equalsIgnoreCase("http") && !this.mUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("requestURL");
        }
        HttpURLConnection.setFollowRedirects(true);
        this.mConnection = this.openConnection();
        if (Build.VERSION.SDK_INT > 13) {
            this.mConnection.setRequestProperty("Connection", "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpWebResponse send() {
        Logger.v(TAG, "HttpWebRequest send thread:" + Process.myTid());
        this.setupConnection();
        HttpWebResponse response = new HttpWebResponse();
        if (this.mConnection != null) {
            try {
                for (String header : this.mRequestHeaders.keySet()) {
                    Logger.v(TAG, "Setting header: " + header);
                    this.mConnection.setRequestProperty(header, this.mRequestHeaders.get(header));
                }
                System.setProperty("http.keepAlive", "false");
                this.mConnection.setReadTimeout(READ_TIME_OUT);
                this.mConnection.setInstanceFollowRedirects(this.mInstanceRedirectsFollow);
                this.mConnection.setUseCaches(this.mUseCaches);
                this.mConnection.setRequestMethod(this.mRequestMethod);
                this.mConnection.setDoInput(true);
                this.setRequestBody();
                byte[] responseBody = null;
                InputStream responseStream = null;
                try {
                    responseStream = this.mConnection.getInputStream();
                }
                catch (IOException ex) {
                    Logger.e(TAG, "IOException:" + ex.getMessage(), "", ADALError.SERVER_ERROR);
                    responseStream = this.mConnection.getErrorStream();
                    this.mException = ex;
                }
                this.getStatusCode(response);
                if (responseStream != null) {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int bytesRead = -1;
                    while ((bytesRead = responseStream.read(buffer)) > 0) {
                        byteStream.write(buffer, 0, bytesRead);
                    }
                    responseBody = byteStream.toByteArray();
                }
                if (Debug.isDebuggerConnected() && sDebugSimulateDelay > 0) {
                    Logger.v(TAG, "Sleeping to simulate slow network response");
                    Thread.sleep(sDebugSimulateDelay);
                }
                Logger.v(TAG, "Response is received");
                response.setBody(responseBody);
                response.setResponseHeaders(this.mConnection.getHeaderFields());
            }
            catch (Exception e) {
                Logger.e(TAG, "Exception:" + e.getMessage(), " Method:" + this.mRequestMethod, ADALError.SERVER_ERROR, e);
                this.mException = e;
            }
            finally {
                this.mConnection.disconnect();
                this.mConnection = null;
            }
        }
        response.setResponseException(this.mException);
        return response;
    }

    private void getStatusCode(HttpWebResponse response) throws IOException {
        int statusCode;
        block5: {
            statusCode = 400;
            try {
                statusCode = this.mConnection.getResponseCode();
            }
            catch (IOException ex) {
                if (Build.VERSION.SDK_INT < 16) {
                    if (ex.getMessage() == UNAUTHORIZED_ERROR_MESSAGE_PRE18) {
                        statusCode = 401;
                    }
                } else {
                    statusCode = this.mConnection.getResponseCode();
                }
                if (statusCode == 200 || statusCode == 401) break block5;
                throw ex;
            }
        }
        response.setStatusCode(statusCode);
        Logger.v(TAG, "Status code:" + statusCode);
    }

    private HttpURLConnection openConnection() {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.mUrl.openConnection();
            connection.setConnectTimeout(this.mTimeOut);
        }
        catch (IOException e) {
            this.mException = e;
        }
        return connection;
    }

    private void setRequestBody() throws IOException {
        if (null != this.mRequestContent) {
            this.mConnection.setDoOutput(true);
            if (null != this.getRequestContentType() && !this.getRequestContentType().isEmpty()) {
                this.mConnection.setRequestProperty("Content-Type", this.getRequestContentType());
            }
            this.mConnection.setRequestProperty("Content-Length", Integer.toString(this.mRequestContent.length));
            this.mConnection.setFixedLengthStreamingMode(this.mRequestContent.length);
            OutputStream out = this.mConnection.getOutputStream();
            out.write(this.mRequestContent);
            out.close();
        }
    }

    private static String getURLAuthority(URL requestURL) {
        String authority = requestURL.getAuthority();
        if (requestURL.getPort() == -1) {
            if (requestURL.getProtocol().equalsIgnoreCase("http")) {
                authority = authority + ":80";
            } else if (requestURL.getProtocol().equalsIgnoreCase("https")) {
                authority = authority + ":443";
            }
        }
        return authority;
    }

    URL getURL() {
        return this.mUrl;
    }

    public HashMap<String, String> getRequestHeaders() {
        return this.mRequestHeaders;
    }

    void setRequestMethod(String requestMethod) {
        this.mRequestMethod = requestMethod;
    }

    String getRequestContentType() {
        return this.mRequestContentType;
    }

    void setRequestContentType(String requestContentType) {
        this.mRequestContentType = requestContentType;
    }

    void setRequestContent(byte[] data) {
        this.mRequestContent = data;
    }
}

