/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.JsonHelper;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.util.HashMap;

class ProfileInfo {
    static final String TAG = ProfileInfo.class.getSimpleName();
    String mVersion;
    String mSubject;
    String mTenantId;
    String mName;
    String mPreferredName;

    private ProfileInfo() {
    }

    static ProfileInfo parseProfileInfo(String rawProfileInfo) {
        try {
            if (!StringExtensions.IsNullOrBlank(rawProfileInfo)) {
                byte[] data = Base64.decode((String)rawProfileInfo, (int)8);
                String decodedBody = new String(data, "UTF-8");
                HashMap<String, String> responseItems = new HashMap<String, String>();
                JsonHelper.extractJsonObjects(responseItems, decodedBody);
                if (responseItems != null && !responseItems.isEmpty()) {
                    ProfileInfo profileInfo = new ProfileInfo();
                    profileInfo.mVersion = responseItems.get("ver");
                    profileInfo.mSubject = ProfileInfo.getValue(responseItems.get("sub"));
                    profileInfo.mTenantId = responseItems.get("tid");
                    profileInfo.mName = ProfileInfo.getValue(responseItems.get("name"));
                    profileInfo.mPreferredName = ProfileInfo.getValue(responseItems.get("preferred_username"));
                    Logger.v(TAG, "Profile info is extracted from token response");
                    return profileInfo;
                }
            }
        }
        catch (Exception ex) {
            Logger.e(TAG, "Error in parsing user id token", null, ADALError.IDTOKEN_PARSING_FAILURE, ex);
        }
        return null;
    }

    private static String getValue(String value) {
        if ("null".equalsIgnoreCase(value)) {
            return null;
        }
        return value;
    }

    private static final class ProfileInfoClaim {
        static final String VERSION = "ver";
        static final String SUBJECT = "sub";
        static final String TENANT_ID = "tid";
        static final String PREFERRED_USERNAME = "preferred_username";
        static final String NAME = "name";

        private ProfileInfoClaim() {
        }
    }
}

