/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.ClientMetrics;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HttpEvent;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.ServerRespondingWithRetryableException;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TelemetryUtils;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.JWSBuilder;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.net.IWebRequestHandler;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class Oauth2 {
    private AuthenticationRequest mRequest;
    private IWebRequestHandler mWebRequestHandler;
    private JWSBuilder mJWSBuilder = new JWSBuilder();
    private String mTokenEndpoint;
    private static final String TAG = "Oauth";
    private boolean mRetryOnce = true;
    private static final int DELAY_TIME_PERIOD = 1000;
    private static final int MAX_RESILIENCY_ERROR_CODE = 599;
    private static final String DEFAULT_AUTHORIZE_ENDPOINT = "/oauth2/authorize";
    private static final String DEFAULT_TOKEN_ENDPOINT = "/oauth2/token";
    private static final String HTTPS_PROTOCOL_STRING = "https";
    private static final String STRING_FORMAT_QUERY_PARAM = "%s&%s=%s";
    private String mBrokerClientVersion = "";
    private String mClientVersion = "";

    Oauth2(@NonNull AuthenticationRequest request) {
        this.mRequest = request;
        this.mWebRequestHandler = null;
        this.mJWSBuilder = null;
        this.setTokenEndpoint(this.mRequest.getAuthority() + DEFAULT_TOKEN_ENDPOINT);
    }

    Oauth2(@NonNull AuthenticationRequest request, IWebRequestHandler webRequestHandler) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = null;
        this.setTokenEndpoint(this.mRequest.getAuthority() + DEFAULT_TOKEN_ENDPOINT);
    }

    Oauth2(@NonNull AuthenticationRequest request, IWebRequestHandler webRequestHandler, JWSBuilder jwsMessageBuilder) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = jwsMessageBuilder;
        this.setTokenEndpoint(this.mRequest.getAuthority() + DEFAULT_TOKEN_ENDPOINT);
    }

    public void setClientVersion(String version) {
        this.mClientVersion = version;
        if (this.mWebRequestHandler != null) {
            this.mWebRequestHandler.setClientVersion(version);
        }
    }

    public void setBrokerClientVersion(String version) {
        this.mBrokerClientVersion = version;
    }

    public String getAuthorizationEndpoint() {
        return this.mRequest.getAuthority() + DEFAULT_AUTHORIZE_ENDPOINT;
    }

    public String getTokenEndpoint() {
        return this.mTokenEndpoint;
    }

    public String getAuthorizationEndpointQueryParameters() throws UnsupportedEncodingException {
        Uri.Builder queryParameter = new Uri.Builder();
        queryParameter.appendQueryParameter("response_type", "code").appendQueryParameter("client_id", URLEncoder.encode(this.mRequest.getClientId(), "UTF-8")).appendQueryParameter("resource", URLEncoder.encode(this.mRequest.getResource(), "UTF-8")).appendQueryParameter("redirect_uri", URLEncoder.encode(this.mRequest.getRedirectUri(), "UTF-8")).appendQueryParameter("state", this.encodeProtocolState());
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getLoginHint())) {
            queryParameter.appendQueryParameter("login_hint", URLEncoder.encode(this.mRequest.getLoginHint(), "UTF-8"));
        }
        if (StringExtensions.isNullOrBlank((String)this.mClientVersion)) {
            this.mClientVersion = AuthenticationContext.getVersionName();
        }
        queryParameter.appendQueryParameter("x-client-SKU", "Android").appendQueryParameter("x-client-Ver", URLEncoder.encode(this.mClientVersion, "UTF-8")).appendQueryParameter("x-client-OS", URLEncoder.encode(String.valueOf(Build.VERSION.SDK_INT), "UTF-8")).appendQueryParameter("x-client-DM", URLEncoder.encode(Build.MODEL, "UTF-8"));
        if (!StringExtensions.isNullOrBlank((String)this.mBrokerClientVersion)) {
            queryParameter.appendQueryParameter("x-client-brkrver", URLEncoder.encode(this.mBrokerClientVersion, "UTF-8"));
        }
        if (this.mRequest.getCorrelationId() != null) {
            queryParameter.appendQueryParameter("client-request-id", URLEncoder.encode(this.mRequest.getCorrelationId().toString(), "UTF-8"));
        }
        if (this.mRequest.getPrompt() == PromptBehavior.Always) {
            queryParameter.appendQueryParameter("prompt", URLEncoder.encode("login", "UTF-8"));
        } else if (this.mRequest.getPrompt() == PromptBehavior.REFRESH_SESSION) {
            queryParameter.appendQueryParameter("prompt", URLEncoder.encode("refresh_session", "UTF-8"));
        }
        String extraQP = this.mRequest.getExtraQueryParamsAuthentication();
        if (StringExtensions.isNullOrBlank((String)extraQP) || !extraQP.contains("haschrome")) {
            queryParameter.appendQueryParameter("haschrome", "1");
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getClaimsChallenge()) || this.mRequest.getClientCapabilities() != null) {
            queryParameter.appendQueryParameter("claims", URLEncoder.encode(AuthenticationContext.mergeClaimsWithClientCapabilities(this.mRequest.getClaimsChallenge(), this.mRequest.getClientCapabilities()), "UTF-8"));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppName())) {
            queryParameter.appendQueryParameter("x-app-name", this.mRequest.getAppName());
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppVersion())) {
            queryParameter.appendQueryParameter("x-app-ver", this.mRequest.getAppVersion());
        }
        String requestUrl = queryParameter.build().getQuery();
        if (!StringExtensions.isNullOrBlank((String)extraQP)) {
            String parsedQP = extraQP;
            if (!extraQP.startsWith("&")) {
                parsedQP = "&" + parsedQP;
            }
            requestUrl = requestUrl + parsedQP;
        }
        return requestUrl;
    }

    public String getCodeRequestUrl() throws UnsupportedEncodingException {
        return String.format("%s?%s", this.getAuthorizationEndpoint(), this.getAuthorizationEndpointQueryParameters());
    }

    public String buildTokenRequestMessage(String code) throws UnsupportedEncodingException {
        Logger.v(TAG, "Building request message for redeeming token with auth code.");
        String message = String.format("%s=%s&%s=%s&%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.urlFormEncode((String)"authorization_code"), "code", StringExtensions.urlFormEncode((String)code), "client_id", StringExtensions.urlFormEncode((String)this.mRequest.getClientId()), "redirect_uri", StringExtensions.urlFormEncode((String)this.mRequest.getRedirectUri()), "client_info", "1");
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getClaimsChallenge()) || this.mRequest.getClientCapabilities() != null) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "claims", StringExtensions.urlFormEncode((String)AuthenticationContext.mergeClaimsWithClientCapabilities(this.mRequest.getClaimsChallenge(), this.mRequest.getClientCapabilities())));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppName())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "x-app-name", StringExtensions.urlFormEncode((String)this.mRequest.getAppName()));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppVersion())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "x-app-ver", StringExtensions.urlFormEncode((String)this.mRequest.getAppVersion()));
        }
        return message;
    }

    public String buildRefreshTokenRequestMessage(String refreshToken) throws UnsupportedEncodingException {
        Logger.v(TAG, "Building request message for redeeming token with refresh token.");
        String message = String.format("%s=%s&%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.urlFormEncode((String)"refresh_token"), "refresh_token", StringExtensions.urlFormEncode((String)refreshToken), "client_id", StringExtensions.urlFormEncode((String)this.mRequest.getClientId()), "client_info", "1");
        message = this.buildRequestMessage(message);
        return message;
    }

    public String buildAssertionMessage(@NonNull String assertion, @NonNull String assertionType) throws UnsupportedEncodingException {
        Logger.v(TAG, "Building request message for redeeming token with saml assertion.");
        String message = String.format("%s=%s&%s=%s&%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.urlFormEncode((String)assertionType), "assertion", StringExtensions.urlFormEncode((String)Base64.encodeToString((byte[])assertion.getBytes("UTF-8"), (int)2)), "client_id", StringExtensions.urlFormEncode((String)this.mRequest.getClientId()), "scope", "openid", "client_info", "1");
        message = this.buildRequestMessage(message);
        return message;
    }

    public String buildRequestMessage(String message) throws UnsupportedEncodingException {
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getResource())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "resource", StringExtensions.urlFormEncode((String)this.mRequest.getResource()));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getScope())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "scope", StringExtensions.urlFormEncode((String)this.mRequest.getScope()));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getRedirectUri()) && !this.mRequest.getClientId().equalsIgnoreCase("29d9ed98-a469-4536-ade2-f981bc1d605e")) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "redirect_uri", StringExtensions.urlFormEncode((String)this.mRequest.getRedirectUri()));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getClaimsChallenge()) || this.mRequest.getClientCapabilities() != null) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "claims", StringExtensions.urlFormEncode((String)AuthenticationContext.mergeClaimsWithClientCapabilities(this.mRequest.getClaimsChallenge(), this.mRequest.getClientCapabilities())));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppName())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "x-app-name", StringExtensions.urlFormEncode((String)this.mRequest.getAppName()));
        }
        if (!StringExtensions.isNullOrBlank((String)this.mRequest.getAppVersion())) {
            message = String.format(STRING_FORMAT_QUERY_PARAM, message, "x-app-ver", StringExtensions.urlFormEncode((String)this.mRequest.getAppVersion()));
        }
        return message;
    }

    public AuthenticationResult processUIResponseParams(Map<String, String> response) throws AuthenticationException {
        AuthenticationResult result;
        if (response.containsKey("error")) {
            String correlationInResponse = response.get("correlation_id");
            if (!StringExtensions.isNullOrBlank((String)correlationInResponse)) {
                try {
                    UUID correlationId = UUID.fromString(correlationInResponse);
                    Logger.setCorrelationId(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    Logger.e(TAG, "CorrelationId is malformed: " + correlationInResponse, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            Logger.i(TAG, "OAuth2 error:" + response.get("error"), " Description:" + response.get("error_description"));
            result = new AuthenticationResult(response.get("error"), response.get("error_description"), response.get("error_codes"));
            if (null != response.get("response_body")) {
                HashMap<String, String> responseBody = null;
                try {
                    Oauth2.extractJsonObjects(responseBody, response.get("response_body"));
                    result.setHttpResponseBody(responseBody);
                }
                catch (JSONException exception) {
                    Logger.e(TAG, "Json exception", ExceptionExtensions.getExceptionMessage((Exception)((Object)exception)), ADALError.SERVER_INVALID_JSON_RESPONSE);
                }
            }
            if (null != response.get("response_headers")) {
                HashMap responseHeaders = null;
                try {
                    responseHeaders = HashMapExtensions.jsonStringAsMapList((String)response.get("response_headers"));
                    result.setHttpResponseHeaders(responseHeaders);
                }
                catch (JSONException exception) {
                    Logger.e(TAG, "Json exception", ExceptionExtensions.getExceptionMessage((Exception)((Object)exception)), ADALError.SERVER_INVALID_JSON_RESPONSE);
                }
            }
            if (null != response.get("status_code")) {
                result.setServiceStatusCode(Integer.parseInt(response.get("status_code")));
            }
        } else if (response.containsKey("code")) {
            result = new AuthenticationResult(this.mRequest.getClientId(), response.get("code"));
            String cloudInstanceHostName = response.get("cloud_instance_host_name");
            if (!StringExtensions.isNullOrBlank((String)cloudInstanceHostName)) {
                URL authorityUrl = StringExtensions.getUrl((String)this.mRequest.getAuthority());
                String newAuthorityUrlString = new Uri.Builder().scheme(HTTPS_PROTOCOL_STRING).authority(cloudInstanceHostName).path(authorityUrl.getPath()).build().toString();
                this.setTokenEndpoint(newAuthorityUrlString + DEFAULT_TOKEN_ENDPOINT);
                result.setAuthority(newAuthorityUrlString);
            }
        } else if (response.containsKey("access_token")) {
            boolean isMultiResourceToken = false;
            String expiresIn = response.get("expires_in");
            GregorianCalendar expires = new GregorianCalendar();
            Long expiresInLong = expiresIn == null || expiresIn.isEmpty() ? 3600L : Long.parseLong(expiresIn);
            ((Calendar)expires).add(13, expiresIn == null || expiresIn.isEmpty() ? 3600 : Integer.parseInt(expiresIn));
            String refreshToken = response.get("refresh_token");
            String resource = null;
            if (response.containsKey("resource") && !StringExtensions.isNullOrBlank((String)refreshToken)) {
                isMultiResourceToken = true;
                resource = response.get("resource");
            }
            UserInfo userinfo = null;
            String tenantId = null;
            String rawIdToken = null;
            if (response.containsKey("id_token")) {
                rawIdToken = response.get("id_token");
                if (!StringExtensions.isNullOrBlank((String)rawIdToken)) {
                    Logger.v(TAG, "Id token was returned, parsing id token.");
                    IdToken tokenParsed = new IdToken(rawIdToken);
                    if (tokenParsed != null) {
                        tenantId = tokenParsed.getTenantId();
                        userinfo = new UserInfo(tokenParsed);
                    }
                } else {
                    Logger.v(TAG, "IdToken was not returned from token request.");
                }
            }
            String familyClientId = null;
            if (response.containsKey("foci")) {
                familyClientId = response.get("foci");
            }
            ClientInfo clientInfo = null;
            if (response.containsKey("client_info")) {
                String rawClientInfo = response.get("client_info");
                try {
                    clientInfo = new ClientInfo(rawClientInfo);
                }
                catch (ServiceException e) {
                    Logger.w(TAG, "ClientInfo decoding/parsing failed.");
                }
            }
            result = new AuthenticationResult(response.get("access_token"), refreshToken, expires.getTime(), isMultiResourceToken, userinfo, tenantId, rawIdToken, null, this.mRequest.getClientId());
            result.setResource(resource);
            result.setClientInfo(clientInfo);
            result.setExpiresIn(expiresInLong);
            result.setResponseReceived(System.currentTimeMillis());
            if (response.containsKey("ext_expires_in")) {
                String extendedExpiresIn = response.get("ext_expires_in");
                GregorianCalendar extendedExpires = new GregorianCalendar();
                ((Calendar)extendedExpires).add(13, StringExtensions.isNullOrBlank((String)extendedExpiresIn) ? 3600 : Integer.parseInt(extendedExpiresIn));
                result.setExtendedExpiresOn(extendedExpires.getTime());
            }
            result.setFamilyClientId(familyClientId);
        } else {
            result = null;
        }
        return result;
    }

    public static void extractJsonObjects(Map<String, String> responseItems, String jsonStr) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonStr);
        Iterator i = jsonObject.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            responseItems.put(key, jsonObject.getString(key));
        }
    }

    public AuthenticationResult refreshToken(String refreshToken) throws IOException, AuthenticationException {
        String requestMessage;
        if (this.mWebRequestHandler == null) {
            Logger.v(TAG, "Web request is not set correctly.");
            throw new IllegalArgumentException("webRequestHandler is null.");
        }
        try {
            requestMessage = this.buildRefreshTokenRequestMessage(refreshToken);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), encoding.getMessage(), ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        Map<String, String> headers = this.getRequestHeaders();
        headers.put("x-ms-PKeyAuth", "1.0");
        Logger.v(TAG, "Sending request to redeem token with refresh token.");
        return this.postMessage(requestMessage, headers);
    }

    public AuthenticationResult refreshTokenUsingAssertion(@NonNull String samlAssertion, @NonNull String assertionType) throws IOException, AuthenticationException {
        String requestMessage;
        if (this.mWebRequestHandler == null) {
            Logger.v(TAG, "Web request is not set correctly.");
            throw new IllegalArgumentException("webRequestHandler is null.");
        }
        try {
            requestMessage = this.buildAssertionMessage(samlAssertion, assertionType);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), encoding.getMessage(), ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        Map<String, String> headers = this.getRequestHeaders();
        headers.put("x-ms-PKeyAuth", "1.0");
        Logger.v(TAG, "Sending request to redeem token with assertion.");
        return this.postMessage(requestMessage, headers);
    }

    public AuthenticationResult getToken(String authorizationUrl) throws IOException, AuthenticationException {
        if (StringExtensions.isNullOrBlank((String)authorizationUrl)) {
            throw new IllegalArgumentException("authorizationUrl");
        }
        HashMap parameters = StringExtensions.getUrlParameters((String)authorizationUrl);
        String encodedState = (String)parameters.get("state");
        String state = Oauth2.decodeProtocolState(encodedState);
        if (!StringExtensions.isNullOrBlank((String)state)) {
            Uri stateUri = Uri.parse((String)("http://state/path?" + state));
            String authorizationUri = stateUri.getQueryParameter("a");
            String resource = stateUri.getQueryParameter("r");
            if (!StringExtensions.isNullOrBlank((String)authorizationUri) && !StringExtensions.isNullOrBlank((String)resource) && resource.equalsIgnoreCase(this.mRequest.getResource())) {
                AuthenticationResult result = this.processUIResponseParams(parameters);
                if (result != null && result.getCode() != null && !result.getCode().isEmpty()) {
                    AuthenticationResult tokenResult = this.getTokenForCode(result.getCode());
                    if (!StringExtensions.isNullOrBlank((String)result.getAuthority())) {
                        tokenResult.setAuthority(result.getAuthority());
                    } else {
                        tokenResult.setAuthority(this.mRequest.getAuthority());
                    }
                    return tokenResult;
                }
                return result;
            }
            throw new AuthenticationException(ADALError.AUTH_FAILED_BAD_STATE);
        }
        throw new AuthenticationException(ADALError.AUTH_FAILED_NO_STATE);
    }

    public AuthenticationResult getTokenForCode(String code) throws IOException, AuthenticationException {
        String requestMessage;
        String methodName = ":getTokenForCode";
        if (this.mWebRequestHandler == null) {
            throw new IllegalArgumentException("webRequestHandler");
        }
        try {
            requestMessage = this.buildTokenRequestMessage(code);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e("Oauth:getTokenForCode", ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), encoding.getMessage(), ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        Map<String, String> headers = this.getRequestHeaders();
        Logger.v("Oauth:getTokenForCode", "Sending request to redeem token with auth code.");
        return this.postMessage(requestMessage, headers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticationResult postMessage(String requestMessage, Map<String, String> headers) throws IOException, AuthenticationException {
        AuthenticationResult result;
        block21: {
            String errMessage;
            HttpWebResponse response;
            String methodName = ":postMessage";
            result = null;
            HttpEvent httpEvent = this.startHttpEvent();
            URL authority = StringExtensions.getUrl((String)this.getTokenEndpoint());
            if (authority == null) {
                this.stopHttpEvent(httpEvent);
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
            }
            httpEvent.setHttpPath(authority);
            try {
                boolean isBodyEmpty;
                this.mWebRequestHandler.setRequestCorrelationId(this.mRequest.getCorrelationId());
                this.mWebRequestHandler.setClientVersion(AuthenticationContext.getVersionName());
                ClientMetrics.INSTANCE.beginClientMetricsRecord(authority, this.mRequest.getCorrelationId(), headers);
                response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF-8"), "application/x-www-form-urlencoded");
                httpEvent.setResponseCode(response.getStatusCode());
                httpEvent.setCorrelationId(this.mRequest.getCorrelationId().toString());
                this.stopHttpEvent(httpEvent);
                if (response.getStatusCode() == 401) {
                    if (response.getResponseHeaders() != null && response.getResponseHeaders().containsKey("WWW-Authenticate")) {
                        String challengeHeader = (String)((List)response.getResponseHeaders().get("WWW-Authenticate")).get(0);
                        Logger.i("Oauth:postMessage", "Device certificate challenge request. ", "Challenge header: " + challengeHeader);
                        if (StringExtensions.isNullOrBlank((String)challengeHeader)) throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Challenge header is empty", response);
                        if (StringExtensions.hasPrefixInHeader((String)challengeHeader, (String)"PKeyAuth")) {
                            HttpEvent challengeHttpEvent = this.startHttpEvent();
                            challengeHttpEvent.setHttpPath(authority);
                            Logger.v("Oauth:postMessage", "Received pkeyAuth device challenge.");
                            ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(this.mJWSBuilder);
                            Logger.v("Oauth:postMessage", "Processing device challenge.");
                            ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromHeader(challengeHeader, authority.toString());
                            headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
                            Logger.v("Oauth:postMessage", "Sending request with challenge response.");
                            response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF-8"), "application/x-www-form-urlencoded");
                            challengeHttpEvent.setResponseCode(response.getStatusCode());
                            challengeHttpEvent.setCorrelationId(this.mRequest.getCorrelationId().toString());
                            this.stopHttpEvent(challengeHttpEvent);
                        }
                    } else {
                        Logger.v("Oauth:postMessage", "401 http status code is returned without authorization header.");
                    }
                }
                if (!(isBodyEmpty = TextUtils.isEmpty((CharSequence)response.getBody()))) {
                    Logger.v("Oauth:postMessage", "Token request does not have exception.");
                    try {
                        result = this.processTokenResponse(response, httpEvent);
                    }
                    catch (ServerRespondingWithRetryableException e) {
                        result = this.retry(requestMessage, headers);
                        if (result != null) {
                            AuthenticationResult authenticationResult = result;
                            ClientMetrics.INSTANCE.endClientMetricsRecord("token", this.mRequest.getCorrelationId());
                            return authenticationResult;
                        }
                        if (this.mRequest.getIsExtendedLifetimeEnabled()) {
                            Logger.v("Oauth:postMessage", "WebResponse is not a success due to: " + response.getStatusCode());
                            throw e;
                        }
                        Logger.v("Oauth:postMessage", "WebResponse is not a success due to: " + response.getStatusCode());
                        throw new AuthenticationException(ADALError.SERVER_ERROR, "WebResponse is not a success due to: " + response.getStatusCode(), response);
                    }
                    ClientMetrics.INSTANCE.setLastError(null);
                }
                if (result != null) break block21;
                errMessage = isBodyEmpty ? "Status code:" + response.getStatusCode() : response.getBody();
            }
            catch (UnsupportedEncodingException e) {
                ClientMetrics.INSTANCE.setLastError(null);
                Logger.e("Oauth:postMessage", ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), e.getMessage(), ADALError.ENCODING_IS_NOT_SUPPORTED, e);
                throw e;
            }
            catch (SocketTimeoutException e) {
                result = this.retry(requestMessage, headers);
                if (result != null) {
                    AuthenticationResult authenticationResult = result;
                    return authenticationResult;
                }
                ClientMetrics.INSTANCE.setLastError(null);
                if (this.mRequest.getIsExtendedLifetimeEnabled()) {
                    Logger.e("Oauth:postMessage", ADALError.SERVER_ERROR.getDescription(), e.getMessage(), ADALError.SERVER_ERROR, e);
                    throw new ServerRespondingWithRetryableException(e.getMessage(), e);
                }
                Logger.e("Oauth:postMessage", ADALError.SERVER_ERROR.getDescription(), e.getMessage(), ADALError.SERVER_ERROR, e);
                throw e;
            }
            catch (IOException e) {
                ClientMetrics.INSTANCE.setLastError(null);
                Logger.e("Oauth:postMessage", ADALError.SERVER_ERROR.getDescription(), e.getMessage(), ADALError.SERVER_ERROR, e);
                throw e;
            }
            finally {
                ClientMetrics.INSTANCE.endClientMetricsRecord("token", this.mRequest.getCorrelationId());
            }
            Logger.e("Oauth:postMessage", ADALError.SERVER_ERROR.getDescription(), errMessage, ADALError.SERVER_ERROR);
            throw new AuthenticationException(ADALError.SERVER_ERROR, errMessage, response);
        }
        ClientMetrics.INSTANCE.setLastErrorCodes(result.getErrorCodes());
        return result;
    }

    private AuthenticationResult retry(String requestMessage, Map<String, String> headers) throws IOException, AuthenticationException {
        String methodName = ":retry";
        if (this.mRetryOnce) {
            this.mRetryOnce = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                Logger.v("Oauth:retry", "The thread is interrupted while it is sleeping. ");
            }
            Logger.v("Oauth:retry", "Try again...");
            return this.postMessage(requestMessage, headers);
        }
        return null;
    }

    public static String decodeProtocolState(String encodedState) throws UnsupportedEncodingException {
        if (!StringExtensions.isNullOrBlank((String)encodedState)) {
            byte[] stateBytes = Base64.decode((String)encodedState, (int)9);
            return new String(stateBytes, "UTF-8");
        }
        return null;
    }

    public String encodeProtocolState() throws UnsupportedEncodingException {
        String state = String.format("a=%s&r=%s", this.mRequest.getAuthority(), this.mRequest.getResource());
        return Base64.encodeToString((byte[])state.getBytes("UTF-8"), (int)9);
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return headers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private AuthenticationResult processTokenResponse(HttpWebResponse webResponse, HttpEvent httpEvent) throws AuthenticationException {
        AuthenticationResult result;
        int statusCode;
        String methodName = ":processTokenResponse";
        String correlationIdInHeader = null;
        String speRing = null;
        if (webResponse.getResponseHeaders() != null) {
            TelemetryUtils.CliTelemInfo cliTelemInfo;
            List listOfHeaders;
            if (webResponse.getResponseHeaders().containsKey("client-request-id") && (listOfHeaders = (List)webResponse.getResponseHeaders().get("client-request-id")) != null && listOfHeaders.size() > 0) {
                correlationIdInHeader = (String)listOfHeaders.get(0);
            }
            if (webResponse.getResponseHeaders().containsKey("x-ms-request-id") && (listOfHeaders = (List)webResponse.getResponseHeaders().get("x-ms-request-id")) != null && listOfHeaders.size() > 0) {
                Logger.v("Oauth:processTokenResponse", "Set request id header. x-ms-request-id: " + (String)listOfHeaders.get(0));
                httpEvent.setRequestIdHeader((String)listOfHeaders.get(0));
            }
            if (null != webResponse.getResponseHeaders().get("x-ms-clitelem") && !((List)webResponse.getResponseHeaders().get("x-ms-clitelem")).isEmpty() && null != (cliTelemInfo = TelemetryUtils.parseXMsCliTelemHeader((String)((List)webResponse.getResponseHeaders().get("x-ms-clitelem")).get(0)))) {
                httpEvent.setXMsCliTelemData(cliTelemInfo);
                speRing = cliTelemInfo.getSpeRing();
            }
        }
        if ((statusCode = webResponse.getStatusCode()) != 200 && statusCode != 400 && statusCode != 401) {
            if (statusCode < 500) throw new AuthenticationException(ADALError.SERVER_ERROR, "Unexpected server response " + statusCode + " " + webResponse.getBody(), webResponse);
            if (statusCode > 599) throw new AuthenticationException(ADALError.SERVER_ERROR, "Unexpected server response " + statusCode + " " + webResponse.getBody(), webResponse);
            throw new ServerRespondingWithRetryableException("Server Error " + statusCode + " " + webResponse.getBody(), webResponse);
        }
        try {
            result = this.parseJsonResponse(webResponse.getBody());
            if (result != null) {
                if (null != result.getErrorCode()) {
                    result.setHttpResponse(webResponse);
                }
                TelemetryUtils.CliTelemInfo cliTelemInfo = new TelemetryUtils.CliTelemInfo();
                cliTelemInfo._setSpeRing(speRing);
                result.setCliTelemInfo(cliTelemInfo);
                httpEvent.setOauthErrorCode(result.getErrorCode());
            }
        }
        catch (JSONException jsonException) {
            throw new AuthenticationException(ADALError.SERVER_INVALID_JSON_RESPONSE, "Can't parse server response. " + webResponse.getBody(), webResponse, jsonException);
        }
        if (correlationIdInHeader != null && !correlationIdInHeader.isEmpty()) {
            try {
                UUID correlation = UUID.fromString(correlationIdInHeader);
                if (!correlation.equals(this.mRequest.getCorrelationId())) {
                    Logger.w("Oauth:processTokenResponse", "CorrelationId is not matching", "", ADALError.CORRELATION_ID_NOT_MATCHING_REQUEST_RESPONSE);
                }
                Logger.v("Oauth:processTokenResponse", "Response correlationId:" + correlationIdInHeader);
            }
            catch (IllegalArgumentException ex) {
                Logger.e("Oauth:processTokenResponse", "Wrong format of the correlation ID:" + correlationIdInHeader, "", ADALError.CORRELATION_ID_FORMAT, ex);
            }
        }
        if (null == webResponse.getResponseHeaders()) return result;
        List xMsCliTelemValues = (List)webResponse.getResponseHeaders().get("x-ms-clitelem");
        if (null == xMsCliTelemValues) return result;
        if (xMsCliTelemValues.isEmpty()) return result;
        String speValue = (String)xMsCliTelemValues.get(0);
        TelemetryUtils.CliTelemInfo cliTelemInfo = TelemetryUtils.parseXMsCliTelemHeader(speValue);
        if (result == null) return result;
        result.setCliTelemInfo(cliTelemInfo);
        return result;
    }

    private AuthenticationResult parseJsonResponse(String responseBody) throws JSONException, AuthenticationException {
        HashMap<String, String> responseItems = new HashMap<String, String>();
        Oauth2.extractJsonObjects(responseItems, responseBody);
        return this.processUIResponseParams(responseItems);
    }

    private HttpEvent startHttpEvent() {
        HttpEvent httpEvent = new HttpEvent("Microsoft.ADAL.http_event");
        httpEvent.setRequestId(this.mRequest.getTelemetryRequestId());
        httpEvent.setMethod("Microsoft.ADAL.post");
        Telemetry.getInstance().startEvent(this.mRequest.getTelemetryRequestId(), "Microsoft.ADAL.http_event");
        return httpEvent;
    }

    private void stopHttpEvent(HttpEvent httpEvent) {
        Telemetry.getInstance().stopEvent(this.mRequest.getTelemetryRequestId(), httpEvent, "Microsoft.ADAL.http_event");
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.mTokenEndpoint = tokenEndpoint;
    }
}

