/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.os.Handler;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.ResourceAuthenticationChallengeException;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.net.IWebRequestHandler;
import com.microsoft.identity.common.adal.internal.net.WebRequestHandler;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthenticationParameters {
    public static final String AUTH_HEADER_MISSING_AUTHORITY = "WWW-Authenticate header is missing authorization_uri.";
    public static final String AUTH_HEADER_INVALID_FORMAT = "Invalid authentication header format";
    public static final String AUTH_HEADER_MISSING = "WWW-Authenticate header was expected in the response";
    public static final String AUTH_HEADER_WRONG_STATUS = "Unauthorized http response (status code 401) was expected";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String BEARER = "bearer";
    public static final String AUTHORITY_KEY = "authorization_uri";
    public static final String RESOURCE_KEY = "resource_id";
    private static final String TAG = "AuthenticationParameters";
    private String mAuthority;
    private String mResource;
    private static IWebRequestHandler sWebRequest = new WebRequestHandler();
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getResource() {
        return this.mResource;
    }

    public AuthenticationParameters() {
    }

    AuthenticationParameters(String authority, String resource) {
        this.mAuthority = authority;
        this.mResource = resource;
    }

    public static void createFromResourceUrl(Context context, final URL resourceUrl, final AuthenticationParamCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        Logger.v(TAG, "createFromResourceUrl");
        final Handler handler = new Handler(context.getMainLooper());
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", "application/json");
                try {
                    HttpWebResponse webResponse = sWebRequest.sendGet(resourceUrl, headers);
                    try {
                        this.onCompleted(null, AuthenticationParameters.parseResponse(webResponse));
                    }
                    catch (ResourceAuthenticationChallengeException exc) {
                        this.onCompleted(exc, null);
                    }
                }
                catch (IOException e) {
                    this.onCompleted(e, null);
                }
            }

            void onCompleted(final Exception exception, final AuthenticationParameters param) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCompleted(exception, param);
                    }
                });
            }
        });
    }

    public static AuthenticationParameters createFromResponseAuthenticateHeader(String authenticateHeader) throws ResourceAuthenticationChallengeException {
        String methodName = ":createFromResponseAuthenticateHeader";
        if (StringExtensions.isNullOrBlank((String)authenticateHeader)) {
            Logger.w("AuthenticationParameters:createFromResponseAuthenticateHeader", "authenticateHeader was null/empty.");
            throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING);
        }
        Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Parsing challenges - BEGIN");
        List<Challenge> challenges = Challenge.parseChallenges(authenticateHeader);
        Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Parsing challenge - END");
        Challenge bearerChallenge = null;
        Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Looking for Bearer challenge.");
        for (Challenge challenge : challenges) {
            if (!BEARER.equalsIgnoreCase(challenge.getScheme())) continue;
            Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Found Bearer challenge.");
            bearerChallenge = challenge;
            break;
        }
        if (null != bearerChallenge) {
            Map<String, String> challengeParams = bearerChallenge.getParameters();
            String authority = challengeParams.get(AUTHORITY_KEY);
            String resource = challengeParams.get(RESOURCE_KEY);
            Logger.i("AuthenticationParameters:createFromResponseAuthenticateHeader", "Bearer authority", "[" + authority + "]");
            Logger.i("AuthenticationParameters:createFromResponseAuthenticateHeader", "Bearer resource", "[" + resource + "]");
            if (StringExtensions.isNullOrBlank((String)authority)) {
                Logger.w("AuthenticationParameters:createFromResponseAuthenticateHeader", "Null/empty authority.");
                throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING_AUTHORITY);
            }
            Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Parsing leading/trailing \"\"'s (authority)");
            authority = authority.replaceAll("^\"|\"$", "");
            Logger.i("AuthenticationParameters:createFromResponseAuthenticateHeader", "Sanitized authority value", "[" + authority + "]");
            if (StringExtensions.isNullOrBlank((String)authority)) {
                Logger.w("AuthenticationParameters:createFromResponseAuthenticateHeader", "Sanitized authority is null/empty.");
                throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING_AUTHORITY);
            }
            if (!StringExtensions.isNullOrBlank((String)resource)) {
                Logger.v("AuthenticationParameters:createFromResponseAuthenticateHeader", "Parsing leading/trailing \"\"'s (resource)");
                resource = resource.replaceAll("^\"|\"$", "");
                Logger.i("AuthenticationParameters:createFromResponseAuthenticateHeader", "Sanitized resource value", "[" + authority + "]");
            }
            return new AuthenticationParameters(authority, resource);
        }
        Logger.w("AuthenticationParameters:createFromResponseAuthenticateHeader", "Did not locate Bearer challenge.");
        throw new ResourceAuthenticationChallengeException(AUTH_HEADER_INVALID_FORMAT);
    }

    private static AuthenticationParameters parseResponse(HttpWebResponse webResponse) throws ResourceAuthenticationChallengeException {
        if (webResponse.getStatusCode() == 401) {
            List headers;
            Map responseHeaders = webResponse.getResponseHeaders();
            if (responseHeaders != null && responseHeaders.containsKey(AUTHENTICATE_HEADER) && (headers = (List)responseHeaders.get(AUTHENTICATE_HEADER)) != null && headers.size() > 0) {
                return AuthenticationParameters.createFromResponseAuthenticateHeader((String)headers.get(0));
            }
            throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING);
        }
        throw new ResourceAuthenticationChallengeException(AUTH_HEADER_WRONG_STATUS);
    }

    private static final class Challenge {
        private static final String REGEX_UNQUOTED_LOOKAHEAD = "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
        private static final String REGEX_SPLIT_UNQUOTED_EQUALS = "=(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
        private static final String REGEX_SPLIT_UNQUOTED_COMMA = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
        private static final Pattern REGEX_STRING_TOKEN_WITH_SCHEME = Pattern.compile("^([^\\s|^=]+)[\\s|\\t]+([^=]*=[^=]*)+$");
        private static final String SUFFIX_COMMA = ", ";
        private String mScheme;
        private Map<String, String> mParameters;

        private Challenge(String scheme, Map<String, String> params) {
            this.mScheme = scheme;
            this.mParameters = params;
        }

        public String getScheme() {
            return this.mScheme;
        }

        public Map<String, String> getParameters() {
            return this.mParameters;
        }

        static Challenge parseChallenge(String challenge) throws ResourceAuthenticationChallengeException {
            String methodName = ":parseChallenge";
            if (StringExtensions.isNullOrBlank((String)challenge)) {
                Logger.w("AuthenticationParameters:parseChallenge", "Cannot parse null/empty challenge.");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_MISSING);
            }
            String scheme = Challenge.parseScheme(challenge);
            Logger.i("AuthenticationParameters:parseChallenge", "Parsing scheme", "Scheme value [" + scheme + "]");
            Logger.i("AuthenticationParameters:parseChallenge", "Removing scheme from source challenge", "[" + challenge + "]");
            Logger.v("AuthenticationParameters:parseChallenge", "Parsing challenge substr. Total length: " + challenge.length() + " Scheme index: " + scheme.length() + 1);
            String challengeSansScheme = challenge.substring(scheme.length() + 1);
            Map<String, String> params = Challenge.parseParams(challengeSansScheme);
            return new Challenge(scheme, params);
        }

        private static String parseScheme(String challenge) throws ResourceAuthenticationChallengeException {
            String methodName = ":parseScheme";
            if (StringExtensions.isNullOrBlank((String)challenge)) {
                Logger.w("AuthenticationParameters:parseScheme", "Cannot parse an empty/blank challenge");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_MISSING);
            }
            int indexOfFirstSpace = challenge.indexOf(32);
            int indexOfFirstTab = challenge.indexOf(9);
            if (indexOfFirstSpace < 0 && indexOfFirstTab < 0) {
                Logger.w("AuthenticationParameters:parseScheme", "Couldn't locate space/tab char - returning input String");
                return challenge;
            }
            Logger.v("AuthenticationParameters:parseScheme", "Parsing scheme with indices: indexOfFirstSpace[" + indexOfFirstSpace + "] indexOfFirstTab[" + indexOfFirstTab + "]");
            if (indexOfFirstSpace > -1 && (indexOfFirstSpace < indexOfFirstTab || indexOfFirstTab < 0)) {
                return challenge.substring(0, indexOfFirstSpace);
            }
            if (indexOfFirstTab > -1 && (indexOfFirstTab < indexOfFirstSpace || indexOfFirstSpace < 0)) {
                return challenge.substring(0, indexOfFirstTab);
            }
            Logger.w("AuthenticationParameters:parseScheme", "Unexpected/malformed/missing scheme.");
            throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
        }

        private static Map<String, String> parseParams(String challengeSansScheme) throws ResourceAuthenticationChallengeException {
            String methodName = ":parseParams";
            if (StringExtensions.isNullOrBlank((String)challengeSansScheme)) {
                Logger.w("AuthenticationParameters:parseParams", "ChallengeSansScheme was null/empty");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Logger.i("AuthenticationParameters:parseParams", "Splitting on unquoted commas...", "in-value [" + challengeSansScheme + "]");
            Object[] splitOnUnquotedCommas = challengeSansScheme.split(REGEX_SPLIT_UNQUOTED_COMMA, -1);
            Logger.i("AuthenticationParameters:parseParams", "Splitting on unquoted commas...", "out-value [" + Arrays.toString(splitOnUnquotedCommas) + "]");
            for (Object paramSet : splitOnUnquotedCommas) {
                Logger.i("AuthenticationParameters:parseParams", "Splitting on unquoted equals...", "in-value [" + (String)paramSet + "]");
                Object[] splitOnUnquotedEquals = ((String)paramSet).split(REGEX_SPLIT_UNQUOTED_EQUALS, -1);
                Logger.i("AuthenticationParameters:parseParams", "Splitting on unquoted equals...", "out-value [" + Arrays.toString(splitOnUnquotedEquals) + "]");
                if (splitOnUnquotedEquals.length != 2) {
                    Logger.w("AuthenticationParameters:parseParams", "Splitting on equals yielded mismatched key/value.");
                    throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
                }
                Logger.v("AuthenticationParameters:parseParams", "Trimming split-string whitespace");
                String key = ((String)splitOnUnquotedEquals[0]).trim();
                String value = ((String)splitOnUnquotedEquals[1]).trim();
                Logger.i("AuthenticationParameters:parseParams", "", "key[" + key + "]");
                Logger.i("AuthenticationParameters:parseParams", "", "value[" + value + "]");
                if (params.containsKey(key)) {
                    Logger.w(AuthenticationParameters.TAG, "Key/value pair list contains redundant key. ", "Redundant key: " + key, ADALError.DEVELOPER_BEARER_HEADER_MULTIPLE_ITEMS);
                }
                Logger.i("AuthenticationParameters:parseParams", "", "put(" + key + SUFFIX_COMMA + value + ")");
                params.put(key, value);
            }
            if (params.isEmpty()) {
                Logger.w("AuthenticationParameters:parseParams", "Parsed params were empty.");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
            }
            return params;
        }

        static List<Challenge> parseChallenges(String strChallenges) throws ResourceAuthenticationChallengeException {
            String methodName = ":parseChallenges";
            if (StringExtensions.isNullOrBlank((String)strChallenges)) {
                Logger.w("AuthenticationParameters:parseChallenges", "Cannot parse empty/blank challenges.");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_MISSING);
            }
            ArrayList<Challenge> challenges = new ArrayList<Challenge>();
            try {
                Logger.i("AuthenticationParameters:parseChallenges", "Separating challenges...", "input[" + strChallenges + "]");
                List<String> strChallengesList = Challenge.separateChallenges(strChallenges);
                for (String challenge : strChallengesList) {
                    challenges.add(Challenge.parseChallenge(challenge));
                }
            }
            catch (ResourceAuthenticationChallengeException e) {
                Logger.w("AuthenticationParameters:parseChallenges", "Encountered error during parsing...", e.getMessage(), null);
                throw e;
            }
            catch (Exception e) {
                Logger.w("AuthenticationParameters:parseChallenges", "Encountered error during parsing...", e.getMessage(), null);
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
            }
            return challenges;
        }

        private static List<String> separateChallenges(String challenges) throws ResourceAuthenticationChallengeException {
            String methodName = ":separateChallenges";
            if (StringExtensions.isNullOrBlank((String)challenges)) {
                Logger.w("AuthenticationParameters:separateChallenges", "Input String was null");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
            }
            Logger.i("AuthenticationParameters:separateChallenges", "Splitting input String on unquoted commas", "input[" + challenges + "]");
            Object[] splitOnUnquotedCommas = challenges.split(REGEX_SPLIT_UNQUOTED_COMMA, -1);
            Logger.i("AuthenticationParameters:separateChallenges", "Splitting input String on unquoted commas", "output[" + Arrays.toString(splitOnUnquotedCommas) + "]");
            Challenge.sanitizeWhitespace((String[])splitOnUnquotedCommas);
            List<String> tokensContainingScheme = Challenge.extractTokensContainingScheme((String[])splitOnUnquotedCommas);
            String[] outStrings = new String[tokensContainingScheme.size()];
            for (int ii = 0; ii < outStrings.length; ++ii) {
                outStrings[ii] = "";
            }
            Challenge.writeParsedChallenges((String[])splitOnUnquotedCommas, tokensContainingScheme, outStrings);
            Challenge.sanitizeParsedSuffixes(outStrings);
            return Arrays.asList(outStrings);
        }

        private static void writeParsedChallenges(String[] splitOnUnquotedCommas, List<String> tokensContainingScheme, String[] outStrings) {
            int ii = -1;
            for (String token : splitOnUnquotedCommas) {
                if (tokensContainingScheme.contains(token)) {
                    outStrings[++ii] = token + SUFFIX_COMMA;
                    continue;
                }
                int n = ii;
                outStrings[n] = outStrings[n] + token + SUFFIX_COMMA;
            }
        }

        private static void sanitizeParsedSuffixes(String[] outStrings) {
            for (int jj = 0; jj < outStrings.length; ++jj) {
                if (!outStrings[jj].endsWith(SUFFIX_COMMA)) continue;
                outStrings[jj] = outStrings[jj].substring(0, outStrings[jj].length() - 2);
            }
        }

        private static List<String> extractTokensContainingScheme(String[] strArry) throws ResourceAuthenticationChallengeException {
            ArrayList<String> tokensContainingScheme = new ArrayList<String>();
            for (String token : strArry) {
                if (!Challenge.containsScheme(token)) continue;
                tokensContainingScheme.add(token);
            }
            return tokensContainingScheme;
        }

        private static boolean containsScheme(String token) throws ResourceAuthenticationChallengeException {
            String methodName = ":containsScheme";
            if (StringExtensions.isNullOrBlank((String)token)) {
                Logger.w("AuthenticationParameters:containsScheme", "Null/blank potential scheme token");
                throw new ResourceAuthenticationChallengeException(AuthenticationParameters.AUTH_HEADER_INVALID_FORMAT);
            }
            Logger.i("AuthenticationParameters:containsScheme", "Testing token contains scheme", "input[" + token + "]");
            Matcher matcher = REGEX_STRING_TOKEN_WITH_SCHEME.matcher(token);
            boolean match = matcher.matches();
            Logger.i("AuthenticationParameters:containsScheme", "Testing String contains scheme", "Matches? [" + match + "]");
            return match;
        }

        private static void sanitizeWhitespace(String[] strArray) {
            String methodName = ":sanitizeWhitespace";
            Logger.v("AuthenticationParameters:sanitizeWhitespace", "Sanitizing whitespace");
            for (int ii = 0; ii < strArray.length; ++ii) {
                strArray[ii] = strArray[ii].trim();
            }
        }
    }

    public static interface AuthenticationParamCallback {
        public void onCompleted(Exception var1, AuthenticationParameters var2);
    }
}

