/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.content.pm.PackageInfoCompat;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.APIEvent;
import com.microsoft.aad.adal.AcquireTokenInteractiveRequest;
import com.microsoft.aad.adal.AcquireTokenSilentHandler;
import com.microsoft.aad.adal.AcquireTokenWithBrokerRequest;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationDialog;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthorityValidationMetadataCache;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HttpUtil;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TelemetryUtils;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class AcquireTokenRequest {
    private static final String TAG = AcquireTokenRequest.class.getSimpleName();
    private static final ExecutorService THREAD_EXECUTOR = Executors.newSingleThreadExecutor();
    private final Context mContext;
    private final AuthenticationContext mAuthContext;
    private TokenCacheAccessor mTokenCacheAccessor;
    private final IBrokerProxy mBrokerProxy;
    private static Handler sHandler = null;
    private static final long CP_LLT_VERSION_CODE = 2950722L;
    private static final long AUTHENTICATOR_LLT_VERSION_CODE = 138L;
    private Discovery mDiscovery;
    private APIEvent mAPIEvent;

    AcquireTokenRequest(Context appContext, AuthenticationContext authContext, APIEvent apiEvent) {
        this.mContext = appContext;
        this.mAuthContext = authContext;
        this.mDiscovery = new Discovery(this.mContext);
        if (authContext.getCache() != null && apiEvent != null) {
            this.mTokenCacheAccessor = new TokenCacheAccessor(appContext.getApplicationContext(), authContext.getCache(), authContext.getAuthority(), apiEvent.getTelemetryRequestId());
            this.mTokenCacheAccessor.setValidateAuthorityHost(this.mAuthContext.getValidateAuthority());
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
        this.mAPIEvent = apiEvent;
    }

    void acquireToken(final IWindowComponent activity, final boolean useDialog, final AuthenticationRequest authRequest, AuthenticationCallback<AuthenticationResult> authenticationCallback) {
        String methodName = ":acquireToken";
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), authenticationCallback);
        Logger.setCorrelationId(authRequest.getCorrelationId());
        Logger.v(TAG + ":acquireToken", "Sending async task from thread:" + Process.myTid());
        THREAD_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Logger.setCorrelationId(authRequest.getCorrelationId());
                Logger.v(TAG + ":acquireToken", "Running task in thread:" + Process.myTid());
                try {
                    AcquireTokenRequest.this.validateAcquireTokenRequest(authRequest);
                    AcquireTokenRequest.this.performAcquireTokenRequest(callbackHandle, activity, useDialog, authRequest);
                }
                catch (AuthenticationException authenticationException) {
                    AcquireTokenRequest.this.mAPIEvent.setSpeRing(authenticationException.getSpeRing());
                    AcquireTokenRequest.this.mAPIEvent.setRefreshTokenAge(authenticationException.getRefreshTokenAge());
                    AcquireTokenRequest.this.mAPIEvent.setServerErrorCode(authenticationException.getCliTelemErrorCode());
                    AcquireTokenRequest.this.mAPIEvent.setServerSubErrorCode(authenticationException.getCliTelemSubErrorCode());
                    AcquireTokenRequest.this.mAPIEvent.setWasApiCallSuccessful(false, authenticationException);
                    AcquireTokenRequest.this.mAPIEvent.setCorrelationId(authRequest.getCorrelationId().toString());
                    AcquireTokenRequest.this.mAPIEvent.stopTelemetryAndFlush();
                    callbackHandle.onError(authenticationException);
                }
            }
        });
    }

    void refreshTokenWithoutCache(final String refreshToken, final AuthenticationRequest authenticationRequest, AuthenticationCallback<AuthenticationResult> externalCallback) {
        String methodName = ":refreshTokenWithoutCache";
        Logger.setCorrelationId(authenticationRequest.getCorrelationId());
        Logger.v(TAG + ":refreshTokenWithoutCache", "Refresh token without cache");
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), externalCallback);
        THREAD_EXECUTOR.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AcquireTokenRequest.this.validateAcquireTokenRequest(authenticationRequest);
                    AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(AcquireTokenRequest.this.mContext, authenticationRequest, AcquireTokenRequest.this.mTokenCacheAccessor);
                    AuthenticationResult result = acquireTokenSilentHandler.acquireTokenWithRefreshToken(refreshToken);
                    String correlationId = String.format(" CorrelationId: %s", authenticationRequest.getCorrelationId().toString());
                    if (result == null) {
                        Logger.e(TAG + ":refreshTokenWithoutCache", "Returned result with exchanging refresh token for access token is null" + correlationId, "", ADALError.AUTH_REFRESH_FAILED);
                        throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED, "No result received from refresh token request.");
                    }
                    if (!StringExtensions.isNullOrBlank((String)result.getErrorCode())) {
                        Logger.e(TAG + ":refreshTokenWithoutCache", " ErrorCode:" + result.getErrorCode(), " ErrorDescription:" + result.getErrorDescription(), ADALError.AUTH_REFRESH_FAILED);
                        throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED, " ErrorCode:" + result.getErrorCode());
                    }
                    if (StringExtensions.isNullOrBlank((String)result.getAccessToken())) {
                        Logger.e(TAG + ":refreshTokenWithoutCache", "Access Token not returned from server", "", ADALError.AUTH_FAILED_NO_TOKEN);
                        throw new AuthenticationException(ADALError.AUTH_FAILED_NO_TOKEN, " Access Token not returned from server ");
                    }
                    String rawIdToken = result.getIdToken();
                    if (!TextUtils.isEmpty((CharSequence)rawIdToken) && !TextUtils.isEmpty((CharSequence)authenticationRequest.getResource())) {
                        IdToken idTokenRecord = new IdToken(rawIdToken);
                        UserInfo userInfo = new UserInfo(idTokenRecord);
                        TokenCacheItem tokenCacheItem = new TokenCacheItem();
                        tokenCacheItem.setRawIdToken(rawIdToken);
                        tokenCacheItem.setUserInfo(userInfo);
                        tokenCacheItem.setTenantId(idTokenRecord.getTenantId());
                        AcquireTokenRequest.this.mTokenCacheAccessor.updateCachedItemWithResult(authenticationRequest, result, tokenCacheItem);
                    }
                    AcquireTokenRequest.this.mAPIEvent.setWasApiCallSuccessful(true, null);
                    AcquireTokenRequest.this.mAPIEvent.setIdToken(result.getIdToken());
                    callbackHandle.onSuccess(result);
                }
                catch (AuthenticationException authenticationException) {
                    AcquireTokenRequest.this.mAPIEvent.setWasApiCallSuccessful(false, authenticationException);
                    callbackHandle.onError(authenticationException);
                }
                finally {
                    AcquireTokenRequest.this.mAPIEvent.setCorrelationId(authenticationRequest.getCorrelationId().toString());
                    AcquireTokenRequest.this.mAPIEvent.stopTelemetryAndFlush();
                }
            }
        });
    }

    private void validateAcquireTokenRequest(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        URL authorityUrl = StringExtensions.getUrl((String)authenticationRequest.getAuthority());
        if (authorityUrl == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
        }
        this.performAuthorityValidation(authenticationRequest, authorityUrl);
        BrokerProxy.SwitchToBroker canSwitchToBrokerFlag = this.mBrokerProxy.canSwitchToBroker(authenticationRequest.getAuthority());
        if (canSwitchToBrokerFlag != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER && this.mBrokerProxy.verifyUser(authenticationRequest.getLoginHint(), authenticationRequest.getUserId()) && !authenticationRequest.isSilent()) {
            if (canSwitchToBrokerFlag == BrokerProxy.SwitchToBroker.NEED_PERMISSIONS_TO_SWITCH_TO_BROKER) {
                throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for GET_ACCOUNTS.");
            }
            this.verifyBrokerRedirectUri(authenticationRequest);
        }
    }

    private void performAuthorityValidation(AuthenticationRequest authenticationRequest, URL authorityUrl) throws AuthenticationException {
        String methodName = ":performAuthorityValidation";
        Telemetry.getInstance().startEvent(authenticationRequest.getTelemetryRequestId(), "Microsoft.ADAL.authority_validation");
        APIEvent apiEvent = new APIEvent("Microsoft.ADAL.authority_validation");
        apiEvent.setCorrelationId(authenticationRequest.getCorrelationId().toString());
        apiEvent.setRequestId(authenticationRequest.getTelemetryRequestId());
        if (this.mAuthContext.getValidateAuthority()) {
            try {
                this.validateAuthority(authorityUrl, authenticationRequest.getUpnSuffix(), authenticationRequest.isSilent(), authenticationRequest.getCorrelationId());
                apiEvent.setValidationStatus("yes");
            }
            catch (AuthenticationException authenticationException) {
                if (null != authenticationException.getCode() && (authenticationException.getCode().equals((Object)ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE) || authenticationException.getCode().equals((Object)ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION))) {
                    apiEvent.setValidationStatus("not_done");
                } else {
                    apiEvent.setValidationStatus("no");
                }
                throw authenticationException;
            }
            finally {
                Telemetry.getInstance().stopEvent(authenticationRequest.getTelemetryRequestId(), apiEvent, "Microsoft.ADAL.authority_validation");
            }
        }
        if (!UrlExtensions.isADFSAuthority(authorityUrl) && !AuthorityValidationMetadataCache.containsAuthorityHost(authorityUrl)) {
            try {
                this.mDiscovery.validateAuthority(authorityUrl);
            }
            catch (AuthenticationException authenticationException) {
                AuthorityValidationMetadataCache.updateInstanceDiscoveryMap(authorityUrl.getHost(), new InstanceDiscoveryMetadata(false));
                AzureActiveDirectory.putCloud((String)authorityUrl.getHost(), (AzureActiveDirectoryCloud)new AzureActiveDirectoryCloud(false));
                Logger.v(TAG + ":performAuthorityValidation", "Fail to get authority validation metadata back. Ignore the failure since authority validation is turned off.");
            }
        }
        apiEvent.setValidationStatus("not_done");
        Telemetry.getInstance().stopEvent(authenticationRequest.getTelemetryRequestId(), apiEvent, "Microsoft.ADAL.authority_validation");
        InstanceDiscoveryMetadata metadata = AuthorityValidationMetadataCache.getCachedInstanceDiscoveryMetadata(authorityUrl);
        if (metadata == null || !metadata.isValidated()) {
            return;
        }
        this.updatePreferredNetworkLocation(authorityUrl, authenticationRequest, metadata);
    }

    private void updatePreferredNetworkLocation(URL authorityUrl, AuthenticationRequest request, InstanceDiscoveryMetadata metadata) throws AuthenticationException {
        if (metadata == null || !metadata.isValidated()) {
            return;
        }
        if (metadata.getPreferredNetwork() != null && !authorityUrl.getHost().equalsIgnoreCase(metadata.getPreferredNetwork())) {
            try {
                URL replacedAuthority = Discovery.constructAuthorityUrl(authorityUrl, metadata.getPreferredNetwork());
                request.setAuthority(replacedAuthority.toString());
            }
            catch (MalformedURLException ex) {
                Logger.i(TAG, "preferred network is invalid", "use exactly the same authority url that is passed");
            }
        }
    }

    private void validateAuthority(URL authorityUrl, @Nullable String domain, boolean isSilent, UUID correlationId) throws AuthenticationException {
        String methodName = ":validateAuthority";
        boolean isAdfsAuthority = UrlExtensions.isADFSAuthority(authorityUrl);
        boolean isAuthorityValidated = AuthorityValidationMetadataCache.isAuthorityValidated(authorityUrl);
        if (isAuthorityValidated || isAdfsAuthority && this.mAuthContext.getIsAuthorityValidated()) {
            return;
        }
        Logger.v(TAG + ":validateAuthority", "Start validating authority");
        this.mDiscovery.setCorrelationId(correlationId);
        Discovery.verifyAuthorityValidInstance(authorityUrl);
        if (!isSilent && isAdfsAuthority && domain != null) {
            this.mDiscovery.validateAuthorityADFS(authorityUrl, domain);
        } else {
            if (isSilent && UrlExtensions.isADFSAuthority(authorityUrl)) {
                Logger.v(TAG + ":validateAuthority", "Silent request. Skipping AD FS authority validation");
            }
            this.mDiscovery.validateAuthority(authorityUrl);
        }
        Logger.v(TAG + ":validateAuthority", "The passed in authority is valid.");
        this.mAuthContext.setIsAuthorityValidated(true);
    }

    private void performAcquireTokenRequest(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":performAcquireTokenRequest";
        AuthenticationResult authenticationResultFromSilentRequest = this.tryAcquireTokenSilent(authenticationRequest);
        if (this.isAccessTokenReturned(authenticationResultFromSilentRequest)) {
            this.mAPIEvent.setWasApiCallSuccessful(true, null);
            this.mAPIEvent.setCorrelationId(authenticationRequest.getCorrelationId().toString());
            this.mAPIEvent.setIdToken(authenticationResultFromSilentRequest.getIdToken());
            this.mAPIEvent.stopTelemetryAndFlush();
            callbackHandle.onSuccess(authenticationResultFromSilentRequest);
            return;
        }
        Logger.d(TAG + ":performAcquireTokenRequest", "Trying to acquire token interactively.");
        this.acquireTokenInteractiveFlow(callbackHandle, activity, useDialog, authenticationRequest);
    }

    private AuthenticationResult tryAcquireTokenSilent(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":tryAcquireTokenSilent";
        AuthenticationResult authenticationResult = null;
        if (this.shouldTrySilentFlow(authenticationRequest)) {
            Logger.v(TAG + ":tryAcquireTokenSilent", "Try to acquire token silently, return valid AT or use RT in the cache.");
            authenticationResult = this.acquireTokenSilentFlow(authenticationRequest);
            boolean isAccessTokenReturned = this.isAccessTokenReturned(authenticationResult);
            if (!isAccessTokenReturned && authenticationRequest.isSilent()) {
                String errorInfo = authenticationResult == null ? "No result returned from acquireTokenSilent" : " ErrorCode:" + authenticationResult.getErrorCode();
                Logger.e(TAG + ":tryAcquireTokenSilent", "Prompt is not allowed and failed to get token. " + errorInfo, authenticationRequest.getLogInfo(), ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                AuthenticationException authenticationException = new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, authenticationRequest.getLogInfo() + " " + errorInfo);
                this.addHttpInfoToException(authenticationResult, authenticationException);
                throw authenticationException;
            }
            if (isAccessTokenReturned) {
                Logger.v(TAG + ":tryAcquireTokenSilent", "Token is successfully returned from silent flow. ");
            }
        }
        return authenticationResult;
    }

    private void addHttpInfoToException(AuthenticationResult result, AuthenticationException exception) {
        if (result != null && exception != null) {
            if (result.getHttpResponseHeaders() != null) {
                exception.setHttpResponseHeaders(result.getHttpResponseHeaders());
            }
            if (result.getHttpResponseBody() != null) {
                exception.setHttpResponseBody(result.getHttpResponseBody());
            }
            exception.setServiceStatusCode(result.getServiceStatusCode());
        }
    }

    private boolean shouldTrySilentFlow(AuthenticationRequest authenticationRequest) {
        boolean result = true;
        if (authenticationRequest.isClaimsChallengePresent()) {
            result = this.checkIfBrokerHasLltChanges();
        }
        return authenticationRequest.isSilent() || result && authenticationRequest.getPrompt() == PromptBehavior.Auto;
    }

    private boolean checkIfBrokerHasLltChanges() {
        PackageManager packageManager = this.mContext.getPackageManager();
        long authVersionCode = Long.MAX_VALUE;
        long cpVersionCode = Long.MAX_VALUE;
        long brokerHostVersionCode = Integer.MAX_VALUE;
        try {
            PackageInfo authPackageInfo = packageManager.getPackageInfo("com.azure.authenticator", 0);
            authVersionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)authPackageInfo);
        }
        catch (PackageManager.NameNotFoundException authPackageInfo) {
            // empty catch block
        }
        try {
            PackageInfo cpPackageInfo = packageManager.getPackageInfo("com.microsoft.windowsintune.companyportal", 0);
            cpVersionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)cpPackageInfo);
        }
        catch (PackageManager.NameNotFoundException cpPackageInfo) {
            // empty catch block
        }
        try {
            PackageInfo brokerHostPackageInfo = packageManager.getPackageInfo("com.microsoft.identity.testuserapp", 0);
            brokerHostVersionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)brokerHostPackageInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return authVersionCode >= 138L && cpVersionCode >= 2950722L && brokerHostVersionCode >= 2950722L;
    }

    private AuthenticationResult acquireTokenSilentFlow(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        boolean requestEligibleForBroker = this.mBrokerProxy.verifyBrokerForSilentRequest(authenticationRequest);
        String methodName = ":acquireTokenSilentFlow";
        if ((authenticationRequest.getForceRefresh() || authenticationRequest.isClaimsChallengePresent()) && requestEligibleForBroker) {
            return this.tryAcquireTokenSilentWithBroker(authenticationRequest);
        }
        AuthenticationResult authResult = this.tryAcquireTokenSilentLocally(authenticationRequest);
        if (this.isAccessTokenReturned(authResult)) {
            return authResult;
        }
        if (authenticationRequest.getSamlAssertion() != null && authenticationRequest.getAssertionType() != null) {
            AuthenticationResult authResultFromSaml = this.tryAcquireTokenSilentWithAssertion(authenticationRequest);
            if (this.isAccessTokenReturned(authResultFromSaml)) {
                Logger.v(TAG + ":acquireTokenSilentFlow", "Access token has been acquired using the saml assertion.");
                return authResultFromSaml;
            }
            Logger.w(TAG + ":acquireTokenSilentFlow", "Failed to acquire tokens using saml assertion.");
        }
        if (requestEligibleForBroker) {
            return this.tryAcquireTokenSilentWithBroker(authenticationRequest);
        }
        return authResult;
    }

    private AuthenticationResult tryAcquireTokenSilentLocally(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":tryAcquireTokenSilentLocally";
        Logger.v(TAG + ":tryAcquireTokenSilentLocally", "Try to silently get token from local cache.");
        AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(this.mContext, authenticationRequest, this.mTokenCacheAccessor);
        return acquireTokenSilentHandler.getAccessToken();
    }

    private AuthenticationResult tryAcquireTokenSilentWithAssertion(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":tryAcquireTokenSilentWithAssertion";
        Logger.v(TAG + ":tryAcquireTokenSilentWithAssertion", "Try to silently get token using SAML Assertion.");
        AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(this.mContext, authenticationRequest, this.mTokenCacheAccessor);
        return acquireTokenSilentHandler.getAccessTokenUsingAssertion();
    }

    private AuthenticationResult tryAcquireTokenSilentWithBroker(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":tryAcquireTokenSilentWithBroker";
        Logger.d(TAG + ":tryAcquireTokenSilentWithBroker", "Either could not get tokens from local cache or is force refresh request, switch to Broker for auth, clear tokens from local cache for the user.");
        this.removeTokensForUser(authenticationRequest);
        AcquireTokenWithBrokerRequest acquireTokenWithBrokerRequest = new AcquireTokenWithBrokerRequest(authenticationRequest, this.mBrokerProxy);
        AuthenticationResult authResult = acquireTokenWithBrokerRequest.acquireTokenWithBrokerSilent();
        return authResult;
    }

    private void removeTokensForUser(AuthenticationRequest request) throws AuthenticationException {
        TokenCacheItem regularTokenCacheItem;
        TokenCacheItem mrrtItem;
        TokenCacheItem frtItem;
        String methodName = ":removeTokensForUser";
        if (this.mTokenCacheAccessor == null) {
            return;
        }
        String user = !StringExtensions.isNullOrBlank((String)request.getUserId()) ? request.getUserId() : request.getLoginHint();
        try {
            frtItem = this.mTokenCacheAccessor.getFRTItem("1", user);
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (frtItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(frtItem, request.getResource());
        }
        try {
            mrrtItem = this.mTokenCacheAccessor.getMRRTItem(request.getClientId(), user);
            regularTokenCacheItem = this.mTokenCacheAccessor.getRegularRefreshTokenCacheItem(request.getResource(), request.getClientId(), user);
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (mrrtItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(mrrtItem, request.getResource());
        } else if (regularTokenCacheItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(regularTokenCacheItem, request.getResource());
        } else {
            Logger.v(TAG + ":removeTokensForUser", "No token items need to be deleted for the user.");
        }
    }

    private void acquireTokenInteractiveFlow(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest authenticationRequest) throws AuthenticationException {
        String methodName = ":acquireTokenInteractiveFlow";
        if (activity == null && !useDialog) {
            throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, authenticationRequest.getLogInfo() + " Cannot launch webview, activity is null.");
        }
        HttpUtil.throwIfNetworkNotAvailable(this.mContext);
        int requestId = callbackHandle.getCallback().hashCode();
        authenticationRequest.setRequestId(requestId);
        this.mAuthContext.putWaitingRequest(requestId, new AuthenticationRequestState(requestId, authenticationRequest, callbackHandle.getCallback(), this.mAPIEvent));
        BrokerProxy.SwitchToBroker switchToBrokerFlag = this.mBrokerProxy.canSwitchToBroker(authenticationRequest.getAuthority());
        if (switchToBrokerFlag != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER && this.mBrokerProxy.verifyUser(authenticationRequest.getLoginHint(), authenticationRequest.getUserId())) {
            if (switchToBrokerFlag == BrokerProxy.SwitchToBroker.NEED_PERMISSIONS_TO_SWITCH_TO_BROKER) {
                throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for GET_ACCOUNTS");
            }
            Logger.v(TAG + ":acquireTokenInteractiveFlow", "Launch activity for interactive authentication via broker with callback. ", "" + callbackHandle.getCallback().hashCode(), null);
            AcquireTokenWithBrokerRequest acquireTokenWithBrokerRequest = new AcquireTokenWithBrokerRequest(authenticationRequest, this.mBrokerProxy);
            acquireTokenWithBrokerRequest.acquireTokenWithBrokerInteractively(activity);
        } else {
            Logger.v(TAG + ":acquireTokenInteractiveFlow", "Starting Authentication Activity for embedded flow. ", " Callback is: " + callbackHandle.getCallback().hashCode(), null);
            AcquireTokenInteractiveRequest acquireTokenInteractiveRequest = new AcquireTokenInteractiveRequest(this.mContext, authenticationRequest, this.mTokenCacheAccessor);
            acquireTokenInteractiveRequest.acquireToken(activity, useDialog ? new AuthenticationDialog(this.getHandler(), this.mContext, this, authenticationRequest) : null);
        }
    }

    private void verifyBrokerRedirectUri(AuthenticationRequest request) throws UsageAuthenticationException {
        String base64URLEncodeSignature;
        String base64URLEncodePackagename;
        String methodName = ":verifyBrokerRedirectUri";
        String inputUri = request.getRedirectUri();
        String actualRedirectUri = this.mAuthContext.getRedirectUriForBroker();
        if (StringExtensions.isNullOrBlank((String)inputUri)) {
            Logger.e(TAG + ":verifyBrokerRedirectUri", "The redirectUri is null or blank. ", "The redirect uri is expected to be:" + actualRedirectUri, ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, "The redirectUri is null or blank.");
        }
        if (inputUri.equalsIgnoreCase("urn:ietf:wg:oauth:2.0:oob")) {
            com.microsoft.identity.common.internal.logging.Logger.info((String)(TAG + ":verifyBrokerRedirectUri"), (String)"This is a broker redirectUri. Bypass the check.");
            return;
        }
        if (!inputUri.startsWith("msauth://")) {
            String errMsg = " The valid broker redirect URI prefix: msauth so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", "The prefix of the redirect uri does not match the expected value. ", errMsg, ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, "The prefix of the redirect uri does not match the expected value.");
        }
        PackageHelper packageHelper = new PackageHelper(this.mContext);
        try {
            base64URLEncodePackagename = URLEncoder.encode(this.mContext.getPackageName(), "UTF-8");
            base64URLEncodeSignature = URLEncoder.encode(packageHelper.getCurrentSignatureForPackage(this.mContext.getPackageName()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG + ":verifyBrokerRedirectUri", ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), e.getMessage(), ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            throw new UsageAuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED, "The verifying BrokerRedirectUri process failed because the base64 url encoding is not supported.", e);
        }
        if (!inputUri.startsWith("msauth://" + base64URLEncodePackagename + "/")) {
            String errMsg = "This apps package name is: " + base64URLEncodePackagename + " so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", "The base64 url encoded package name component of the redirect uri does not match the expected value. ", errMsg, ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, "The base64 url encoded package name component of the redirect uri does not match the expected value. ");
        }
        if (!inputUri.equalsIgnoreCase(actualRedirectUri)) {
            String errMsg = "This apps signature is: " + base64URLEncodeSignature + " so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", "The base64 url encoded signature component of the redirect uri does not match the expected value. ", errMsg, ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, "The base64 url encoded signature component of the redirect uri does not match the expected value.");
        }
        Logger.v(TAG + ":verifyBrokerRedirectUri", "The broker redirect URI is valid.");
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        if (requestCode == 1001) {
            this.getHandler();
            if (data == null || data.getExtras() == null) {
                Logger.e(TAG + ":onActivityResult", "BROWSER_FLOW data is null.", "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            } else {
                AuthenticationRequestState waitingRequest;
                Bundle extras = data.getExtras();
                final int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
                try {
                    waitingRequest = this.mAuthContext.getWaitingRequest(requestId);
                    this.mAuthContext.removeWaitingRequest(requestId);
                    Logger.v(TAG + ":onActivityResult", "Waiting request found. RequestId:" + requestId);
                }
                catch (AuthenticationException authenticationException) {
                    Logger.e(TAG + ":onActivityResult", "Failed to find waiting request. RequestId:" + requestId, "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                    return;
                }
                String correlationInfo = this.mAuthContext.getCorrelationInfoFromWaitingRequest(waitingRequest);
                if (resultCode == 2004) {
                    String accessToken = data.getStringExtra("account.access.token");
                    String accountName = data.getStringExtra("account.name");
                    this.mBrokerProxy.saveAccount(accountName);
                    long expireTime = data.getLongExtra("account.expiredate", 0L);
                    Date expire = new Date(expireTime);
                    String idtoken = data.getStringExtra("account.idtoken");
                    String tenantId = data.getStringExtra("account.userinfo.tenantid");
                    UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(data.getExtras());
                    String serverErrorCode = data.getStringExtra("cliteleminfo.server_error");
                    String serverSubErrorCode = data.getStringExtra("cliteleminfo.server_suberror");
                    String refreshTokenAge = data.getStringExtra("cliteleminfo.rt_age");
                    String speRingInfo = data.getStringExtra("cliteleminfo.spe_ring");
                    AuthenticationRequest originalRequest = waitingRequest.getRequest();
                    String clientId = null;
                    if (null != originalRequest) {
                        clientId = originalRequest.getClientId();
                    }
                    AuthenticationResult brokerResult = new AuthenticationResult(accessToken, null, expire, false, userinfo, tenantId, idtoken, null, clientId);
                    String authority = data.getStringExtra("account.authority");
                    brokerResult.setAuthority(authority);
                    TelemetryUtils.CliTelemInfo cliTelemInfo = new TelemetryUtils.CliTelemInfo();
                    cliTelemInfo._setServerErrorCode(serverErrorCode);
                    cliTelemInfo._setServerSubErrorCode(serverSubErrorCode);
                    cliTelemInfo._setRefreshTokenAge(refreshTokenAge);
                    cliTelemInfo._setSpeRing(speRingInfo);
                    brokerResult.setCliTelemInfo(cliTelemInfo);
                    if (brokerResult.getAccessToken() != null) {
                        waitingRequest.getAPIEvent().setWasApiCallSuccessful(true, null);
                        waitingRequest.getAPIEvent().setCorrelationId(waitingRequest.getRequest().getCorrelationId().toString());
                        waitingRequest.getAPIEvent().setIdToken(brokerResult.getIdToken());
                        waitingRequest.getAPIEvent().setServerErrorCode(cliTelemInfo.getServerErrorCode());
                        waitingRequest.getAPIEvent().setServerSubErrorCode(cliTelemInfo.getServerSubErrorCode());
                        waitingRequest.getAPIEvent().setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                        waitingRequest.getAPIEvent().setSpeRing(cliTelemInfo.getSpeRing());
                        waitingRequest.getAPIEvent().stopTelemetryAndFlush();
                        waitingRequest.getDelegate().onSuccess(brokerResult);
                    }
                } else if (resultCode == 2001) {
                    Logger.v(TAG + ":onActivityResult", "User cancelled the flow. RequestId:" + requestId + " " + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("User cancelled the flow RequestId:" + requestId + correlationInfo));
                } else if (resultCode == 2006) {
                    Logger.v(TAG + ":onActivityResult", "Device needs to have broker installed, we expect the apps to call usback when the broker is installed");
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.BROKER_APP_INSTALLATION_STARTED));
                } else if (resultCode == 2009) {
                    Logger.v(TAG + ":onActivityResult", "Device needs to be managed, we expect the apps to call usback when the device is managed");
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.MDM_REQUIRED));
                } else if (resultCode == 2005) {
                    Serializable authException = extras.getSerializable("com.microsoft.aad.adal:AuthenticationException");
                    if (authException != null && authException instanceof AuthenticationException) {
                        AuthenticationException exception = (AuthenticationException)authException;
                        Logger.w(TAG + ":onActivityResult", "Webview returned exception.", exception.getMessage(), ADALError.WEBVIEW_RETURNED_AUTHENTICATION_EXCEPTION);
                        this.waitingRequestOnError(waitingRequest, requestId, exception);
                    } else {
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.WEBVIEW_RETURNED_INVALID_AUTHENTICATION_EXCEPTION, correlationInfo));
                    }
                } else if (resultCode == 2002) {
                    String errCode = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                    String errMessage = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                    Logger.v(TAG + ":onActivityResult", "Error info:" + errCode + " for requestId: " + requestId + " " + correlationInfo, errMessage, null);
                    String message = String.format("%s %s %s", errCode, errMessage, correlationInfo);
                    if (!StringExtensions.isNullOrBlank((String)errCode) && ADALError.AUTH_FAILED_INTUNE_POLICY_REQUIRED.name().compareTo(errCode) == 0) {
                        String accountUpn = extras.getString("account.name");
                        String accountId = extras.getString("account.userinfo.userid");
                        String tenantId = extras.getString("account.userinfo.tenantid");
                        String authority = extras.getString("account.authority");
                        IntuneAppProtectionPolicyRequiredException intuneException = new IntuneAppProtectionPolicyRequiredException(message, accountUpn, accountId, tenantId, authority);
                        this.waitingRequestOnError(waitingRequest, requestId, intuneException);
                    } else if ("device_needs_to_be_managed".equalsIgnoreCase(errCode)) {
                        Logger.v(TAG + ":onActivityResult", "Device needs to be managed, we expect the apps to call usback when the device is managed");
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.MDM_REQUIRED));
                    } else {
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.SERVER_INVALID_REQUEST, message));
                    }
                } else if (resultCode == 2003) {
                    AuthenticationRequest authenticationRequest = (AuthenticationRequest)extras.getSerializable("com.microsoft.aad.adal:BrowserRequestInfo");
                    final String endingUrl = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl", "");
                    if (endingUrl.isEmpty()) {
                        StringBuilder exceptionMessage = new StringBuilder("Webview did not reach the redirectUrl. ");
                        if (authenticationRequest != null) {
                            exceptionMessage.append(authenticationRequest.getLogInfo());
                        }
                        exceptionMessage.append(correlationInfo);
                        AuthenticationException e = new AuthenticationException(ADALError.WEBVIEW_RETURNED_EMPTY_REDIRECT_URL, exceptionMessage.toString());
                        Logger.e(TAG + ":onActivityResult", "", e.getMessage(), e.getCode());
                        this.waitingRequestOnError(waitingRequest, requestId, e);
                    } else {
                        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), waitingRequest.getDelegate());
                        THREAD_EXECUTOR.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AcquireTokenInteractiveRequest acquireTokenInteractiveRequest = new AcquireTokenInteractiveRequest(AcquireTokenRequest.this.mContext, waitingRequest.getRequest(), AcquireTokenRequest.this.mTokenCacheAccessor);
                                    AuthenticationResult authenticationResult = acquireTokenInteractiveRequest.acquireTokenWithAuthCode(endingUrl);
                                    waitingRequest.getAPIEvent().setWasApiCallSuccessful(true, null);
                                    waitingRequest.getAPIEvent().setCorrelationId(waitingRequest.getRequest().getCorrelationId().toString());
                                    waitingRequest.getAPIEvent().setIdToken(authenticationResult.getIdToken());
                                    waitingRequest.getAPIEvent().stopTelemetryAndFlush();
                                    if (waitingRequest.getDelegate() != null) {
                                        Logger.v(TAG + ":onActivityResult", "Sending result to callback. ", waitingRequest.getRequest().getLogInfo(), null);
                                        callbackHandle.onSuccess(authenticationResult);
                                    }
                                }
                                catch (AuthenticationException authenticationException) {
                                    StringBuilder message = new StringBuilder(authenticationException.getMessage());
                                    if (authenticationException.getCause() != null) {
                                        message.append(authenticationException.getCause().getMessage());
                                    }
                                    Logger.e(TAG + ":onActivityResult", authenticationException.getCode() == null ? ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN.getDescription() : authenticationException.getCode().getDescription(), message.toString() + ' ' + ExceptionExtensions.getExceptionMessage(authenticationException) + ' ' + Log.getStackTraceString((Throwable)authenticationException), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, null);
                                    AcquireTokenRequest.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, authenticationException);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private boolean isAccessTokenReturned(AuthenticationResult authResult) {
        return authResult != null && !StringExtensions.isNullOrBlank((String)authResult.getAccessToken());
    }

    private synchronized Handler getHandler() {
        if (sHandler == null) {
            sHandler = new Handler(Looper.getMainLooper());
        }
        return sHandler;
    }

    private void waitingRequestOnError(AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        this.waitingRequestOnError(null, waitingRequest, requestId, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitingRequestOnError(CallbackHandler handler, AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        String methodName = ":waitingRequestOnError";
        try {
            if (waitingRequest != null && waitingRequest.getDelegate() != null) {
                Logger.v(TAG + ":waitingRequestOnError", "Sending error to callback" + this.mAuthContext.getCorrelationInfoFromWaitingRequest(waitingRequest));
                waitingRequest.getAPIEvent().setWasApiCallSuccessful(false, exc);
                waitingRequest.getAPIEvent().setCorrelationId(waitingRequest.getRequest().getCorrelationId().toString());
                waitingRequest.getAPIEvent().stopTelemetryAndFlush();
                if (handler != null) {
                    handler.onError(exc);
                } else {
                    waitingRequest.getDelegate().onError(exc);
                }
            }
        }
        finally {
            if (exc != null) {
                this.mAuthContext.removeWaitingRequest(requestId);
            }
        }
    }

    private static class CallbackHandler {
        private Handler mRefHandler;
        private AuthenticationCallback<AuthenticationResult> mCallback;

        CallbackHandler(Handler ref, AuthenticationCallback<AuthenticationResult> callbackExt) {
            this.mRefHandler = ref;
            this.mCallback = callbackExt;
        }

        public void onError(final AuthenticationException e) {
            if (this.mCallback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            mCallback.onError(e);
                        }
                    });
                } else {
                    this.mCallback.onError(e);
                }
            }
        }

        public void onSuccess(final AuthenticationResult result) {
            if (this.mCallback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            mCallback.onSuccess(result);
                        }
                    });
                } else {
                    this.mCallback.onSuccess(result);
                }
            }
        }

        AuthenticationCallback<AuthenticationResult> getCallback() {
            return this.mCallback;
        }
    }
}

