/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.DefaultEvent;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;

final class CacheEvent
extends DefaultEvent {
    private final String mEventName;

    CacheEvent(String eventName) {
        this.mEventName = eventName;
        this.setProperty("Microsoft.ADAL.event_name", eventName);
    }

    void setSpeRing(String speRing) {
        if (!StringExtensions.isNullOrBlank((String)speRing)) {
            this.setProperty("Microsoft.ADAL.spe_info", speRing.trim());
        }
    }

    void setTokenType(String tokenType) {
        this.getEventList().add(new AbstractMap.SimpleEntry<String, String>("Microsoft.ADAL.token_type", tokenType));
    }

    void setTokenTypeRT(boolean tokenTypeRT) {
        this.setProperty("Microsoft.ADAL.is_rt", String.valueOf(tokenTypeRT));
    }

    void setTokenTypeMRRT(boolean tokenTypeMRRT) {
        this.setProperty("Microsoft.ADAL.is_mrrt", String.valueOf(tokenTypeMRRT));
    }

    void setTokenTypeFRT(boolean tokenTypeFRT) {
        this.setProperty("Microsoft.ADAL.is_frt", String.valueOf(tokenTypeFRT));
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        if (this.mEventName != "Microsoft.ADAL.token_cache_lookup") {
            return;
        }
        List<Map.Entry<String, String>> eventList = this.getEventList();
        String count = dispatchMap.get("Microsoft.ADAL.cache_event_count");
        if (count == null) {
            dispatchMap.put("Microsoft.ADAL.cache_event_count", "1");
        } else {
            dispatchMap.put("Microsoft.ADAL.cache_event_count", Integer.toString(Integer.parseInt(count) + 1));
        }
        dispatchMap.put("Microsoft.ADAL.is_frt", "");
        dispatchMap.put("Microsoft.ADAL.is_mrrt", "");
        dispatchMap.put("Microsoft.ADAL.is_rt", "");
        if (dispatchMap.containsKey("Microsoft.ADAL.spe_info")) {
            dispatchMap.remove("Microsoft.ADAL.spe_info");
        }
        for (Map.Entry<String, String> eventKeyValuePair : eventList) {
            String name = eventKeyValuePair.getKey();
            if (!name.equals("Microsoft.ADAL.is_frt") && !name.equals("Microsoft.ADAL.is_rt") && !name.equals("Microsoft.ADAL.is_mrrt") && !name.equals("Microsoft.ADAL.spe_info")) continue;
            dispatchMap.put(name, eventKeyValuePair.getValue());
        }
    }
}

