/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.AggregatedDispatcher;
import com.microsoft.aad.adal.DefaultDispatcher;
import com.microsoft.aad.adal.IDispatcher;
import com.microsoft.aad.adal.IEvents;
import com.microsoft.aad.adal.Logger;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.util.AbstractMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class Telemetry {
    private static final String TAG = Telemetry.class.getSimpleName();
    private DefaultDispatcher mDispatcher = null;
    private static boolean sAllowPii = false;
    private final Map<Map.Entry<String, String>, String> mEventTracking = new ConcurrentHashMap<Map.Entry<String, String>, String>();
    private static final Telemetry INSTANCE = new Telemetry();

    public static synchronized Telemetry getInstance() {
        return INSTANCE;
    }

    public static void setAllowPii(boolean allowFlag) {
        sAllowPii = allowFlag;
    }

    public static boolean getAllowPii() {
        return sAllowPii;
    }

    public synchronized void registerDispatcher(IDispatcher dispatcher, boolean aggregationRequired) {
        this.mDispatcher = aggregationRequired ? new AggregatedDispatcher(dispatcher) : new DefaultDispatcher(dispatcher);
    }

    static String registerNewRequest() {
        return UUID.randomUUID().toString();
    }

    void startEvent(String requestId, String eventName) {
        if (this.mDispatcher == null) {
            return;
        }
        this.mEventTracking.put(new AbstractMap.SimpleEntry<String, String>(requestId, eventName), Long.toString(System.currentTimeMillis()));
    }

    void stopEvent(String requestId, IEvents events, String eventName) {
        if (this.mDispatcher == null) {
            return;
        }
        String startTime = this.mEventTracking.remove(new AbstractMap.SimpleEntry<String, String>(requestId, eventName));
        if (StringExtensions.isNullOrBlank((String)startTime)) {
            Logger.w(TAG, "Stop Event called without a corresponding start_event", "", null);
            return;
        }
        long startTimeLong = Long.parseLong(startTime);
        long stopTimeLong = System.currentTimeMillis();
        long diffTime = stopTimeLong - startTimeLong;
        String stopTime = Long.toString(stopTimeLong);
        events.setProperty("Microsoft.ADAL.start_time", startTime);
        events.setProperty("Microsoft.ADAL.stop_time", stopTime);
        events.setProperty("Microsoft.ADAL.response_time", Long.toString(diffTime));
        this.mDispatcher.receive(requestId, events);
    }

    void flush(String requestId) {
        if (this.mDispatcher != null) {
            this.mDispatcher.flush(requestId);
        }
    }
}

