/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.DefaultEvent;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;

final class UIEvent
extends DefaultEvent {
    UIEvent(String eventName) {
        this.getEventList().add(new AbstractMap.SimpleEntry<String, String>("Microsoft.ADAL.event_name", eventName));
    }

    void setRedirectCount(Integer redirectCount) {
        this.setProperty("Microsoft.ADAL.redirect_count", redirectCount.toString());
    }

    void setNTLM(boolean ntlm) {
        this.setProperty("Microsoft.ADAL.ntlm", String.valueOf(ntlm));
    }

    void setUserCancel() {
        this.setProperty("Microsoft.ADAL.user_cancel", "true");
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        List<Map.Entry<String, String>> eventList = this.getEventList();
        String count = dispatchMap.get("Microsoft.ADAL.ui_event_count");
        if (count == null) {
            dispatchMap.put("Microsoft.ADAL.ui_event_count", "1");
        } else {
            dispatchMap.put("Microsoft.ADAL.ui_event_count", Integer.toString(Integer.parseInt(count) + 1));
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.user_cancel")) {
            dispatchMap.put("Microsoft.ADAL.user_cancel", "");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.ntlm")) {
            dispatchMap.put("Microsoft.ADAL.ntlm", "");
        }
        for (Map.Entry<String, String> eventKeyValuePair : eventList) {
            String name = eventKeyValuePair.getKey();
            if (!name.equals("Microsoft.ADAL.user_cancel") && !name.equals("Microsoft.ADAL.ntlm")) continue;
            dispatchMap.put(name, eventKeyValuePair.getValue());
        }
    }
}

