/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.platform.AndroidPlatformUtil;
import com.microsoft.identity.common.java.exception.ClientException;

class HttpUtil {
    HttpUtil() {
    }

    static void throwIfNetworkNotAvailable(Context context) throws AuthenticationException {
        try {
            new AndroidPlatformUtil(context, null).throwIfNetworkNotAvailable(false);
        }
        catch (ClientException e) {
            ADALError error;
            String errorCode = e.getErrorCode();
            String errorMessage = e.getMessage();
            switch (errorCode) {
                case "device_network_not_available_doze_mode": {
                    error = ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION;
                    break;
                }
                case "device_network_not_available": {
                    error = ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE;
                    break;
                }
                default: {
                    error = ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE;
                    Logger.warn((String)"HttpUtil", (String)("Unrecognized error code: " + errorCode));
                }
            }
            throw new AuthenticationException(error, errorMessage);
        }
    }
}

