/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.DefaultEvent;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

final class APIEvent
extends DefaultEvent {
    private static final String TAG = DefaultEvent.class.getSimpleName();
    private final String mEventName;

    APIEvent(String eventName) {
        this.setProperty("Microsoft.ADAL.event_name", eventName);
        this.mEventName = eventName;
    }

    APIEvent(String eventName, Context context, String clientId) {
        this(eventName);
        this.setDefaults(context, clientId);
    }

    void setAuthority(String authority) {
        if (StringExtensions.isNullOrBlank((String)authority)) {
            return;
        }
        this.setProperty("Microsoft.ADAL.authority", authority);
        URL authorityUrl = StringExtensions.getUrl((String)authority);
        if (authorityUrl == null) {
            return;
        }
        if (UrlExtensions.isADFSAuthority(authorityUrl)) {
            this.setAuthorityType("adfs");
        } else {
            this.setAuthorityType("aad");
        }
    }

    void setAuthorityType(String authorityType) {
        this.setProperty("Microsoft.ADAL.authority_type", authorityType);
    }

    void setIsDeprecated(boolean isDeprecated) {
        this.setProperty("Microsoft.ADAL.is_deprecated", String.valueOf(isDeprecated));
    }

    void setValidationStatus(String validationStatus) {
        this.setProperty("Microsoft.ADAL.authority_validation_status", validationStatus);
    }

    void setExtendedExpiresOnSetting(boolean extendedExpiresOnSetting) {
        this.setProperty("Microsoft.ADAL.extended_expires_on_setting", String.valueOf(extendedExpiresOnSetting));
    }

    void setPromptBehavior(String promptBehavior) {
        this.setProperty("Microsoft.ADAL.prompt_behavior", promptBehavior);
    }

    void setPromptBehavior(PromptBehavior promptBehavior) {
        if (promptBehavior != null) {
            this.setProperty("Microsoft.ADAL.prompt_behavior", promptBehavior.toString());
        }
    }

    void setAPIId(String id) {
        this.setProperty("Microsoft.ADAL.api_id", id);
    }

    String getEventName() {
        return this.mEventName;
    }

    void setWasApiCallSuccessful(boolean isSuccess, Exception exception) {
        this.setProperty("Microsoft.ADAL.is_successful", String.valueOf(isSuccess));
        if (exception != null && exception instanceof AuthenticationException) {
            AuthenticationException authException = (AuthenticationException)exception;
            this.setProperty("Microsoft.ADAL.api_error_code", authException.getCode().toString());
        }
    }

    void stopTelemetryAndFlush() {
        Telemetry.getInstance().stopEvent(this.getTelemetryRequestId(), this, this.getEventName());
        Telemetry.getInstance().flush(this.getTelemetryRequestId());
    }

    void setIdToken(String rawIdToken) {
        IdToken idToken;
        String methodName = ":setIdToken";
        if (StringExtensions.isNullOrBlank((String)rawIdToken)) {
            return;
        }
        try {
            idToken = new IdToken(rawIdToken);
        }
        catch (AuthenticationException ae) {
            return;
        }
        UserInfo userInfo = new UserInfo(idToken);
        this.setProperty("Microsoft.ADAL.idp", idToken.getIdentityProvider());
        try {
            this.setProperty("Microsoft.ADAL.tenant_id", StringExtensions.createHash((String)idToken.getTenantId()));
            this.setProperty("Microsoft.ADAL.user_id", StringExtensions.createHash((String)userInfo.getUserId()));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            Logger.i(TAG + ":setIdToken", "Skipping TENANT_ID and USER_ID", "");
        }
    }

    void setLoginHint(String loginHint) {
        String methodName = ":setLoginHint";
        try {
            this.setProperty("Microsoft.ADAL.login_hint", StringExtensions.createHash((String)loginHint));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            Logger.i(TAG + ":setLoginHint", "Skipping telemetry for LOGIN_HINT", "");
        }
    }

    void setServerErrorCode(String errorCode) {
        if (null != errorCode && !errorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_error_code", errorCode.trim());
        }
    }

    void setServerSubErrorCode(String subErrorCode) {
        if (null != subErrorCode && !subErrorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_sub_error_code", subErrorCode.trim());
        }
    }

    void setRefreshTokenAge(String tokenAge) {
        if (!StringExtensions.isNullOrBlank((String)tokenAge)) {
            this.setProperty("Microsoft.ADAL.rt_age", tokenAge.trim());
        }
    }

    void setSpeRing(String speRing) {
        if (!StringExtensions.isNullOrBlank((String)speRing)) {
            this.setProperty("Microsoft.ADAL.spe_info", speRing.trim());
        }
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        super.processEvent(dispatchMap);
        List<Map.Entry<String, String>> eventList = this.getEventList();
        for (Map.Entry<String, String> eventKeyValuePair : eventList) {
            String name = eventKeyValuePair.getKey();
            if (!name.equals("Microsoft.ADAL.authority_type") && !name.equals("Microsoft.ADAL.is_deprecated") && !name.equals("Microsoft.ADAL.authority_validation_status") && !name.equals("Microsoft.ADAL.extended_expires_on_setting") && !name.equals("Microsoft.ADAL.prompt_behavior") && !name.equals("Microsoft.ADAL.is_successful") && !name.equals("Microsoft.ADAL.idp") && !name.equals("Microsoft.ADAL.tenant_id") && !name.equals("Microsoft.ADAL.user_id") && !name.equals("Microsoft.ADAL.login_hint") && !name.equals("Microsoft.ADAL.response_time") && !name.equals("Microsoft.ADAL.correlation_id") && !name.equals("Microsoft.ADAL.request_id") && !name.equals("Microsoft.ADAL.api_id") && !name.equals("Microsoft.ADAL.api_error_code") && !name.equals("Microsoft.ADAL.server_error_code") && !name.equals("Microsoft.ADAL.server_sub_error_code") && !name.equals("Microsoft.ADAL.rt_age") && !name.equals("Microsoft.ADAL.spe_info")) continue;
            dispatchMap.put(name, eventKeyValuePair.getValue());
        }
    }
}

