/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import java.lang.reflect.Type;

public final class TokenCacheItemSerializationAdapater
implements JsonDeserializer<TokenCacheItem>,
JsonSerializer<TokenCacheItem> {
    private static final String TAG = TokenCacheItemSerializationAdapater.class.getSimpleName();

    public JsonElement serialize(TokenCacheItem tokenCacheItem, Type type, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("authority", (JsonElement)new JsonPrimitive(tokenCacheItem.getAuthority()));
        jsonObj.add("refresh_token", (JsonElement)new JsonPrimitive(tokenCacheItem.getRefreshToken()));
        jsonObj.add("id_token", (JsonElement)new JsonPrimitive(tokenCacheItem.getRawIdToken()));
        jsonObj.add("foci", (JsonElement)new JsonPrimitive(tokenCacheItem.getFamilyClientId()));
        return jsonObj;
    }

    public TokenCacheItem deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        IdToken idToken;
        JsonObject srcJsonObj = json.getAsJsonObject();
        this.throwIfParameterMissing(srcJsonObj, "authority");
        this.throwIfParameterMissing(srcJsonObj, "id_token");
        this.throwIfParameterMissing(srcJsonObj, "foci");
        this.throwIfParameterMissing(srcJsonObj, "refresh_token");
        String rawIdToken = srcJsonObj.get("id_token").getAsString();
        TokenCacheItem tokenCacheItem = new TokenCacheItem();
        try {
            idToken = new IdToken(rawIdToken);
        }
        catch (AuthenticationException e) {
            throw new JsonParseException(TAG + ": Could not deserialize into a tokenCacheItem object", (Throwable)e);
        }
        UserInfo userInfo = new UserInfo(idToken);
        tokenCacheItem.setUserInfo(userInfo);
        tokenCacheItem.setTenantId(idToken.getTenantId());
        tokenCacheItem.setAuthority(srcJsonObj.get("authority").getAsString());
        tokenCacheItem.setIsMultiResourceRefreshToken(true);
        tokenCacheItem.setRawIdToken(rawIdToken);
        tokenCacheItem.setFamilyClientId(srcJsonObj.get("foci").getAsString());
        tokenCacheItem.setRefreshToken(srcJsonObj.get("refresh_token").getAsString());
        return tokenCacheItem;
    }

    private void throwIfParameterMissing(JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonParseException(TAG + "Attribute " + name + " is missing for deserialization.");
        }
    }
}

