/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.Action;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.helpers.HttpResponse;
import com.microsoft.alm.helpers.IOHelper;
import com.microsoft.alm.helpers.StringContent;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientImpl
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientImpl.class);
    public final Map<String, String> Headers = new LinkedHashMap<String, String>();

    public HttpClientImpl(String userAgent) {
        this.Headers.put("User-Agent", userAgent);
    }

    private void ensureOK(HttpURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        if (statusCode != 200) {
            InputStream errorStream = null;
            try {
                errorStream = connection.getErrorStream();
                String content = "";
                if (errorStream != null) {
                    content = IOHelper.readToString(errorStream);
                }
                String template = "HTTP request failed with code %1$d: %2$s";
                String message = String.format("HTTP request failed with code %1$d: %2$s", statusCode, content);
                throw new IOException(message);
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(errorStream);
                throw throwable;
            }
        }
    }

    private static String readToString(HttpURLConnection connection) throws IOException {
        return HttpClientImpl.readToString(connection.getInputStream());
    }

    private static String readErrorToString(HttpURLConnection connection) throws IOException {
        return HttpClientImpl.readToString(connection.getErrorStream());
    }

    private static String readToString(InputStream responseStream) throws IOException {
        String responseContent;
        try {
            responseContent = IOHelper.readToString(responseStream);
        }
        finally {
            IOHelper.closeQuietly(responseStream);
        }
        return responseContent;
    }

    HttpURLConnection createConnection(URI uri, String method, Action<HttpURLConnection> interceptor) {
        HttpURLConnection connection;
        URL url;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        try {
            connection.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            throw new Error(e);
        }
        for (Map.Entry<String, String> entry : this.Headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            connection.setRequestProperty(key, value);
        }
        if (interceptor != null) {
            interceptor.call(connection);
        }
        return connection;
    }

    private HttpURLConnection head(URI uri) throws IOException {
        return this.head(uri, null);
    }

    private HttpURLConnection head(URI uri, Action<HttpURLConnection> interceptor) throws IOException {
        HttpURLConnection connection = this.createConnection(uri, "HEAD", interceptor);
        connection.connect();
        return connection;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.Headers;
    }

    @Override
    public String getHeaderField(URI uri, String header) throws IOException {
        return this.getHeaderField(uri, header, new Action<HttpURLConnection>(){

            @Override
            public void call(HttpURLConnection conn) {
                conn.setInstanceFollowRedirects(false);
            }
        });
    }

    private String getHeaderField(URI uri, String header, Action<HttpURLConnection> interceptor) throws IOException {
        HttpURLConnection connection = this.head(uri, interceptor);
        return connection.getHeaderField(header);
    }

    private HttpURLConnection get(URI uri) throws IOException {
        return this.get(uri, null);
    }

    private HttpURLConnection get(URI uri, Action<HttpURLConnection> interceptor) throws IOException {
        HttpURLConnection connection = this.createConnection(uri, "GET", interceptor);
        connection.setDoInput(true);
        return connection;
    }

    @Override
    public String getGetResponseText(URI uri) throws IOException {
        HttpURLConnection response = this.get(uri);
        this.ensureOK(response);
        return HttpClientImpl.readToString(response);
    }

    @Override
    public String getGetResponseText(URI uri, final int timeout) throws IOException {
        HttpURLConnection response = this.get(uri, new Action<HttpURLConnection>(){

            @Override
            public void call(HttpURLConnection httpURLConnection) {
                httpURLConnection.setConnectTimeout(timeout);
            }
        });
        this.ensureOK(response);
        return HttpClientImpl.readToString(response);
    }

    private HttpURLConnection post(URI uri, StringContent content) throws IOException {
        return this.post(uri, content, new Action<HttpURLConnection>(){

            @Override
            public void call(HttpURLConnection conn) {
                conn.setUseCaches(false);
            }
        });
    }

    private HttpURLConnection post(URI uri, StringContent content, Action<HttpURLConnection> interceptor) throws IOException {
        HttpURLConnection connection = this.createConnection(uri, "POST", interceptor);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        content.write(connection);
        return connection;
    }

    @Override
    public String getPostResponseText(URI uri, StringContent content) throws IOException {
        HttpURLConnection response = this.post(uri, content);
        this.ensureOK(response);
        return HttpClientImpl.readToString(response);
    }

    @Override
    public HttpResponse getPostResponse(URI uri, StringContent content) throws IOException {
        HttpResponse response = new HttpResponse();
        HttpURLConnection conn = this.post(uri, content);
        response.status = conn.getResponseCode();
        if (this.isSuccessful(response.status)) {
            response.responseText = HttpClientImpl.readToString(conn);
        } else {
            response.errorText = HttpClientImpl.readErrorToString(conn);
        }
        return response;
    }

    private boolean isSuccessful(int statusCode) {
        return statusCode > 199 && statusCode < 300;
    }
}

