/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.Guid;
import com.microsoft.alm.helpers.NotImplementedException;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.XmlHelper;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.secret.TokenType;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Token
extends Secret {
    private static final Logger logger = LoggerFactory.getLogger(Token.class);
    private static final int sizeofTokenType = 4;
    private static final int sizeofGuid = 16;
    public final TokenType Type;
    public final String Value;
    UUID targetIdentity = Guid.Empty;

    public static boolean getFriendlyNameFromType(TokenType type, AtomicReference<String> name) {
        name.set(null);
        name.set(type.getDescription() == null ? type.toString() : type.getDescription());
        return name.get() != null;
    }

    public static boolean getTypeFromFriendlyName(String name, AtomicReference<TokenType> type) {
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(name), "The name parameter is null or invalid");
        type.set(TokenType.Unknown);
        for (TokenType value : EnumSet.allOf(TokenType.class)) {
            type.set(value);
            AtomicReference<String> typename = new AtomicReference<String>();
            if (!Token.getFriendlyNameFromType(type.get(), typename) || !name.equalsIgnoreCase(typename.get())) continue;
            return true;
        }
        return false;
    }

    public Token(String value, TokenType type) {
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(value), "The value parameter is null or invalid");
        this.Type = type;
        this.Value = value;
    }

    public Token(String value, String typeName) {
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(value), "The value parameter is null or invalid");
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(typeName), "The typeName parameter is null or invalid");
        AtomicReference<TokenType> type = new AtomicReference<TokenType>();
        if (!Token.getTypeFromFriendlyName(typeName, type)) {
            throw new IllegalArgumentException("Unexpected token type '" + typeName + "' encountered");
        }
        this.Type = type.get();
        this.Value = value;
    }

    public static Token fromXml(Node tokenNode) {
        String tokenValue = null;
        TokenType tokenType = null;
        UUID targetIdentity = Guid.Empty;
        NodeList propertyNodes = tokenNode.getChildNodes();
        for (int v = 0; v < propertyNodes.getLength(); ++v) {
            Node propertyNode = propertyNodes.item(v);
            String propertyName = propertyNode.getNodeName();
            if ("Type".equals(propertyName)) {
                tokenType = TokenType.valueOf(TokenType.class, XmlHelper.getText(propertyNode));
                continue;
            }
            if ("Value".equals(propertyName)) {
                tokenValue = XmlHelper.getText(propertyNode);
                continue;
            }
            if (!"targetIdentity".equals(propertyName)) continue;
            targetIdentity = UUID.fromString(XmlHelper.getText(propertyNode));
        }
        Token value = new Token(tokenValue, tokenType);
        value.setTargetIdentity(targetIdentity);
        return value;
    }

    public Element toXml(Document document) {
        Element valueNode = document.createElement("value");
        Element typeNode = document.createElement("Type");
        Text typeValue = document.createTextNode(this.Type.toString());
        typeNode.appendChild(typeValue);
        valueNode.appendChild(typeNode);
        Element tokenValueNode = document.createElement("Value");
        Text valueValue = document.createTextNode(this.Value);
        tokenValueNode.appendChild(valueValue);
        valueNode.appendChild(tokenValueNode);
        if (!Guid.Empty.equals(this.getTargetIdentity())) {
            Element targetIdentityNode = document.createElement("targetIdentity");
            Text targetIdentityValue = document.createTextNode(this.getTargetIdentity().toString());
            targetIdentityNode.appendChild(targetIdentityValue);
            valueNode.appendChild(targetIdentityNode);
        }
        return valueNode;
    }

    public UUID getTargetIdentity() {
        return this.targetIdentity;
    }

    public void setTargetIdentity(UUID targetIdentity) {
        this.targetIdentity = targetIdentity;
    }

    public boolean equals(Object obj) {
        return Token.operatorEquals(this, obj instanceof Token ? (Token)obj : null);
    }

    public int hashCode() {
        return this.Type.getValue() * this.Value.hashCode();
    }

    public String toString() {
        AtomicReference<String> value = new AtomicReference<String>();
        if (Token.getFriendlyNameFromType(this.Type, value)) {
            return value.get();
        }
        return super.toString();
    }

    public void contributeHeader(Map<String, String> headers) {
        switch (this.Type) {
            case Access: {
                String prefix = "Bearer";
                headers.put("Authorization", "Bearer " + this.Value);
                break;
            }
            case Personal: {
                byte[] authData = StringHelper.UTF8GetBytes("PersonalAccessToken:" + this.Value);
                String base64EncodedAuthData = DatatypeConverter.printBase64Binary((byte[])authData);
                headers.put("Authorization", "Basic " + base64EncodedAuthData);
                break;
            }
            case Federated: {
                throw new NotImplementedException(449222);
            }
            default: {
                String template = "Tokens of type '%1$s' cannot be used for headers.";
                String message = String.format("Tokens of type '%1$s' cannot be used for headers.", new Object[]{this.Type});
                throw new IllegalStateException(message);
            }
        }
    }

    static boolean deserialize(byte[] bytes, TokenType type, AtomicReference<Token> tokenReference) {
        Debug.Assert(bytes != null, "The bytes parameter is null");
        Debug.Assert(bytes.length > 0, "The bytes parameter is too short");
        Debug.Assert(type != null, "The type parameter is invalid");
        tokenReference.set(null);
        try {
            String value;
            int preamble = 20;
            if (bytes.length > 20) {
                String value2;
                ByteBuffer p = ByteBuffer.wrap(bytes);
                TokenType readType = TokenType.fromValue(Integer.reverseBytes(p.getInt()));
                byte[] guidBytes = new byte[16];
                p.get(guidBytes);
                UUID targetIdentity = Guid.fromBytes(guidBytes);
                if (readType == type && !StringHelper.isNullOrWhiteSpace(value2 = StringHelper.UTF8GetString(bytes, 20, bytes.length - 20))) {
                    tokenReference.set(new Token(value2, type));
                    tokenReference.get().targetIdentity = targetIdentity;
                }
            }
            if (tokenReference.get() == null && !StringHelper.isNullOrWhiteSpace(value = StringHelper.UTF8GetString(bytes))) {
                tokenReference.set(new Token(value, type));
            }
        }
        catch (Throwable throwable) {
            logger.debug("   token deserialization error");
        }
        return tokenReference.get() != null;
    }

    static boolean serialize(Token token, AtomicReference<byte[]> byteReference) {
        Debug.Assert(token != null, "The token parameter is null");
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(token.Value), "The token.Value is invalid");
        byteReference.set(null);
        try {
            byte[] utf8bytes = StringHelper.UTF8GetBytes(token.Value);
            ByteBuffer bytes = ByteBuffer.allocate(utf8bytes.length + 4 + 16);
            bytes.putInt(Integer.reverseBytes(token.Type.getValue()));
            bytes.put(Guid.toBytes(token.targetIdentity));
            bytes.put(utf8bytes);
            byteReference.set(bytes.array());
        }
        catch (Throwable t) {
            logger.debug("   token serialization error");
        }
        return byteReference.get() != null;
    }

    public static void validate(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("The `token` parameter is null or invalid.");
        }
        if (StringHelper.isNullOrWhiteSpace(token.Value)) {
            throw new IllegalArgumentException("The value of the `token` cannot be null or empty.");
        }
        if (token.Value.length() > 2047) {
            throw new IllegalArgumentException(String.format("The value of the `token` cannot be longer than %1$d characters.", 2047));
        }
    }

    public static Credential toCredential(Token token) {
        if (token == null) {
            return null;
        }
        if (token.Type != TokenType.Personal) {
            throw new IllegalArgumentException("Cannot convert " + token.toString() + " to credentials");
        }
        return new Credential(token.toString(), token.Value);
    }

    public static boolean operatorEquals(Token token1, Token token2) {
        if (token1 == token2) {
            return true;
        }
        if (token1 == null || null == token2) {
            return false;
        }
        return token1.Type == token2.Type && token1.Value.equalsIgnoreCase(token2.Value);
    }

    public static boolean operatorNotEquals(Token token1, Token token2) {
        return !Token.operatorEquals(token1, token2);
    }
}

