/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.SystemHelper;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.storage.InsecureFileBackedCredentialStore;
import com.microsoft.alm.storage.InsecureFileBackedTokenStore;
import com.microsoft.alm.storage.InsecureInMemoryStore;
import com.microsoft.alm.storage.SecretStore;
import com.microsoft.alm.storage.macosx.KeychainSecurityBackedCredentialStore;
import com.microsoft.alm.storage.macosx.KeychainSecurityBackedTokenPairStore;
import com.microsoft.alm.storage.macosx.KeychainSecurityBackedTokenStore;
import com.microsoft.alm.storage.posix.GnomeKeyringBackedCredentialStore;
import com.microsoft.alm.storage.posix.GnomeKeyringBackedTokenPairStore;
import com.microsoft.alm.storage.posix.GnomeKeyringBackedTokenStore;
import com.microsoft.alm.storage.posix.internal.GnomeKeyringBackedSecureStore;
import com.microsoft.alm.storage.windows.CredManagerBackedCredentialStore;
import com.microsoft.alm.storage.windows.CredManagerBackedTokenPairStore;
import com.microsoft.alm.storage.windows.CredManagerBackedTokenStore;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProvider {
    private static Logger logger = LoggerFactory.getLogger(StorageProvider.class);
    private static final List<SecretStore<Token>> PERSISTED_TOKEN_STORE_CANDIDATES;
    private static final List<SecretStore<TokenPair>> PERSISTED_TOKENPAIR_STORE_CANDIDATES;
    private static final List<SecretStore<Credential>> PERSISTED_CREDENTIAL_STORE_CANDIDATES;

    public static SecretStore<Token> getTokenStorage(boolean persist, SecureOption secureOption) {
        Debug.Assert((secureOption != null ? 1 : 0) != 0, (String)"secureOption cannot be null");
        logger.info("Getting a {} token store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.MUST ? "must" : "could"));
        NonPersistentStoreGenerator<Token> inMemoryStoreGenerator = new NonPersistentStoreGenerator<Token>(){

            @Override
            public SecretStore<Token> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore();
            }

            @Override
            public SecretStore<Token> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_TOKEN_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    public static SecretStore<TokenPair> getTokenPairStorage(boolean persist, SecureOption secureOption) {
        Debug.Assert((secureOption != null ? 1 : 0) != 0, (String)"secureOption cannot be null");
        logger.info("Getting a {} tokenPair store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.MUST ? "must" : "could"));
        NonPersistentStoreGenerator<TokenPair> inMemoryStoreGenerator = new NonPersistentStoreGenerator<TokenPair>(){

            @Override
            public SecretStore<TokenPair> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore();
            }

            @Override
            public SecretStore<TokenPair> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_TOKENPAIR_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    public static SecretStore<Credential> getCredentialStorage(boolean persist, SecureOption secureOption) {
        Debug.Assert((secureOption != null ? 1 : 0) != 0, (String)"secureOption cannot be null");
        logger.info("Getting a {} credential store that {} be secure", (Object)(persist ? "persistent" : "non-persistent"), (Object)(secureOption == SecureOption.MUST ? "must" : "could"));
        NonPersistentStoreGenerator<Credential> inMemoryStoreGenerator = new NonPersistentStoreGenerator<Credential>(){

            @Override
            public SecretStore<Credential> getInsecureNonPersistentStore() {
                return new InsecureInMemoryStore();
            }

            @Override
            public SecretStore<Credential> getSecureNonPersistentStore() {
                logger.warn("Do not have any secure non-persistent stores available.");
                return null;
            }
        };
        return StorageProvider.getStore(persist, secureOption, PERSISTED_CREDENTIAL_STORE_CANDIDATES, inMemoryStoreGenerator);
    }

    private static <E extends Secret> SecretStore<E> findSecureStore(List<SecretStore<E>> stores) {
        for (SecretStore<E> store : stores) {
            if (!store.isSecure()) continue;
            return store;
        }
        return null;
    }

    private static <E extends Secret> SecretStore<E> findPersistedStore(SecureOption secureOption, List<SecretStore<E>> stores) {
        SecretStore<E> candidate = StorageProvider.findSecureStore(stores);
        if (candidate == null && secureOption == SecureOption.PREFER && !stores.isEmpty()) {
            candidate = stores.get(0);
        }
        return candidate;
    }

    static <E extends Secret> SecretStore<E> getStore(boolean persist, SecureOption secureOption, List<SecretStore<E>> stores, NonPersistentStoreGenerator<E> nonPersistentStoreGenerator) {
        SecretStore<E> candidate;
        Debug.Assert((nonPersistentStoreGenerator != null ? 1 : 0) != 0, (String)"nonPersistentStoreGenerator cannot be null.");
        Debug.Assert((stores != null ? 1 : 0) != 0, (String)"stores cannot be null.");
        if (persist) {
            candidate = StorageProvider.findPersistedStore(secureOption, stores);
        } else {
            candidate = nonPersistentStoreGenerator.getSecureNonPersistentStore();
            if (candidate == null && secureOption == SecureOption.PREFER) {
                candidate = nonPersistentStoreGenerator.getInsecureNonPersistentStore();
            }
        }
        return candidate;
    }

    static {
        ArrayList<SecretStore<Token>> tokenStoreCandidates = new ArrayList<SecretStore<Token>>();
        ArrayList<SecretStore<TokenPair>> tokenPairStoreCandidates = new ArrayList<SecretStore<TokenPair>>();
        ArrayList<SecretStore<Credential>> credentialStoreCandidates = new ArrayList<SecretStore<Credential>>();
        if (SystemHelper.isWindows()) {
            tokenStoreCandidates.add(new CredManagerBackedTokenStore());
            credentialStoreCandidates.add(new CredManagerBackedCredentialStore());
            tokenPairStoreCandidates.add(new CredManagerBackedTokenPairStore());
        }
        if (SystemHelper.isMac()) {
            tokenStoreCandidates.add(new KeychainSecurityBackedTokenStore());
            credentialStoreCandidates.add(new KeychainSecurityBackedCredentialStore());
            tokenPairStoreCandidates.add(new KeychainSecurityBackedTokenPairStore());
        }
        if (SystemHelper.isLinux() && GnomeKeyringBackedSecureStore.isGnomeKeyringSupported()) {
            tokenStoreCandidates.add(new GnomeKeyringBackedTokenStore());
            credentialStoreCandidates.add(new GnomeKeyringBackedCredentialStore());
            tokenPairStoreCandidates.add(new GnomeKeyringBackedTokenPairStore());
        }
        tokenStoreCandidates.add((SecretStore<Token>)new InsecureFileBackedTokenStore());
        credentialStoreCandidates.add((SecretStore<Credential>)new InsecureFileBackedCredentialStore());
        PERSISTED_TOKEN_STORE_CANDIDATES = tokenStoreCandidates;
        PERSISTED_TOKENPAIR_STORE_CANDIDATES = tokenPairStoreCandidates;
        PERSISTED_CREDENTIAL_STORE_CANDIDATES = credentialStoreCandidates;
    }

    static interface NonPersistentStoreGenerator<E extends Secret> {
        public SecretStore<E> getInsecureNonPersistentStore();

        public SecretStore<E> getSecureNonPersistentStore();
    }

    public static enum SecureOption {
        MUST,
        PREFER;

    }
}

