/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.Flags;
import com.microsoft.appcenter.analytics.AnalyticsTransmissionTarget;
import com.microsoft.appcenter.analytics.EventProperties;
import com.microsoft.appcenter.analytics.channel.AnalyticsListener;
import com.microsoft.appcenter.analytics.channel.AnalyticsValidator;
import com.microsoft.appcenter.analytics.channel.SessionTracker;
import com.microsoft.appcenter.analytics.ingestion.models.EventLog;
import com.microsoft.appcenter.analytics.ingestion.models.PageLog;
import com.microsoft.appcenter.analytics.ingestion.models.json.EventLogFactory;
import com.microsoft.appcenter.analytics.ingestion.models.json.PageLogFactory;
import com.microsoft.appcenter.analytics.ingestion.models.json.StartSessionLogFactory;
import com.microsoft.appcenter.analytics.ingestion.models.one.json.CommonSchemaEventLogFactory;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.json.LogFactory;
import com.microsoft.appcenter.ingestion.models.properties.StringTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.UUIDUtils;
import com.microsoft.appcenter.utils.UserIdContext;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Analytics
extends AbstractAppCenterService {
    private static final String SERVICE_NAME = "Analytics";
    public static final String LOG_TAG = "AppCenterAnalytics";
    static final String ANALYTICS_GROUP = "group_analytics";
    private static final String ACTIVITY_SUFFIX = "Activity";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Analytics sInstance;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private final Map<String, AnalyticsTransmissionTarget> mTransmissionTargets;
    @VisibleForTesting
    AnalyticsTransmissionTarget mDefaultTransmissionTarget;
    private WeakReference<Activity> mCurrentActivity;
    private Context mContext;
    private boolean mStartedFromApp;
    private SessionTracker mSessionTracker;
    private AnalyticsValidator mAnalyticsValidator;
    private Channel.Listener mAnalyticsTransmissionTargetListener;
    private AnalyticsListener mAnalyticsListener;
    private boolean mAutoPageTrackingEnabled = false;

    private Analytics() {
        this.mFactories.put("startSession", (LogFactory)new StartSessionLogFactory());
        this.mFactories.put("page", (LogFactory)new PageLogFactory());
        this.mFactories.put("event", (LogFactory)new EventLogFactory());
        this.mFactories.put("commonSchemaEvent", (LogFactory)new CommonSchemaEventLogFactory());
        this.mTransmissionTargets = new HashMap<String, AnalyticsTransmissionTarget>();
    }

    public static synchronized Analytics getInstance() {
        if (sInstance == null) {
            sInstance = new Analytics();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Analytics.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Analytics.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static void pause() {
        Analytics.getInstance().pauseInstanceAsync();
    }

    public static void resume() {
        Analytics.getInstance().resumeInstanceAsync();
    }

    @VisibleForTesting
    protected static void setListener(AnalyticsListener listener) {
        Analytics.getInstance().setInstanceListener(listener);
    }

    protected static boolean isAutoPageTrackingEnabled() {
        return Analytics.getInstance().isInstanceAutoPageTrackingEnabled();
    }

    protected static void setAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        Analytics.getInstance().setInstanceAutoPageTrackingEnabled(autoPageTrackingEnabled);
    }

    protected static void trackPage(String name) {
        Analytics.trackPage(name, null);
    }

    protected static void trackPage(String name, Map<String, String> properties) {
        Analytics.getInstance().trackPageAsync(name, properties);
    }

    public static void trackEvent(String name) {
        Analytics.trackEvent(name, null, null, 1);
    }

    public static void trackEvent(String name, Map<String, String> properties) {
        Analytics.getInstance().trackEventAsync(name, Analytics.convertProperties(properties), null, 1);
    }

    public static void trackEvent(String name, Map<String, String> properties, int flags) {
        Analytics.getInstance().trackEventAsync(name, Analytics.convertProperties(properties), null, flags);
    }

    public static void trackEvent(String name, EventProperties properties) {
        Analytics.trackEvent(name, properties, 1);
    }

    public static void trackEvent(String name, EventProperties properties, int flags) {
        Analytics.trackEvent(name, properties, null, flags);
    }

    static void trackEvent(String name, EventProperties properties, AnalyticsTransmissionTarget transmissionTarget, int flags) {
        Analytics.getInstance().trackEventAsync(name, Analytics.convertProperties(properties), transmissionTarget, flags);
    }

    private static List<TypedProperty> convertProperties(EventProperties properties) {
        if (properties == null) {
            return null;
        }
        return new ArrayList<TypedProperty>(properties.getProperties().values());
    }

    private static List<TypedProperty> convertProperties(Map<String, String> properties) {
        if (properties == null) {
            return null;
        }
        ArrayList<TypedProperty> typedProperties = new ArrayList<TypedProperty>(properties.size());
        for (Map.Entry<String, String> property : properties.entrySet()) {
            StringTypedProperty typedProperty = new StringTypedProperty();
            typedProperty.setName(property.getKey());
            typedProperty.setValue(property.getValue());
            typedProperties.add((TypedProperty)typedProperty);
        }
        return typedProperties;
    }

    public static AnalyticsTransmissionTarget getTransmissionTarget(String transmissionTargetToken) {
        return Analytics.getInstance().getInstanceTransmissionTarget(transmissionTargetToken);
    }

    private static String generatePageName(Class<?> activityClass) {
        String suffix;
        String name = activityClass.getSimpleName();
        if (name.endsWith(suffix = ACTIVITY_SUFFIX) && name.length() > suffix.length()) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    private synchronized AnalyticsTransmissionTarget getInstanceTransmissionTarget(String transmissionTargetToken) {
        if (transmissionTargetToken == null || transmissionTargetToken.isEmpty()) {
            AppCenterLog.error((String)LOG_TAG, (String)"Transmission target token may not be null or empty.");
            return null;
        }
        if (!AppCenter.isConfigured()) {
            AppCenterLog.error((String)LOG_TAG, (String)"Cannot create transmission target, AppCenter is not configured or started.");
            return null;
        }
        AnalyticsTransmissionTarget transmissionTarget = this.mTransmissionTargets.get(transmissionTargetToken);
        if (transmissionTarget != null) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Returning transmission target found with token " + transmissionTargetToken));
            return transmissionTarget;
        }
        transmissionTarget = this.createAnalyticsTransmissionTarget(transmissionTargetToken);
        this.mTransmissionTargets.put(transmissionTargetToken, transmissionTarget);
        return transmissionTarget;
    }

    private AnalyticsTransmissionTarget createAnalyticsTransmissionTarget(String transmissionTargetToken) {
        final AnalyticsTransmissionTarget transmissionTarget = new AnalyticsTransmissionTarget(transmissionTargetToken, null);
        AppCenterLog.debug((String)LOG_TAG, (String)("Created transmission target with token " + transmissionTargetToken));
        this.postCommandEvenIfDisabled(new Runnable(){

            @Override
            public void run() {
                transmissionTarget.initInBackground(Analytics.this.mContext, Analytics.this.mChannel);
            }
        });
        return transmissionTarget;
    }

    public boolean isAppSecretRequired() {
        return false;
    }

    protected String getGroupName() {
        return ANALYTICS_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    public synchronized void onActivityResumed(final Activity activity) {
        final Runnable updateCurrentActivityRunnable = new Runnable(){

            @Override
            public void run() {
                Analytics.this.mCurrentActivity = new WeakReference<Activity>(activity);
            }
        };
        this.post(new Runnable(){

            @Override
            public void run() {
                updateCurrentActivityRunnable.run();
                Analytics.this.processOnResume(activity);
            }
        }, updateCurrentActivityRunnable, updateCurrentActivityRunnable);
    }

    private void processOnResume(Activity activity) {
        if (this.mSessionTracker != null) {
            this.mSessionTracker.onActivityResumed();
            if (this.mAutoPageTrackingEnabled) {
                this.queuePage(Analytics.generatePageName(activity.getClass()), null);
            }
        }
    }

    public synchronized void onActivityPaused(Activity activity) {
        final Runnable updateCurrentActivityRunnable = new Runnable(){

            @Override
            public void run() {
                Analytics.this.mCurrentActivity = null;
            }
        };
        this.post(new Runnable(){

            @Override
            public void run() {
                updateCurrentActivityRunnable.run();
                if (Analytics.this.mSessionTracker != null) {
                    Analytics.this.mSessionTracker.onActivityPaused();
                }
            }
        }, updateCurrentActivityRunnable, updateCurrentActivityRunnable);
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            public void onBeforeSending(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onBeforeSending(log);
                }
            }

            public void onSuccess(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingSucceeded(log);
                }
            }

            public void onFailure(Log log, Exception e) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingFailed(log, e);
                }
            }
        };
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        if (enabled) {
            this.startAppLevelFeatures();
        } else {
            if (this.mAnalyticsValidator != null) {
                this.mChannel.removeListener((Channel.Listener)this.mAnalyticsValidator);
                this.mAnalyticsValidator = null;
            }
            if (this.mSessionTracker != null) {
                this.mChannel.removeListener((Channel.Listener)this.mSessionTracker);
                this.mSessionTracker.clearSessions();
                this.mSessionTracker = null;
            }
            if (this.mAnalyticsTransmissionTargetListener != null) {
                this.mChannel.removeListener(this.mAnalyticsTransmissionTargetListener);
                this.mAnalyticsTransmissionTargetListener = null;
            }
        }
    }

    @WorkerThread
    private void startAppLevelFeatures() {
        if (this.mStartedFromApp) {
            Activity activity;
            this.mAnalyticsValidator = new AnalyticsValidator();
            this.mChannel.addListener((Channel.Listener)this.mAnalyticsValidator);
            this.mSessionTracker = new SessionTracker(this.mChannel, ANALYTICS_GROUP);
            this.mChannel.addListener((Channel.Listener)this.mSessionTracker);
            if (this.mCurrentActivity != null && (activity = (Activity)this.mCurrentActivity.get()) != null) {
                this.processOnResume(activity);
            }
            this.mAnalyticsTransmissionTargetListener = AnalyticsTransmissionTarget.getChannelListener();
            this.mChannel.addListener(this.mAnalyticsTransmissionTargetListener);
        }
    }

    private synchronized void trackPageAsync(final String name, Map<String, String> properties) {
        final HashMap<String, String> propertiesCopy = properties != null ? new HashMap<String, String>(properties) : null;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (Analytics.this.mStartedFromApp) {
                    Analytics.this.queuePage(name, propertiesCopy);
                } else {
                    AppCenterLog.error((String)Analytics.LOG_TAG, (String)"Cannot track page if not started from app.");
                }
            }
        });
    }

    @WorkerThread
    private void queuePage(String name, Map<String, String> properties) {
        PageLog pageLog = new PageLog();
        pageLog.setName(name);
        pageLog.setProperties(properties);
        this.mChannel.enqueue((Log)pageLog, ANALYTICS_GROUP, 1);
    }

    private synchronized void trackEventAsync(final String name, final List<TypedProperty> properties, final AnalyticsTransmissionTarget transmissionTarget, final int flags) {
        final String userId = UserIdContext.getInstance().getUserId();
        this.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                AnalyticsTransmissionTarget aTransmissionTarget = transmissionTarget == null ? Analytics.this.mDefaultTransmissionTarget : transmissionTarget;
                EventLog eventLog = new EventLog();
                if (aTransmissionTarget != null) {
                    if (!aTransmissionTarget.isEnabled()) {
                        AppCenterLog.error((String)Analytics.LOG_TAG, (String)"This transmission target is disabled.");
                        return;
                    }
                    eventLog.addTransmissionTarget(aTransmissionTarget.getTransmissionTargetToken());
                    eventLog.setTag(aTransmissionTarget);
                    if (aTransmissionTarget == Analytics.this.mDefaultTransmissionTarget) {
                        eventLog.setUserId(userId);
                    }
                } else if (!Analytics.this.mStartedFromApp) {
                    AppCenterLog.error((String)Analytics.LOG_TAG, (String)"Cannot track event using Analytics.trackEvent if not started from app, please start from the application or use Analytics.getTransmissionTarget.");
                    return;
                }
                eventLog.setId(UUIDUtils.randomUUID());
                eventLog.setName(name);
                eventLog.setTypedProperties(properties);
                int filteredFlags = Flags.getPersistenceFlag((int)flags, (boolean)true);
                Analytics.this.mChannel.enqueue((Log)eventLog, Analytics.ANALYTICS_GROUP, filteredFlags);
            }
        });
    }

    private boolean isInstanceAutoPageTrackingEnabled() {
        return this.mAutoPageTrackingEnabled;
    }

    private synchronized void setInstanceAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        this.mAutoPageTrackingEnabled = autoPageTrackingEnabled;
    }

    private synchronized void setInstanceListener(AnalyticsListener listener) {
        this.mAnalyticsListener = listener;
    }

    private synchronized void pauseInstanceAsync() {
        this.post(new Runnable(){

            @Override
            public void run() {
                Analytics.this.mChannel.pauseGroup(Analytics.ANALYTICS_GROUP, null);
            }
        });
    }

    private synchronized void resumeInstanceAsync() {
        this.post(new Runnable(){

            @Override
            public void run() {
                Analytics.this.mChannel.resumeGroup(Analytics.ANALYTICS_GROUP, null);
            }
        });
    }

    @VisibleForTesting
    WeakReference<Activity> getCurrentActivity() {
        return this.mCurrentActivity;
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mContext = context;
        this.mStartedFromApp = startedFromApp;
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
        this.setDefaultTransmissionTarget(transmissionTargetToken);
    }

    public void onConfigurationUpdated(String appSecret, String transmissionTargetToken) {
        this.mStartedFromApp = true;
        this.startAppLevelFeatures();
        this.setDefaultTransmissionTarget(transmissionTargetToken);
    }

    @WorkerThread
    private void setDefaultTransmissionTarget(String transmissionTargetToken) {
        if (transmissionTargetToken != null) {
            this.mDefaultTransmissionTarget = this.createAnalyticsTransmissionTarget(transmissionTargetToken);
        }
    }

    <T> void postCommand(Runnable runnable, DefaultAppCenterFuture<T> future, T valueIfDisabledOrNotStarted) {
        this.postAsyncGetter(runnable, future, valueIfDisabledOrNotStarted);
    }

    protected synchronized void post(Runnable runnable) {
        super.post(runnable);
    }

    void postCommandEvenIfDisabled(Runnable runnable) {
        this.post(runnable, runnable, runnable);
    }

    String getEnabledPreferenceKeyPrefix() {
        return this.getEnabledPreferenceKey() + "/";
    }
}

