/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.support.annotation.NonNull;
import com.microsoft.appcenter.analytics.AnalyticsTransmissionTarget;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.one.AppExtension;
import com.microsoft.appcenter.ingestion.models.one.CommonSchemaLog;
import java.util.HashMap;
import java.util.Map;

public class PropertyConfigurator
extends AbstractChannelListener {
    private String mAppName;
    private String mAppVersion;
    private String mAppLocale;
    private AnalyticsTransmissionTarget mTransmissionTarget;
    private final Map<String, String> mEventProperties = new HashMap<String, String>();

    PropertyConfigurator(Channel channel, AnalyticsTransmissionTarget transmissionTarget) {
        this.mTransmissionTarget = transmissionTarget;
        if (channel != null) {
            channel.addListener((Channel.Listener)this);
        }
    }

    public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
        if (this.shouldOverridePartAProperties(log)) {
            AnalyticsTransmissionTarget target;
            AppExtension app = ((CommonSchemaLog)log).getExt().getApp();
            if (this.mAppName != null) {
                app.setName(this.mAppName);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppName = target.getPropertyConfigurator().getAppName();
                    if (parentAppName != null) {
                        app.setName(parentAppName);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppVersion != null) {
                app.setVer(this.mAppVersion);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppVersion = target.getPropertyConfigurator().getAppVersion();
                    if (parentAppVersion != null) {
                        app.setVer(parentAppVersion);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppLocale != null) {
                app.setLocale(this.mAppLocale);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppLocale = target.getPropertyConfigurator().getAppLocale();
                    if (parentAppLocale != null) {
                        app.setLocale(parentAppLocale);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
        }
    }

    private boolean shouldOverridePartAProperties(@NonNull Log log) {
        String targetToken = this.mTransmissionTarget.getTransmissionTargetToken();
        return log instanceof CommonSchemaLog && this.mTransmissionTarget.isEnabled() && log.getTransmissionTargetTokens().contains(targetToken);
    }

    private String getAppName() {
        return this.mAppName;
    }

    public void setAppName(String appName) {
        this.mAppName = appName;
    }

    private String getAppVersion() {
        return this.mAppVersion;
    }

    public void setAppVersion(String appVersion) {
        this.mAppVersion = appVersion;
    }

    private String getAppLocale() {
        return this.mAppLocale;
    }

    public void setAppLocale(String appLocale) {
        this.mAppLocale = appLocale;
    }

    public synchronized void setEventProperty(String key, String value) {
        this.mEventProperties.put(key, value);
    }

    public synchronized void removeEventProperty(String key) {
        this.mEventProperties.remove(key);
    }

    synchronized void mergeEventProperties(Map<String, String> mergedProperties) {
        for (Map.Entry<String, String> property : this.mEventProperties.entrySet()) {
            String key = property.getKey();
            if (mergedProperties.containsKey(key)) continue;
            mergedProperties.put(key, property.getValue());
        }
    }
}

