/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.content.ContentResolver;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.microsoft.appcenter.analytics.AnalyticsTransmissionTarget;
import com.microsoft.appcenter.analytics.EventProperties;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.one.AppExtension;
import com.microsoft.appcenter.ingestion.models.one.CommonSchemaLog;
import com.microsoft.appcenter.ingestion.models.one.DeviceExtension;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import java.util.Date;
import java.util.Map;

public class PropertyConfigurator
extends AbstractChannelListener {
    private static final String ANDROID_DEVICE_ID_PREFIX = "a:";
    private String mAppName;
    private String mAppVersion;
    private String mAppLocale;
    private boolean mDeviceIdEnabled;
    private final AnalyticsTransmissionTarget mTransmissionTarget;
    private final EventProperties mEventProperties = new EventProperties();

    PropertyConfigurator(AnalyticsTransmissionTarget transmissionTarget) {
        this.mTransmissionTarget = transmissionTarget;
    }

    public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
        if (this.shouldOverridePartAProperties(log)) {
            AnalyticsTransmissionTarget target;
            AppExtension app = ((CommonSchemaLog)log).getExt().getApp();
            DeviceExtension device = ((CommonSchemaLog)log).getExt().getDevice();
            if (this.mAppName != null) {
                app.setName(this.mAppName);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppName = target.getPropertyConfigurator().getAppName();
                    if (parentAppName != null) {
                        app.setName(parentAppName);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppVersion != null) {
                app.setVer(this.mAppVersion);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppVersion = target.getPropertyConfigurator().getAppVersion();
                    if (parentAppVersion != null) {
                        app.setVer(parentAppVersion);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppLocale != null) {
                app.setLocale(this.mAppLocale);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppLocale = target.getPropertyConfigurator().getAppLocale();
                    if (parentAppLocale != null) {
                        app.setLocale(parentAppLocale);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mDeviceIdEnabled) {
                String androidId = Settings.Secure.getString((ContentResolver)this.mTransmissionTarget.mContext.getContentResolver(), (String)"android_id");
                device.setLocalId(ANDROID_DEVICE_ID_PREFIX + androidId);
            }
        }
    }

    private boolean shouldOverridePartAProperties(@NonNull Log log) {
        String targetToken = this.mTransmissionTarget.getTransmissionTargetToken();
        return log instanceof CommonSchemaLog && this.mTransmissionTarget.isEnabled() && log.getTransmissionTargetTokens().contains(targetToken);
    }

    private String getAppName() {
        return this.mAppName;
    }

    public void setAppName(String appName) {
        this.mAppName = appName;
    }

    private String getAppVersion() {
        return this.mAppVersion;
    }

    public void setAppVersion(String appVersion) {
        this.mAppVersion = appVersion;
    }

    private String getAppLocale() {
        return this.mAppLocale;
    }

    public void setAppLocale(String appLocale) {
        this.mAppLocale = appLocale;
    }

    public synchronized void setEventProperty(String key, boolean value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, Date value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, double value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, long value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, String value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void removeEventProperty(String key) {
        this.mEventProperties.getProperties().remove(key);
    }

    public void collectDeviceId() {
        this.mDeviceIdEnabled = true;
    }

    synchronized void mergeEventProperties(EventProperties mergedProperties) {
        for (Map.Entry<String, TypedProperty> property : this.mEventProperties.getProperties().entrySet()) {
            String key = property.getKey();
            if (mergedProperties.getProperties().containsKey(key)) continue;
            mergedProperties.getProperties().put(key, property.getValue());
        }
    }
}

