/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics.channel;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.analytics.ingestion.models.EventLog;
import com.microsoft.appcenter.analytics.ingestion.models.LogWithNameAndProperties;
import com.microsoft.appcenter.analytics.ingestion.models.PageLog;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.properties.BooleanTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.DateTimeTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.DoubleTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.LongTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.StringTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import com.microsoft.appcenter.utils.AppCenterLog;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AnalyticsValidator
extends AbstractChannelListener {
    @VisibleForTesting
    static final int MAX_NAME_LENGTH = 256;
    @VisibleForTesting
    static final int MAX_PROPERTY_ITEM_LENGTH = 125;
    @VisibleForTesting
    static final int MAX_PROPERTY_COUNT = 20;

    private boolean validateLog(@NonNull LogWithNameAndProperties log) {
        String name = AnalyticsValidator.validateName(log.getName(), log.getType());
        if (name == null) {
            return false;
        }
        Map<String, String> validatedProperties = AnalyticsValidator.validateProperties(log.getProperties(), name, log.getType());
        log.setName(name);
        log.setProperties(validatedProperties);
        return true;
    }

    private boolean validateLog(@NonNull EventLog log) {
        String name = AnalyticsValidator.validateName(log.getName(), log.getType());
        if (name == null) {
            return false;
        }
        AnalyticsValidator.validateProperties(log.getTypedProperties());
        log.setName(name);
        return true;
    }

    private static String validateName(String name, String logType) {
        if (name == null || name.isEmpty()) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)(logType + " name cannot be null or empty."));
            return null;
        }
        if (name.length() > 256) {
            AppCenterLog.warn((String)"AppCenterAnalytics", (String)String.format("%s '%s' : name length cannot be longer than %s characters. Name will be truncated.", logType, name, 256));
            name = name.substring(0, 256);
        }
        return name;
    }

    private static Map<String, String> validateProperties(Map<String, String> properties, String logName, String logType) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String message;
            String key = property.getKey();
            String value = property.getValue();
            if (result.size() >= 20) {
                message = String.format("%s '%s' : properties cannot contain more than %s items. Skipping other properties.", logType, logName, 20);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                break;
            }
            if (key == null || key.isEmpty()) {
                message = String.format("%s '%s' : a property key cannot be null or empty. Property will be skipped.", logType, logName);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                continue;
            }
            if (value == null) {
                message = String.format("%s '%s' : property '%s' : property value cannot be null. Property '%s' will be skipped.", logType, logName, key, key);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                continue;
            }
            if (key.length() > 125) {
                message = String.format("%s '%s' : property '%s' : property key length cannot be longer than %s characters. Property key will be truncated.", logType, logName, key, 125);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                key = key.substring(0, 125);
            }
            if (value.length() > 125) {
                message = String.format("%s '%s' : property '%s' : property value cannot be longer than %s characters. Property value will be truncated.", logType, logName, key, 125);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                value = value.substring(0, 125);
            }
            result.put(key, value);
        }
        return result;
    }

    private static void validateProperties(List<TypedProperty> properties) {
        if (properties == null) {
            return;
        }
        int count = 0;
        boolean maxCountReached = false;
        ListIterator<TypedProperty> iterator = properties.listIterator();
        while (iterator.hasNext()) {
            String message;
            boolean copyNeededOnModification = true;
            TypedProperty property = iterator.next();
            String key = property.getName();
            if (count >= 20) {
                if (!maxCountReached) {
                    message = String.format("Typed properties cannot contain more than %s items. Skipping other properties.", 20);
                    AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                    maxCountReached = true;
                }
                iterator.remove();
                continue;
            }
            if (key == null || key.isEmpty()) {
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)"A typed property key cannot be null or empty. Property will be skipped.");
                iterator.remove();
                continue;
            }
            if (key.length() > 125) {
                message = String.format("Typed property '%s' : property key length cannot be longer than %s characters. Property key will be truncated.", key, 125);
                AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                key = key.substring(0, 125);
                property = AnalyticsValidator.copyProperty(property, key);
                iterator.set(property);
                copyNeededOnModification = false;
            }
            if (property instanceof StringTypedProperty) {
                StringTypedProperty stringTypedProperty = (StringTypedProperty)property;
                String value = stringTypedProperty.getValue();
                if (value == null) {
                    message = String.format("Typed property '%s' : property value cannot be null. Property '%s' will be skipped.", key, key);
                    AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                    iterator.remove();
                    continue;
                }
                if (value.length() > 125) {
                    message = String.format("A String property '%s' : property value cannot be longer than %s characters. Property value will be truncated.", key, 125);
                    AppCenterLog.warn((String)"AppCenterAnalytics", (String)message);
                    value = value.substring(0, 125);
                    if (copyNeededOnModification) {
                        stringTypedProperty = new StringTypedProperty();
                        stringTypedProperty.setName(key);
                        stringTypedProperty.setValue(value);
                        iterator.set((TypedProperty)stringTypedProperty);
                    } else {
                        stringTypedProperty.setValue(value);
                    }
                }
            }
            ++count;
        }
    }

    private static TypedProperty copyProperty(TypedProperty property, String newKey) {
        BooleanTypedProperty copy;
        String type = property.getType();
        if ("boolean".equals(type)) {
            BooleanTypedProperty typedCopy = new BooleanTypedProperty();
            typedCopy.setValue(((BooleanTypedProperty)property).getValue());
            copy = typedCopy;
        } else if ("dateTime".equals(type)) {
            DateTimeTypedProperty typedCopy = new DateTimeTypedProperty();
            typedCopy.setValue(((DateTimeTypedProperty)property).getValue());
            copy = typedCopy;
        } else if ("double".equals(type)) {
            DoubleTypedProperty typedCopy = new DoubleTypedProperty();
            typedCopy.setValue(((DoubleTypedProperty)property).getValue());
            copy = typedCopy;
        } else if ("long".equals(type)) {
            LongTypedProperty typedCopy = new LongTypedProperty();
            typedCopy.setValue(((LongTypedProperty)property).getValue());
            copy = typedCopy;
        } else {
            StringTypedProperty typedCopy = new StringTypedProperty();
            typedCopy.setValue(((StringTypedProperty)property).getValue());
            copy = typedCopy;
        }
        copy.setName(newKey);
        return copy;
    }

    public boolean shouldFilter(@NonNull Log log) {
        if (log instanceof PageLog) {
            return !this.validateLog((LogWithNameAndProperties)log);
        }
        if (log instanceof EventLog) {
            return !this.validateLog((EventLog)log);
        }
        return false;
    }
}

