/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.Constants;
import com.microsoft.appcenter.SessionContext;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.crashes.AbstractCrashesListener;
import com.microsoft.appcenter.crashes.CrashesListener;
import com.microsoft.appcenter.crashes.UncaughtExceptionHandler;
import com.microsoft.appcenter.crashes.WrapperSdkExceptionManager;
import com.microsoft.appcenter.crashes.ingestion.models.ErrorAttachmentLog;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.ingestion.models.HandledErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.json.ErrorAttachmentLogFactory;
import com.microsoft.appcenter.crashes.ingestion.models.json.HandledErrorLogFactory;
import com.microsoft.appcenter.crashes.ingestion.models.json.ManagedErrorLogFactory;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.crashes.model.NativeException;
import com.microsoft.appcenter.crashes.model.TestCrashException;
import com.microsoft.appcenter.crashes.utils.ErrorLogHelper;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.appcenter.ingestion.models.json.LogFactory;
import com.microsoft.appcenter.ingestion.models.json.LogSerializer;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.DeviceInfoHelper;
import com.microsoft.appcenter.utils.HandlerUtils;
import com.microsoft.appcenter.utils.UserIdContext;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.storage.FileManager;
import com.microsoft.appcenter.utils.storage.SharedPreferencesManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;

public class Crashes
extends AbstractAppCenterService {
    public static final int SEND = 0;
    public static final int DONT_SEND = 1;
    public static final int ALWAYS_SEND = 2;
    @VisibleForTesting
    public static final String PREF_KEY_ALWAYS_SEND = "com.microsoft.appcenter.crashes.always.send";
    @VisibleForTesting
    static final String ERROR_GROUP = "groupErrors";
    private static final String SERVICE_NAME = "Crashes";
    public static final String LOG_TAG = "AppCenterCrashes";
    private static final int MAX_ATTACHMENT_PER_CRASH = 2;
    private static final CrashesListener DEFAULT_ERROR_REPORTING_LISTENER = new DefaultCrashesListener();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Crashes sInstance = null;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private final Map<UUID, ErrorLogReport> mUnprocessedErrorReports;
    private final Map<UUID, ErrorLogReport> mErrorReportCache;
    private LogSerializer mLogSerializer;
    private Context mContext;
    private long mInitializeTimestamp;
    private UncaughtExceptionHandler mUncaughtExceptionHandler;
    private CrashesListener mCrashesListener;
    private ErrorReport mLastSessionErrorReport;
    private boolean mSavedUncaughtException;
    private boolean mAutomaticProcessing = true;

    private Crashes() {
        this.mFactories.put("managedError", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mFactories.put("handledError", (LogFactory)HandledErrorLogFactory.getInstance());
        this.mFactories.put("errorAttachment", (LogFactory)ErrorAttachmentLogFactory.getInstance());
        this.mLogSerializer = new DefaultLogSerializer();
        this.mLogSerializer.addLogFactory("managedError", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mLogSerializer.addLogFactory("errorAttachment", (LogFactory)ErrorAttachmentLogFactory.getInstance());
        this.mCrashesListener = DEFAULT_ERROR_REPORTING_LISTENER;
        this.mUnprocessedErrorReports = new LinkedHashMap<UUID, ErrorLogReport>();
        this.mErrorReportCache = new LinkedHashMap<UUID, ErrorLogReport>();
    }

    @NonNull
    public static synchronized Crashes getInstance() {
        if (sInstance == null) {
            sInstance = new Crashes();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Crashes.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Crashes.getInstance().setInstanceEnabledAsync(enabled);
    }

    static void trackException(@NonNull Throwable throwable) {
        Crashes.trackException(throwable, null);
    }

    static void trackException(@NonNull Throwable throwable, Map<String, String> properties) {
        Map<String, String> validatedProperties = ErrorLogHelper.validateProperties(properties, "HandledError");
        Crashes.getInstance().queueException(throwable, validatedProperties);
    }

    public static void generateTestCrash() {
        if (Constants.APPLICATION_DEBUGGABLE) {
            throw new TestCrashException();
        }
        AppCenterLog.warn((String)LOG_TAG, (String)"The application is not debuggable so SDK won't generate test crash");
    }

    public static void setListener(CrashesListener listener) {
        Crashes.getInstance().setInstanceListener(listener);
    }

    public static AppCenterFuture<String> getMinidumpDirectory() {
        return Crashes.getInstance().getNewMinidumpDirectoryAsync();
    }

    public static void notifyUserConfirmation(int userConfirmation) {
        Crashes.getInstance().handleUserConfirmation(userConfirmation);
    }

    public static AppCenterFuture<Boolean> hasCrashedInLastSession() {
        return Crashes.getInstance().hasInstanceCrashedInLastSession();
    }

    public static AppCenterFuture<ErrorReport> getLastSessionCrashReport() {
        return Crashes.getInstance().getInstanceLastSessionCrashReport();
    }

    private synchronized AppCenterFuture<String> getNewMinidumpDirectoryAsync() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)ErrorLogHelper.getNewMinidumpDirectory().getAbsolutePath());
            }
        }, future, null);
        return future;
    }

    private synchronized AppCenterFuture<Boolean> hasInstanceCrashedInLastSession() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)(Crashes.this.mLastSessionErrorReport != null ? 1 : 0));
            }
        }, future, false);
        return future;
    }

    private synchronized AppCenterFuture<ErrorReport> getInstanceLastSessionCrashReport() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)Crashes.this.mLastSessionErrorReport);
            }
        }, future, null);
        return future;
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        this.initialize();
        if (!enabled) {
            for (File file : ErrorLogHelper.getErrorStorageDirectory().listFiles()) {
                AppCenterLog.debug((String)LOG_TAG, (String)("Deleting file " + file));
                if (file.delete()) continue;
                AppCenterLog.warn((String)LOG_TAG, (String)("Failed to delete file " + file));
            }
            AppCenterLog.info((String)LOG_TAG, (String)"Deleted crashes local files");
        }
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mContext = context;
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
        if (this.isInstanceEnabled()) {
            this.processPendingErrors();
        }
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    protected String getGroupName() {
        return ERROR_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            private void processCallback(final Log log, final CallbackProcessor callbackProcessor) {
                Crashes.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (log instanceof ManagedErrorLog) {
                            ManagedErrorLog errorLog = (ManagedErrorLog)log;
                            final ErrorReport report = Crashes.this.buildErrorReport(errorLog);
                            UUID id = errorLog.getId();
                            if (report != null) {
                                if (callbackProcessor.shouldDeleteThrowable()) {
                                    Crashes.this.removeStoredThrowable(id);
                                }
                                HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        callbackProcessor.onCallBack(report);
                                    }
                                });
                            } else {
                                AppCenterLog.warn((String)Crashes.LOG_TAG, (String)("Cannot find crash report for the error log: " + id));
                            }
                        } else if (!(log instanceof ErrorAttachmentLog) && !(log instanceof HandledErrorLog)) {
                            AppCenterLog.warn((String)Crashes.LOG_TAG, (String)("A different type of log comes to crashes: " + log.getClass().getName()));
                        }
                    }
                });
            }

            public void onBeforeSending(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return false;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onBeforeSending(report);
                    }
                });
            }

            public void onSuccess(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingSucceeded(report);
                    }
                });
            }

            public void onFailure(Log log, final java.lang.Exception e) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingFailed(report, e);
                    }
                });
            }
        };
    }

    @VisibleForTesting
    synchronized long getInitializeTimestamp() {
        return this.mInitializeTimestamp;
    }

    private synchronized void queueException(final @NonNull Throwable throwable, Map<String, String> properties) {
        this.queueException(new ExceptionModelBuilder(){

            @Override
            public Exception buildExceptionModel() {
                return ErrorLogHelper.getModelExceptionFromThrowable(throwable);
            }
        }, properties);
    }

    synchronized void queueException(final @NonNull Exception modelException, Map<String, String> properties) {
        this.queueException(new ExceptionModelBuilder(){

            @Override
            public Exception buildExceptionModel() {
                return modelException;
            }
        }, properties);
    }

    private synchronized void queueException(final @NonNull ExceptionModelBuilder exceptionModelBuilder, final Map<String, String> properties) {
        this.post(new Runnable(){

            @Override
            public void run() {
                HandledErrorLog errorLog = new HandledErrorLog();
                errorLog.setId(UUID.randomUUID());
                errorLog.setUserId(UserIdContext.getInstance().getUserId());
                errorLog.setException(exceptionModelBuilder.buildExceptionModel());
                errorLog.setProperties(properties);
                Crashes.this.mChannel.enqueue((Log)errorLog, Crashes.ERROR_GROUP, 1);
            }
        });
    }

    private void initialize() {
        boolean enabled = this.isInstanceEnabled();
        long l = this.mInitializeTimestamp = enabled ? System.currentTimeMillis() : -1L;
        if (!enabled) {
            if (this.mUncaughtExceptionHandler != null) {
                this.mUncaughtExceptionHandler.unregister();
                this.mUncaughtExceptionHandler = null;
            }
        } else {
            this.mUncaughtExceptionHandler = new UncaughtExceptionHandler();
            this.mUncaughtExceptionHandler.register();
            this.processMinidumpFiles();
        }
    }

    private void processMinidumpFiles() {
        for (File logFile : ErrorLogHelper.getNewMinidumpFiles()) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Process pending minidump file: " + logFile));
            long minidumpDate = logFile.lastModified();
            File dest = new File(ErrorLogHelper.getPendingMinidumpDirectory(), logFile.getName());
            NativeException nativeException = new NativeException();
            Exception modelException = new Exception();
            modelException.setType("minidump");
            modelException.setWrapperSdkName("appcenter.ndk");
            modelException.setStackTrace(dest.getPath());
            ManagedErrorLog errorLog = new ManagedErrorLog();
            errorLog.setException(modelException);
            errorLog.setTimestamp(new Date(minidumpDate));
            errorLog.setFatal(true);
            errorLog.setId(UUID.randomUUID());
            SessionContext.SessionInfo session = SessionContext.getInstance().getSessionAt(minidumpDate);
            if (session != null && session.getAppLaunchTimestamp() <= minidumpDate) {
                errorLog.setAppLaunchTimestamp(new Date(session.getAppLaunchTimestamp()));
            } else {
                errorLog.setAppLaunchTimestamp(errorLog.getTimestamp());
            }
            errorLog.setProcessId(0);
            errorLog.setProcessName("");
            errorLog.setUserId(UserIdContext.getInstance().getUserId());
            try {
                errorLog.setDevice(DeviceInfoHelper.getDeviceInfo((Context)this.mContext));
                errorLog.getDevice().setWrapperSdkName("appcenter.ndk");
                this.saveErrorLogFiles(nativeException, errorLog);
                if (logFile.renameTo(dest)) continue;
                throw new IOException("Failed to move file");
            }
            catch (java.lang.Exception e) {
                logFile.delete();
                this.removeAllStoredErrorLogFiles(errorLog.getId());
                AppCenterLog.error((String)LOG_TAG, (String)("Failed to process new minidump file: " + logFile), (Throwable)e);
            }
        }
        File logFile = ErrorLogHelper.getLastErrorLogFile();
        while (logFile != null && logFile.length() == 0L) {
            AppCenterLog.warn((String)LOG_TAG, (String)("Deleting empty error file: " + logFile));
            logFile.delete();
            logFile = ErrorLogHelper.getLastErrorLogFile();
        }
        if (logFile != null) {
            AppCenterLog.debug((String)LOG_TAG, (String)"Processing crash report for the last session.");
            String logFileContents = FileManager.read((File)logFile);
            if (logFileContents == null) {
                AppCenterLog.error((String)LOG_TAG, (String)"Error reading last session error log.");
            } else {
                try {
                    ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logFileContents, null);
                    this.mLastSessionErrorReport = this.buildErrorReport(log);
                    AppCenterLog.debug((String)LOG_TAG, (String)"Processed crash report for the last session.");
                }
                catch (JSONException e) {
                    AppCenterLog.error((String)LOG_TAG, (String)"Error parsing last session error log.", (Throwable)e);
                }
            }
        }
    }

    private void processPendingErrors() {
        for (File logFile : ErrorLogHelper.getStoredErrorLogFiles()) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Process pending error file: " + logFile));
            String logfileContents = FileManager.read((File)logFile);
            if (logfileContents == null) continue;
            try {
                ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logfileContents, null);
                UUID id = log.getId();
                ErrorReport report = this.buildErrorReport(log);
                if (report == null) {
                    this.removeAllStoredErrorLogFiles(id);
                    continue;
                }
                if (!this.mAutomaticProcessing || this.mCrashesListener.shouldProcess(report)) {
                    if (!this.mAutomaticProcessing) {
                        AppCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + id.toString()));
                    }
                    this.mUnprocessedErrorReports.put(id, this.mErrorReportCache.get(id));
                    continue;
                }
                AppCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + id.toString()));
                this.removeAllStoredErrorLogFiles(id);
            }
            catch (JSONException e) {
                AppCenterLog.error((String)LOG_TAG, (String)("Error parsing error log. Deleting invalid file: " + logFile), (Throwable)e);
                logFile.delete();
            }
        }
        if (this.mAutomaticProcessing) {
            this.sendCrashReportsOrAwaitUserConfirmation();
        }
    }

    private boolean sendCrashReportsOrAwaitUserConfirmation() {
        final boolean alwaysSend = SharedPreferencesManager.getBoolean((String)PREF_KEY_ALWAYS_SEND, (boolean)false);
        HandlerUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Crashes.this.mUnprocessedErrorReports.size() > 0) {
                    if (alwaysSend) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"The flag for user confirmation is set to ALWAYS_SEND, will send logs.");
                        Crashes.this.handleUserConfirmation(0);
                        return;
                    }
                    if (!Crashes.this.mAutomaticProcessing) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"Automatic processing disabled, will wait for explicit user confirmation.");
                        return;
                    }
                    if (!Crashes.this.mCrashesListener.shouldAwaitUserConfirmation()) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned false, will send logs.");
                        Crashes.this.handleUserConfirmation(0);
                    } else {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned true, wait sending logs.");
                    }
                }
            }
        });
        return alwaysSend;
    }

    private void removeAllStoredErrorLogFiles(UUID id) {
        ErrorLogHelper.removeStoredErrorLogFile(id);
        this.removeStoredThrowable(id);
    }

    private void removeStoredThrowable(UUID id) {
        this.mErrorReportCache.remove(id);
        WrapperSdkExceptionManager.deleteWrapperExceptionData(id);
        ErrorLogHelper.removeStoredThrowableFile(id);
    }

    @VisibleForTesting
    UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.mUncaughtExceptionHandler;
    }

    @VisibleForTesting
    void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.mUncaughtExceptionHandler = handler;
    }

    @VisibleForTesting
    @Nullable
    ErrorReport buildErrorReport(ManagedErrorLog log) {
        UUID id = log.getId();
        if (this.mErrorReportCache.containsKey(id)) {
            ErrorReport report = this.mErrorReportCache.get(id).report;
            report.setDevice(log.getDevice());
            return report;
        }
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            Throwable throwable = null;
            if (file.length() > 0L) {
                try {
                    throwable = (Throwable)FileManager.readObject((File)file);
                }
                catch (IOException | ClassNotFoundException | StackOverflowError e) {
                    AppCenterLog.error((String)LOG_TAG, (String)("Cannot read throwable file " + file.getName()), (Throwable)e);
                }
            }
            ErrorReport report = ErrorLogHelper.getErrorReportFromErrorLog(log, throwable);
            this.mErrorReportCache.put(id, new ErrorLogReport(log, report));
            return report;
        }
        return null;
    }

    @VisibleForTesting
    CrashesListener getInstanceListener() {
        return this.mCrashesListener;
    }

    @VisibleForTesting
    synchronized void setInstanceListener(CrashesListener listener) {
        if (listener == null) {
            listener = DEFAULT_ERROR_REPORTING_LISTENER;
        }
        this.mCrashesListener = listener;
    }

    @VisibleForTesting
    private synchronized void handleUserConfirmation(final int userConfirmation) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (userConfirmation == 1) {
                    Iterator iterator = Crashes.this.mUnprocessedErrorReports.keySet().iterator();
                    while (iterator.hasNext()) {
                        UUID id = (UUID)iterator.next();
                        iterator.remove();
                        Crashes.this.removeAllStoredErrorLogFiles(id);
                    }
                } else {
                    if (userConfirmation == 2) {
                        SharedPreferencesManager.putBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)true);
                    }
                    Iterator unprocessedIterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                    while (unprocessedIterator.hasNext()) {
                        File dumpFile = null;
                        ErrorAttachmentLog dumpAttachment = null;
                        Map.Entry unprocessedEntry = unprocessedIterator.next();
                        ErrorLogReport errorLogReport = (ErrorLogReport)unprocessedEntry.getValue();
                        if (errorLogReport.report.getThrowable() instanceof NativeException) {
                            Exception exception = errorLogReport.log.getException();
                            dumpFile = new File(exception.getStackTrace());
                            exception.setStackTrace(null);
                            byte[] logfileContents = FileManager.readBytes((File)dumpFile);
                            dumpAttachment = ErrorAttachmentLog.attachmentWithBinary(logfileContents, "minidump.dmp", "application/octet-stream");
                        }
                        Crashes.this.mChannel.enqueue((Log)errorLogReport.log, Crashes.ERROR_GROUP, 2);
                        if (dumpAttachment != null) {
                            Crashes.this.sendErrorAttachment(errorLogReport.log.getId(), Collections.singleton(dumpAttachment));
                            dumpFile.delete();
                        }
                        if (Crashes.this.mAutomaticProcessing) {
                            Iterable<ErrorAttachmentLog> attachments = Crashes.this.mCrashesListener.getErrorAttachments(errorLogReport.report);
                            Crashes.this.sendErrorAttachment(errorLogReport.log.getId(), attachments);
                        }
                        unprocessedIterator.remove();
                        ErrorLogHelper.removeStoredErrorLogFile((UUID)unprocessedEntry.getKey());
                    }
                }
            }
        });
    }

    private void sendErrorAttachment(UUID errorId, Iterable<ErrorAttachmentLog> attachments) {
        if (attachments == null) {
            AppCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.getErrorAttachments returned null, no additional information will be attached to log: " + errorId.toString()));
        } else {
            int totalErrorAttachments = 0;
            for (ErrorAttachmentLog attachment : attachments) {
                if (attachment != null) {
                    attachment.setId(UUID.randomUUID());
                    attachment.setErrorId(errorId);
                    if (attachment.isValid()) {
                        ++totalErrorAttachments;
                        this.mChannel.enqueue((Log)attachment, ERROR_GROUP, 1);
                        continue;
                    }
                    AppCenterLog.error((String)LOG_TAG, (String)"Not all required fields are present in ErrorAttachmentLog.");
                    continue;
                }
                AppCenterLog.warn((String)LOG_TAG, (String)"Skipping null ErrorAttachmentLog in CrashesListener.getErrorAttachments.");
            }
            if (totalErrorAttachments > 2) {
                AppCenterLog.warn((String)LOG_TAG, (String)"A limit of 2 attachments per error report might be enforced by server.");
            }
        }
    }

    @VisibleForTesting
    void setLogSerializer(LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
    }

    void saveUncaughtException(Thread thread, Throwable throwable) {
        try {
            this.saveUncaughtException(thread, throwable, ErrorLogHelper.getModelExceptionFromThrowable(throwable));
        }
        catch (JSONException e) {
            AppCenterLog.error((String)LOG_TAG, (String)"Error serializing error log to JSON", (Throwable)e);
        }
        catch (IOException e) {
            AppCenterLog.error((String)LOG_TAG, (String)"Error writing error log to file", (Throwable)e);
        }
    }

    UUID saveUncaughtException(Thread thread, Throwable throwable, Exception modelException) throws JSONException, IOException {
        if (!((Boolean)Crashes.isEnabled().get()).booleanValue()) {
            return null;
        }
        if (this.mSavedUncaughtException) {
            return null;
        }
        this.mSavedUncaughtException = true;
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, thread, modelException, Thread.getAllStackTraces(), this.mInitializeTimestamp, true);
        return this.saveErrorLogFiles(throwable, errorLog);
    }

    @NonNull
    private UUID saveErrorLogFiles(Throwable throwable, ManagedErrorLog errorLog) throws JSONException, IOException {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        UUID errorLogId = errorLog.getId();
        String filename = errorLogId.toString();
        AppCenterLog.debug((String)LOG_TAG, (String)"Saving uncaught exception.");
        File errorLogFile = new File(errorStorageDirectory, filename + ".json");
        String errorLogString = this.mLogSerializer.serializeLog((Log)errorLog);
        FileManager.write((File)errorLogFile, (String)errorLogString);
        AppCenterLog.debug((String)LOG_TAG, (String)("Saved JSON content for ingestion into " + errorLogFile));
        File throwableFile = new File(errorStorageDirectory, filename + ".throwable");
        if (throwable != null) {
            try {
                FileManager.writeObject((File)throwableFile, (Serializable)throwable);
                AppCenterLog.debug((String)LOG_TAG, (String)("Saved Throwable as is for client side inspection in " + throwableFile + " throwable:"), (Throwable)throwable);
            }
            catch (StackOverflowError e) {
                AppCenterLog.error((String)LOG_TAG, (String)"Failed to store throwable", (Throwable)e);
                throwable = null;
                throwableFile.delete();
            }
        }
        if (throwable == null) {
            if (!throwableFile.createNewFile()) {
                throw new IOException(throwableFile.getName());
            }
            AppCenterLog.debug((String)LOG_TAG, (String)("Saved empty Throwable file in " + throwableFile));
        }
        return errorLogId;
    }

    void setAutomaticProcessing(boolean automaticProcessing) {
        this.mAutomaticProcessing = automaticProcessing;
    }

    AppCenterFuture<Collection<ErrorReport>> getUnprocessedErrorReports() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                ArrayList<ErrorReport> reports = new ArrayList<ErrorReport>(Crashes.this.mUnprocessedErrorReports.size());
                for (ErrorLogReport entry : Crashes.this.mUnprocessedErrorReports.values()) {
                    reports.add(entry.report);
                }
                future.complete(reports);
            }
        }, future, Collections.emptyList());
        return future;
    }

    AppCenterFuture<Boolean> sendCrashReportsOrAwaitUserConfirmation(final Collection<String> filteredReportIds) {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    UUID id = (UUID)entry.getKey();
                    String idString = ((ErrorLogReport)entry.getValue()).report.getId();
                    if (filteredReportIds != null && filteredReportIds.contains(idString)) {
                        AppCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + idString));
                        continue;
                    }
                    AppCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + idString));
                    Crashes.this.removeAllStoredErrorLogFiles(id);
                    iterator.remove();
                }
                future.complete((Object)Crashes.this.sendCrashReportsOrAwaitUserConfirmation());
            }
        }, future, false);
        return future;
    }

    void sendErrorAttachments(final String errorReportId, final Iterable<ErrorAttachmentLog> attachments) {
        this.post(new Runnable(){

            @Override
            public void run() {
                UUID errorId;
                try {
                    errorId = UUID.fromString(errorReportId);
                }
                catch (RuntimeException e) {
                    AppCenterLog.error((String)Crashes.LOG_TAG, (String)"Error report identifier has an invalid format for sending attachments.");
                    return;
                }
                Crashes.this.sendErrorAttachment(errorId, attachments);
            }
        });
    }

    private static class ErrorLogReport {
        private final ManagedErrorLog log;
        private final ErrorReport report;

        private ErrorLogReport(ManagedErrorLog log, ErrorReport report) {
            this.log = log;
            this.report = report;
        }
    }

    private static class DefaultCrashesListener
    extends AbstractCrashesListener {
        private DefaultCrashesListener() {
        }
    }

    private static interface CallbackProcessor {
        public boolean shouldDeleteThrowable();

        public void onCallBack(ErrorReport var1);
    }

    private static interface ExceptionModelBuilder {
        public Exception buildExceptionModel();
    }
}

