/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.crashes.Crashes;
import com.microsoft.appcenter.crashes.ingestion.models.ErrorAttachmentLog;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.crashes.utils.ErrorLogHelper;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.storage.FileManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WrapperSdkExceptionManager {
    @VisibleForTesting
    static final Map<String, byte[]> sWrapperExceptionDataContainer = new HashMap<String, byte[]>();
    private static final String DATA_FILE_EXTENSION = ".dat";

    @VisibleForTesting
    WrapperSdkExceptionManager() {
    }

    public static UUID saveWrapperException(Thread thread, Throwable throwable, Exception modelException, byte[] rawSerializedException) {
        try {
            UUID errorId = Crashes.getInstance().saveUncaughtException(thread, throwable, modelException);
            if (errorId != null && rawSerializedException != null) {
                sWrapperExceptionDataContainer.put(errorId.toString(), rawSerializedException);
                File dataFile = WrapperSdkExceptionManager.getFile(errorId);
                FileManager.writeObject((File)dataFile, (Serializable)rawSerializedException);
                AppCenterLog.debug((String)"AppCenterCrashes", (String)("Saved raw wrapper exception data into " + dataFile));
            }
            return errorId;
        }
        catch (java.lang.Exception e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to save wrapper exception data to file", (Throwable)e);
            return null;
        }
    }

    public static void deleteWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to delete wrapper exception data: null errorId");
            return;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        if (dataFile.exists()) {
            byte[] loadResult = WrapperSdkExceptionManager.loadWrapperExceptionData(errorId);
            if (loadResult == null) {
                AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to delete wrapper exception data: data not found");
            }
            FileManager.delete((File)dataFile);
        }
    }

    public static byte[] loadWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to load wrapper exception data: null errorId");
            return null;
        }
        byte[] dataBytes = sWrapperExceptionDataContainer.get(errorId.toString());
        if (dataBytes != null) {
            return dataBytes;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        if (dataFile.exists()) {
            try {
                dataBytes = (byte[])FileManager.readObject((File)dataFile);
                if (dataBytes != null) {
                    sWrapperExceptionDataContainer.put(errorId.toString(), dataBytes);
                }
                return dataBytes;
            }
            catch (IOException | ClassNotFoundException e) {
                AppCenterLog.error((String)"AppCenterCrashes", (String)("Cannot access wrapper exception data file " + dataFile.getName()), (Throwable)e);
            }
        }
        return null;
    }

    private static File getFile(@NonNull UUID errorId) {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        String filename = errorId.toString() + DATA_FILE_EXTENSION;
        return new File(errorStorageDirectory, filename);
    }

    public static void trackException(Exception modelException) {
        WrapperSdkExceptionManager.trackException(modelException, null);
    }

    public static void trackException(Exception modelException, Map<String, String> properties) {
        Map<String, String> validatedProperties = ErrorLogHelper.validateProperties(properties, "HandledError");
        Crashes.getInstance().queueException(modelException, validatedProperties);
    }

    public static void setAutomaticProcessing(boolean automaticProcessing) {
        Crashes.getInstance().setAutomaticProcessing(automaticProcessing);
    }

    public static AppCenterFuture<Collection<ErrorReport>> getUnprocessedErrorReports() {
        return Crashes.getInstance().getUnprocessedErrorReports();
    }

    public static AppCenterFuture<Boolean> sendCrashReportsOrAwaitUserConfirmation(Collection<String> filteredReportIds) {
        return Crashes.getInstance().sendCrashReportsOrAwaitUserConfirmation(filteredReportIds);
    }

    public static void sendErrorAttachments(String errorReportId, Iterable<ErrorAttachmentLog> attachments) {
        Crashes.getInstance().sendErrorAttachments(errorReportId, attachments);
    }
}

